/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.list;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import androidx.annotation.ArrayRes;
import androidx.annotation.CheckResult;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.RecyclerView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.MaterialDialogKt;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.list.PlainListDialogAdapter;
import com.afollestad.materialdialogs.utils.ColorExtKt;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.StringExtKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0001H\u0007\u001a\u0012\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u0001H\u0007\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0001H\u0007\u001a\u009a\u0001\u0010\t\u001a\u00020\u0001*\u00020\u00012\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122S\b\u0002\u0010\u0013\u001aM\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0014j\u0002`\u001bH\u0007\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"customListAdapter", "Lcom/afollestad/materialdialogs/MaterialDialog;", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "getItemSelector", "Landroid/graphics/drawable/Drawable;", "getListAdapter", "getRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "listItems", "res", "", "items", "", "", "disabledIndices", "", "waitForPositiveButton", "", "selection", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "dialog", "index", "text", "", "Lcom/afollestad/materialdialogs/list/ItemListener;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Ljava/lang/Integer;Ljava/util/List;[IZLkotlin/jvm/functions/Function3;)Lcom/afollestad/materialdialogs/MaterialDialog;", "core_release"})
public final class DialogListExtKt {
    @CheckResult
    @Nullable
    public static final RecyclerView getRecyclerView(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        return $receiver.getView$core_release().getContentLayout$core_release().getRecyclerView$core_release();
    }

    @CheckResult
    @Nullable
    public static final RecyclerView.Adapter<?> getListAdapter(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        RecyclerView recyclerView = DialogListExtKt.getRecyclerView($receiver);
        return recyclerView != null ? recyclerView.getAdapter() : null;
    }

    @CheckResult
    @NotNull
    public static final MaterialDialog customListAdapter(@NotNull MaterialDialog $receiver, @NotNull RecyclerView.Adapter<?> adapter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        $receiver.getView$core_release().getContentLayout$core_release().addRecyclerView($receiver, adapter);
        return $receiver;
    }

    @CheckResult
    @NotNull
    public static final MaterialDialog listItems(@NotNull MaterialDialog $receiver, @ArrayRes @Nullable Integer res, @Nullable List<String> items, @Nullable int[] disabledIndices, boolean waitForPositiveButton, @Nullable Function3<? super MaterialDialog, ? super Integer, ? super String, Unit> selection) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        MaterialDialogKt.assertOneSet("listItems", items, res);
        List list = items;
        if (list == null) {
            Object[] objectArray = StringExtKt.getStringArray($receiver, res);
            list = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        if (list == null) {
            return $receiver;
        }
        List array = list;
        RecyclerView.Adapter<?> adapter = DialogListExtKt.getListAdapter($receiver);
        if (adapter instanceof PlainListDialogAdapter) {
            ((PlainListDialogAdapter)adapter).replaceItems((List<String>)array, selection);
            if (disabledIndices != null) {
                ((PlainListDialogAdapter)adapter).disableItems(disabledIndices);
            }
            return $receiver;
        }
        return DialogListExtKt.customListAdapter($receiver, new PlainListDialogAdapter($receiver, array, disabledIndices, waitForPositiveButton, selection));
    }

    @CheckResult
    @NotNull
    public static /* synthetic */ MaterialDialog listItems$default(MaterialDialog materialDialog, Integer n, List list, int[] nArray, boolean bl, Function3 function3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            list = null;
        }
        if ((n2 & 4) != 0) {
            nArray = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            function3 = null;
        }
        return DialogListExtKt.listItems(materialDialog, n, list, nArray, bl, (Function3<? super MaterialDialog, ? super Integer, ? super String, Unit>)function3);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final Drawable getItemSelector(@NotNull MaterialDialog $receiver) {
        int rippleColor;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Drawable drawable = MDUtil.resolveDrawable$default(MDUtil.INSTANCE, context, null, R.attr.md_item_selector, null, 10, null);
        if (Build.VERSION.SDK_INT >= 21 && drawable instanceof RippleDrawable && (rippleColor = ColorExtKt.resolveColor$default($receiver, null, R.attr.md_ripple_color, 1, null)) != 0) {
            ((RippleDrawable)drawable).setColor(ColorStateList.valueOf((int)rippleColor));
        }
        return drawable;
    }
}

