/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatButton;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.Theme;
import com.afollestad.materialdialogs.utils.MDUtil;
import com.afollestad.materialdialogs.utils.ViewExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J%\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\r2\b\b\u0001\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/afollestad/materialdialogs/internal/button/DialogActionButton;", "Landroidx/appcompat/widget/AppCompatButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "disabledColor", "", "enabledColor", "paddingDefault", "paddingStacked", "setEnabled", "", "enabled", "", "update", "baseContext", "appContext", "stacked", "update$com_afollestad_material_dialogs_core", "updateTextColor", "color", "com.afollestad.material-dialogs.core"})
public final class DialogActionButton
extends AppCompatButton {
    private final int paddingDefault;
    private final int paddingStacked;
    private int enabledColor;
    private int disabledColor;

    public final void update$com_afollestad_material_dialogs_core(@NotNull Context baseContext, @NotNull Context appContext, boolean stacked) {
        int rippleColor;
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Theme theme = Theme.Companion.inferTheme(appContext);
        this.enabledColor = MDUtil.resolveColor$default(MDUtil.INSTANCE, appContext, null, R.attr.colorAccent, 2, null);
        int disabledColorRes = theme == Theme.LIGHT ? R.color.md_disabled_text_light_theme : R.color.md_disabled_text_dark_theme;
        this.disabledColor = MDUtil.resolveColor$default(MDUtil.INSTANCE, baseContext, disabledColorRes, null, 4, null);
        this.setTextColor(this.enabledColor);
        int selectorAttr = stacked ? R.attr.md_item_selector : R.attr.md_button_selector;
        Drawable bgDrawable = MDUtil.resolveDrawable$default(MDUtil.INSTANCE, baseContext, null, selectorAttr, null, 10, null);
        if (Build.VERSION.SDK_INT >= 21 && bgDrawable instanceof RippleDrawable && (rippleColor = MDUtil.resolveColor$default(MDUtil.INSTANCE, baseContext, null, R.attr.md_ripple_color, 2, null)) != 0) {
            ((RippleDrawable)bgDrawable).setColor(ColorStateList.valueOf((int)rippleColor));
        }
        this.setBackground(bgDrawable);
        int sidePadding = stacked ? this.paddingStacked : this.paddingDefault;
        ViewExtKt.updatePadding$default((View)this, sidePadding, 0, sidePadding, 0, 10, null);
        if (stacked) {
            ViewExtKt.setGravityEndCompat((TextView)this);
        } else {
            this.setGravity(17);
        }
        this.setEnabled(this.isEnabled());
    }

    public final void updateTextColor(@ColorInt int color2) {
        this.enabledColor = color2;
        this.setEnabled(this.isEnabled());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setTextColor(enabled ? this.enabledColor : this.disabledColor);
    }

    public DialogActionButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.paddingDefault = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_action_button_padding_horizontal);
        this.paddingStacked = MDUtil.INSTANCE.dimenPx(this, R.dimen.md_stacked_action_button_padding_horizontal);
        this.setClickable(true);
        this.setFocusable(true);
    }

    public /* synthetic */ DialogActionButton(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

