/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import com.afollestad.materialdialogs.MaterialDialog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a/\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a-\u0010\u0000\u001a\u0002H\t\"\u0004\b\u0000\u0010\t*\u00020\n2\b\b\u0001\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\f\u001a\u001b\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u001b\u0010\u0010\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u001b\u0010\u0011\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\u001b\u0010\u0016\u001a\u00020\u0007\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u0017\u001aC\u0010\u0018\u001a\u00020\u0013\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\t2\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\u001d\u001aC\u0010\u001e\u001a\u00020\u0013\"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\t2\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\u001d\u001a?\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 \"\b\b\u0000\u0010\t*\u00020\u0002*\u0002H\t2\u0019\b\u0004\u0010\"\u001a\u0013\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00130#\u00a2\u0006\u0002\b$H\u0080\b\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"inflate", "R", "Landroid/view/View;", "Landroid/view/ViewGroup;", "ctxt", "Landroid/content/Context;", "res", "", "(Landroid/view/ViewGroup;Landroid/content/Context;I)Landroid/view/View;", "T", "Lcom/afollestad/materialdialogs/MaterialDialog;", "root", "(Lcom/afollestad/materialdialogs/MaterialDialog;ILandroid/view/ViewGroup;)Ljava/lang/Object;", "isNotVisible", "", "(Landroid/view/View;)Z", "isRtl", "isVisible", "setGravityEndCompat", "", "Landroid/widget/TextView;", "setGravityStartCompat", "topMargin", "(Landroid/view/View;)I", "updateMargin", "left", "top", "right", "bottom", "(Landroid/view/View;IIII)V", "updatePadding", "waitForLayout", "Landroid/view/ViewTreeObserver;", "kotlin.jvm.PlatformType", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Landroid/view/View;Lkotlin/jvm/functions/Function1;)Landroid/view/ViewTreeObserver;", "com.afollestad.material-dialogs.core"})
public final class ViewExtKt {
    @NotNull
    public static final <R extends View> R inflate(@NotNull ViewGroup $receiver, @NotNull Context ctxt, @LayoutRes int res) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        View view = LayoutInflater.from((Context)ctxt).inflate(res, $receiver, false);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type R");
        }
        return (R)view;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ View inflate$default(ViewGroup viewGroup, Context context, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Context context2 = viewGroup.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            context = context2;
        }
        return ViewExtKt.inflate(viewGroup, context, n);
    }

    public static final <T> T inflate(@NotNull MaterialDialog $receiver, @LayoutRes int res, @Nullable ViewGroup root) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        return (T)LayoutInflater.from((Context)$receiver.getWindowContext()).inflate(res, root, false);
    }

    public static /* bridge */ /* synthetic */ Object inflate$default(MaterialDialog materialDialog, int n, ViewGroup viewGroup, int n2, Object object) {
        if ((n2 & 2) != 0) {
            viewGroup = null;
        }
        return ViewExtKt.inflate(materialDialog, n, viewGroup);
    }

    public static final <T extends View> void updatePadding(@NotNull T $receiver, int left, int top, int right, int bottom) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (left == $receiver.getPaddingLeft() && top == $receiver.getPaddingTop() && right == $receiver.getPaddingRight() && bottom == $receiver.getPaddingBottom()) {
            return;
        }
        $receiver.setPadding(left, top, right, bottom);
    }

    public static /* bridge */ /* synthetic */ void updatePadding$default(View view, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = view.getPaddingLeft();
        }
        if ((n5 & 2) != 0) {
            n2 = view.getPaddingTop();
        }
        if ((n5 & 4) != 0) {
            n3 = view.getPaddingRight();
        }
        if ((n5 & 8) != 0) {
            n4 = view.getPaddingBottom();
        }
        ViewExtKt.updatePadding(view, n, n2, n3, n4);
    }

    public static final <T extends View> int topMargin(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ViewGroup.LayoutParams layoutParams = $receiver.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        return ((ViewGroup.MarginLayoutParams)layoutParams).topMargin;
    }

    public static final <T extends View> void updateMargin(@NotNull T $receiver, int left, int top, int right, int bottom) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ViewGroup.LayoutParams layoutParams = $receiver.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
        if (left != -1) {
            layoutParams2.leftMargin = left;
        }
        if (top != -1) {
            layoutParams2.topMargin = top;
        }
        if (right != -1) {
            layoutParams2.rightMargin = right;
        }
        if (bottom != -1) {
            layoutParams2.bottomMargin = bottom;
        }
        $receiver.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    public static /* bridge */ /* synthetic */ void updateMargin$default(View view, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = -1;
        }
        if ((n5 & 2) != 0) {
            n2 = -1;
        }
        if ((n5 & 4) != 0) {
            n3 = -1;
        }
        if ((n5 & 8) != 0) {
            n4 = -1;
        }
        ViewExtKt.updateMargin(view, n, n2, n3, n4);
    }

    public static final <T extends View> ViewTreeObserver waitForLayout(@NotNull T $receiver, @NotNull Function1<? super T, Unit> f) {
        ViewTreeObserver viewTreeObserver;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        ViewTreeObserver $receiver2 = viewTreeObserver = $receiver.getViewTreeObserver();
        $receiver2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($receiver2, $receiver, f){
            final /* synthetic */ ViewTreeObserver receiver$0;
            final /* synthetic */ View receiver$0$inlined;
            final /* synthetic */ Function1 $f$inlined;
            {
                this.receiver$0 = $receiver;
                this.receiver$0$inlined = view;
                this.$f$inlined = function1;
            }

            public void onGlobalLayout() {
                this.receiver$0.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.$f$inlined.invoke((Object)this.receiver$0$inlined);
            }
        });
        return viewTreeObserver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T extends View> boolean isVisible(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver instanceof Button) {
            if (((Button)$receiver).getVisibility() != 0) return false;
            CharSequence charSequence = ((Button)$receiver).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"this.text");
            CharSequence charSequence2 = StringsKt.trim((CharSequence)charSequence);
            if (StringsKt.isBlank((CharSequence)charSequence2)) return false;
            return true;
        }
        if ($receiver.getVisibility() != 0) return false;
        return true;
    }

    public static final <T extends View> boolean isNotVisible(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return !ViewExtKt.isVisible($receiver);
    }

    public static final <T extends View> boolean isRtl(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"resources.configuration");
        return configuration.getLayoutDirection() == 1;
    }

    public static final void setGravityStartCompat(@NotNull TextView $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Build.VERSION.SDK_INT >= 17) {
            $receiver.setTextAlignment(5);
        } else {
            $receiver.setGravity(0x800003);
        }
    }

    public static final void setGravityEndCompat(@NotNull TextView $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Build.VERSION.SDK_INT >= 17) {
            $receiver.setTextAlignment(6);
        } else {
            $receiver.setGravity(0x800005);
        }
    }
}

