/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.IBinder;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.MaterialDialogKt;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.callbacks.DialogCallbackExtKt;
import com.afollestad.materialdialogs.checkbox.DialogCheckboxExtKt;
import com.afollestad.materialdialogs.internal.main.DialogLayout;
import com.afollestad.materialdialogs.internal.main.DialogScrollView;
import com.afollestad.materialdialogs.utils.ColorExtKt;
import com.afollestad.materialdialogs.utils.DimensExtKt;
import com.afollestad.materialdialogs.utils.DrawableExtKt;
import com.afollestad.materialdialogs.utils.FontExtKt;
import com.afollestad.materialdialogs.utils.StringExtKt;
import com.afollestad.materialdialogs.utils.ViewExtKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0001\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0016\u0010\t\u001a\u00020\u0002*\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u001a/\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001aE\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0003\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010 \u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010!\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\""}, d2={"addContentMessageView", "", "Lcom/afollestad/materialdialogs/MaterialDialog;", "res", "", "text", "", "(Lcom/afollestad/materialdialogs/MaterialDialog;Ljava/lang/Integer;Ljava/lang/CharSequence;)V", "addContentScrollView", "colorBackground", "color", "hideKeyboard", "invalidateDividers", "scrolledDown", "", "atBottom", "populateIcon", "imageView", "Landroid/widget/ImageView;", "iconRes", "icon", "Landroid/graphics/drawable/Drawable;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Landroid/widget/ImageView;Ljava/lang/Integer;Landroid/graphics/drawable/Drawable;)V", "populateText", "textView", "Landroid/widget/TextView;", "textRes", "fallback", "typeface", "Landroid/graphics/Typeface;", "(Lcom/afollestad/materialdialogs/MaterialDialog;Landroid/widget/TextView;Ljava/lang/Integer;Ljava/lang/CharSequence;ILandroid/graphics/Typeface;)V", "preShow", "setDefaults", "setWindowConstraints", "core_release"})
public final class DialogExtKt {
    public static final void setWindowConstraints(@NotNull MaterialDialog $receiver) {
        Resources resources;
        WindowManager wm;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Window window = $receiver.getWindow();
        if (window == null) {
            Intrinsics.throwNpe();
        }
        window.setSoftInputMode(16);
        Window window2 = $receiver.getWindow();
        if (window2 == null) {
            Intrinsics.throwNpe();
        }
        WindowManager windowManager = wm = window2.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"wm");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int windowWidth = size.x;
        int windowHeight = size.y;
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources $receiver2 = resources = context.getResources();
        int windowVerticalPadding = $receiver2.getDimensionPixelSize(R.dimen.md_dialog_vertical_margin);
        int windowHorizontalPadding = $receiver2.getDimensionPixelSize(R.dimen.md_dialog_horizontal_margin);
        int maxWidth = $receiver2.getDimensionPixelSize(R.dimen.md_dialog_max_width);
        int calculatedWidth = windowWidth - windowHorizontalPadding * 2;
        $receiver.getView$core_release().setMaxHeight(windowHeight - windowVerticalPadding * 2);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        Window window3 = $receiver.getWindow();
        if (window3 == null) {
            Intrinsics.throwNpe();
        }
        lp.copyFrom(window3.getAttributes());
        lp.width = Math.min(maxWidth, calculatedWidth);
        Window window4 = $receiver.getWindow();
        if (window4 == null) {
            Intrinsics.throwNpe();
        }
        window4.setAttributes(lp);
    }

    public static final void setDefaults(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        int backgroundColor = ColorExtKt.getColor$default($receiver, null, (Integer)R.attr.md_background_color, 1, null);
        if (backgroundColor == 0) {
            backgroundColor = ColorExtKt.getColor$default($receiver, null, (Integer)R.attr.colorBackgroundFloating, 1, null);
        }
        DialogExtKt.colorBackground($receiver, backgroundColor);
        $receiver.setTitleFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_title, 1, null));
        $receiver.setBodyFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_body, 1, null));
        $receiver.setButtonFont$core_release(FontExtKt.font$default($receiver, null, R.attr.md_font_button, 1, null));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final void invalidateDividers(@NotNull MaterialDialog $receiver, boolean scrolledDown, boolean atBottom) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        $receiver.getView$core_release().invalidateDividers$core_release(scrolledDown, atBottom);
    }

    public static final void addContentScrollView(@NotNull MaterialDialog $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        if ($receiver.getContentScrollView$core_release() == null) {
            $receiver.setContentScrollView$core_release((DialogScrollView)((Object)ViewExtKt.inflate($receiver, R.layout.md_dialog_stub_scrollview, (ViewGroup)$receiver.getView$core_release())));
            DialogScrollView dialogScrollView = $receiver.getContentScrollView$core_release();
            if (dialogScrollView == null) {
                Intrinsics.throwNpe();
            }
            dialogScrollView.setRootView($receiver.getView$core_release());
            DialogScrollView dialogScrollView2 = $receiver.getContentScrollView$core_release();
            if (dialogScrollView2 == null) {
                Intrinsics.throwNpe();
            }
            View view = dialogScrollView2.getChildAt(0);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            $receiver.setContentScrollViewFrame$core_release((LinearLayout)view);
            $receiver.getView$core_release().addView((View)$receiver.getContentScrollView$core_release(), 1);
        }
    }

    public static final void addContentMessageView(@NotNull MaterialDialog $receiver, @StringRes @Nullable Integer res, @Nullable CharSequence text) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        if ($receiver.getTextViewMessage$core_release() == null) {
            LinearLayout linearLayout = $receiver.getContentScrollViewFrame$core_release();
            if (linearLayout == null) {
                Intrinsics.throwNpe();
            }
            $receiver.setTextViewMessage$core_release((TextView)ViewExtKt.inflate($receiver, R.layout.md_dialog_stub_message, (ViewGroup)linearLayout));
            LinearLayout linearLayout2 = $receiver.getContentScrollViewFrame$core_release();
            if (linearLayout2 == null) {
                Intrinsics.throwNpe();
            }
            linearLayout2.addView((View)$receiver.getTextViewMessage$core_release());
            if ($receiver.getBodyFont() != null) {
                TextView textView = $receiver.getTextViewMessage$core_release();
                if (textView != null) {
                    textView.setTypeface($receiver.getBodyFont());
                }
            }
        }
        MaterialDialogKt.assertOneSet("message", text, res);
        TextView textView = $receiver.getTextViewMessage$core_release();
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        if ((charSequence = text) == null) {
            charSequence = StringExtKt.getString$default($receiver, res, null, 2, null);
        }
        textView.setText(charSequence);
    }

    public static final void preShow(@NotNull MaterialDialog $receiver) {
        DialogLayout dialogLayout;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        DialogCallbackExtKt.invokeAll($receiver.getPreShowListeners$core_release(), $receiver);
        DialogLayout $receiver2 = dialogLayout = $receiver.getView$core_release();
        if ($receiver2.getTitleLayout$core_release().shouldNotBeVisible()) {
            ViewExtKt.updatePadding$default($receiver2.getContentView$core_release(), 0, $receiver2.getFrameMarginVerticalLess$core_release(), 0, $receiver2.getFrameMarginVerticalLess$core_release(), 5, null);
        }
        if (ViewExtKt.isVisible((View)DialogCheckboxExtKt.getCheckBoxPrompt($receiver))) {
            ViewExtKt.updatePadding$default($receiver2.getContentView$core_release(), 0, 0, 0, 0, 7, null);
        }
    }

    public static final void populateIcon(@NotNull MaterialDialog $receiver, @NotNull ImageView imageView, @DrawableRes @Nullable Integer iconRes, @Nullable Drawable icon) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        Drawable drawable = DrawableExtKt.getDrawable$default($receiver.getWindowContext(), iconRes, null, icon, 4, null);
        if (drawable != null) {
            ViewParent viewParent = imageView.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            ((View)viewParent).setVisibility(0);
            imageView.setVisibility(0);
            imageView.setImageDrawable(drawable);
        } else {
            imageView.setVisibility(8);
        }
    }

    public static final void populateText(@NotNull MaterialDialog $receiver, @NotNull TextView textView, @StringRes @Nullable Integer textRes, @Nullable CharSequence text, @StringRes int fallback, @Nullable Typeface typeface) {
        CharSequence value;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        CharSequence charSequence = text;
        if (charSequence == null) {
            charSequence = value = StringExtKt.getString($receiver, textRes, fallback);
        }
        if (value != null) {
            ViewParent viewParent = textView.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.View");
            }
            ((View)viewParent).setVisibility(0);
            textView.setVisibility(0);
            textView.setText(value);
            if (typeface != null) {
                textView.setTypeface(typeface);
            }
        } else {
            textView.setVisibility(8);
        }
    }

    public static /* bridge */ /* synthetic */ void populateText$default(MaterialDialog materialDialog, TextView textView, Integer n, CharSequence charSequence, int n2, Typeface typeface, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            charSequence = null;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        DialogExtKt.populateText(materialDialog, textView, n, charSequence, n2, typeface);
    }

    public static final void hideKeyboard(@NotNull MaterialDialog $receiver) {
        IBinder windowToken;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Object object = $receiver.getWindowContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocus = $receiver.getCurrentFocus();
        IBinder iBinder = windowToken = currentFocus != null ? currentFocus.getWindowToken() : $receiver.getView$core_release().getWindowToken();
        if (windowToken != null) {
            imm.hideSoftInputFromWindow(windowToken, 0);
        }
    }

    @NotNull
    public static final MaterialDialog colorBackground(@NotNull MaterialDialog $receiver, @ColorInt int color2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius(DimensExtKt.dimen$default($receiver, null, R.attr.md_corner_radius, 0.0f, 5, null));
        drawable.setColor(color2);
        Window window = $receiver.getWindow();
        if (window == null) {
            Intrinsics.throwNpe();
        }
        window.setBackgroundDrawable((Drawable)drawable);
        return $receiver;
    }
}

