/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.util;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.ArrayRes;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.afollestad.materialdialogs.GravityEnum;
import com.afollestad.materialdialogs.MaterialDialog;

public class DialogUtils {
    @ColorInt
    public static int getDisabledColor(Context context) {
        int primaryColor = DialogUtils.resolveColor(context, 16842806);
        int disabledColor = DialogUtils.isColorDark(primaryColor) ? -16777216 : -1;
        return DialogUtils.adjustAlpha(disabledColor, 0.3f);
    }

    @ColorInt
    public static int adjustAlpha(@ColorInt int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2) {
        return DialogUtils.resolveColor(context, attr2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList resolveActionTextColorStateList(Context context, @AttrRes int colorAttr, ColorStateList fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{colorAttr});
        try {
            TypedValue value = a.peekValue(0);
            if (value == null) {
                ColorStateList colorStateList = fallback;
                return colorStateList;
            }
            if (value.type >= 28 && value.type <= 31) {
                ColorStateList colorStateList = DialogUtils.getActionTextStateList(context, value.data);
                return colorStateList;
            }
            ColorStateList stateList = a.getColorStateList(0);
            if (stateList != null) {
                ColorStateList colorStateList = stateList;
                return colorStateList;
            }
            ColorStateList colorStateList = fallback;
            return colorStateList;
        }
        finally {
            a.recycle();
        }
    }

    public static ColorStateList getActionTextColorStateList(Context context, @ColorRes int colorId) {
        TypedValue value = new TypedValue();
        context.getResources().getValue(colorId, value, true);
        if (value.type >= 28 && value.type <= 31) {
            return DialogUtils.getActionTextStateList(context, value.data);
        }
        if (Build.VERSION.SDK_INT <= 22) {
            return context.getResources().getColorStateList(colorId);
        }
        return context.getColorStateList(colorId);
    }

    @ColorInt
    public static int getColor(Context context, @ColorRes int colorId) {
        return ContextCompat.getColor((Context)context, (int)colorId);
    }

    public static String resolveString(Context context, @AttrRes int attr2) {
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr2, v, true);
        return (String)v.string;
    }

    private static int gravityEnumToAttrInt(GravityEnum value) {
        switch (value) {
            case CENTER: {
                return 1;
            }
            case END: {
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GravityEnum resolveGravityEnum(Context context, @AttrRes int attr2, GravityEnum defaultGravity) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            switch (a.getInt(0, DialogUtils.gravityEnumToAttrInt(defaultGravity))) {
                case 1: {
                    GravityEnum gravityEnum = GravityEnum.CENTER;
                    return gravityEnum;
                }
                case 2: {
                    GravityEnum gravityEnum = GravityEnum.END;
                    return gravityEnum;
                }
            }
            GravityEnum gravityEnum = GravityEnum.START;
            return gravityEnum;
        }
        finally {
            a.recycle();
        }
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr2) {
        return DialogUtils.resolveDrawable(context, attr2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable resolveDrawable(Context context, @AttrRes int attr2, Drawable fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            Drawable d = a.getDrawable(0);
            if (d == null && fallback != null) {
                d = fallback;
            }
            Drawable drawable2 = d;
            return drawable2;
        }
        finally {
            a.recycle();
        }
    }

    public static int resolveDimension(Context context, @AttrRes int attr2) {
        return DialogUtils.resolveDimension(context, attr2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolveDimension(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr2) {
        return DialogUtils.resolveBoolean(context, attr2, false);
    }

    public static boolean isColorDark(@ColorInt int color2) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0;
        return darkness >= 0.5;
    }

    public static void setBackgroundCompat(View view, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(d);
        } else {
            view.setBackground(d);
        }
    }

    public static void showKeyboard(@NonNull DialogInterface di, final @NonNull MaterialDialog.Builder builder) {
        final MaterialDialog dialog = (MaterialDialog)di;
        if (dialog.getInputEditText() == null) {
            return;
        }
        dialog.getInputEditText().post(new Runnable(){

            @Override
            public void run() {
                dialog.getInputEditText().requestFocus();
                InputMethodManager imm = (InputMethodManager)builder.getContext().getSystemService("input_method");
                if (imm != null) {
                    imm.showSoftInput((View)dialog.getInputEditText(), 1);
                }
            }
        });
    }

    public static void hideKeyboard(@NonNull DialogInterface di, @NonNull MaterialDialog.Builder builder) {
        MaterialDialog dialog = (MaterialDialog)di;
        if (dialog.getInputEditText() == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)builder.getContext().getSystemService("input_method");
        if (imm != null) {
            View currentFocus = dialog.getCurrentFocus();
            IBinder windowToken = null;
            if (currentFocus != null) {
                windowToken = currentFocus.getWindowToken();
            } else if (dialog.getView() != null) {
                windowToken = dialog.getView().getWindowToken();
            }
            if (windowToken != null) {
                imm.hideSoftInputFromWindow(windowToken, 0);
            }
        }
    }

    public static ColorStateList getActionTextStateList(Context context, int newPrimaryColor) {
        int fallBackButtonColor = DialogUtils.resolveColor(context, 16842806);
        if (newPrimaryColor == 0) {
            newPrimaryColor = fallBackButtonColor;
        }
        int[][] states = new int[][]{{-16842910}, new int[0]};
        int[] colors = new int[]{DialogUtils.adjustAlpha(newPrimaryColor, 0.4f), newPrimaryColor};
        return new ColorStateList((int[][])states, colors);
    }

    public static int[] getColorArray(@NonNull Context context, @ArrayRes int array) {
        if (array == 0) {
            return null;
        }
        TypedArray ta = context.getResources().obtainTypedArray(array);
        int[] colors = new int[ta.length()];
        for (int i = 0; i < ta.length(); ++i) {
            colors[i] = ta.getColor(i, 0);
        }
        ta.recycle();
        return colors;
    }

    public static <T> boolean isIn(@NonNull T find, @Nullable T[] ary) {
        if (ary == null || ary.length == 0) {
            return false;
        }
        for (T item : ary) {
            if (!item.equals(find)) continue;
            return true;
        }
        return false;
    }
}

