/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.afollestad.materialdialogs.GravityEnum;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.MDTintHelper;
import com.afollestad.materialdialogs.util.DialogUtils;

class DefaultRvAdapter
extends RecyclerView.Adapter<DefaultVH> {
    private final MaterialDialog dialog;
    @LayoutRes
    private final int layout;
    private final GravityEnum itemGravity;
    private InternalListCallback callback;

    DefaultRvAdapter(MaterialDialog dialog, @LayoutRes int layout2) {
        this.dialog = dialog;
        this.layout = layout2;
        this.itemGravity = dialog.builder.itemsGravity;
    }

    void setCallback(InternalListCallback callback) {
        this.callback = callback;
    }

    public DefaultVH onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.layout, parent, false);
        DialogUtils.setBackgroundCompat(view, this.dialog.getListSelector());
        return new DefaultVH(view, this);
    }

    public void onBindViewHolder(DefaultVH holder, int index) {
        ViewGroup group;
        View view = holder.itemView;
        boolean disabled = DialogUtils.isIn(index, this.dialog.builder.disabledIndices);
        switch (this.dialog.listType) {
            case SINGLE: {
                boolean selected;
                RadioButton radio = (RadioButton)holder.control;
                boolean bl = selected = this.dialog.builder.selectedIndex == index;
                if (this.dialog.builder.choiceWidgetColor != null) {
                    MDTintHelper.setTint(radio, this.dialog.builder.choiceWidgetColor);
                } else {
                    MDTintHelper.setTint(radio, this.dialog.builder.widgetColor);
                }
                radio.setChecked(selected);
                radio.setEnabled(!disabled);
                break;
            }
            case MULTI: {
                CheckBox checkbox = (CheckBox)holder.control;
                boolean selected = this.dialog.selectedIndicesList.contains(index);
                if (this.dialog.builder.choiceWidgetColor != null) {
                    MDTintHelper.setTint(checkbox, this.dialog.builder.choiceWidgetColor);
                } else {
                    MDTintHelper.setTint(checkbox, this.dialog.builder.widgetColor);
                }
                checkbox.setChecked(selected);
                checkbox.setEnabled(!disabled);
                break;
            }
        }
        holder.title.setText(this.dialog.builder.items.get(index));
        holder.title.setTextColor(this.dialog.builder.itemColor);
        this.dialog.setTypeface(holder.title, this.dialog.builder.regularFont);
        this.setupGravity((ViewGroup)view);
        if (this.dialog.builder.itemIds != null) {
            if (index < this.dialog.builder.itemIds.length) {
                view.setId(this.dialog.builder.itemIds[index]);
            } else {
                view.setId(-1);
            }
        }
        if (Build.VERSION.SDK_INT >= 21 && (group = (ViewGroup)view).getChildCount() == 2) {
            if (group.getChildAt(0) instanceof CompoundButton) {
                group.getChildAt(0).setBackground(null);
            } else if (group.getChildAt(1) instanceof CompoundButton) {
                group.getChildAt(1).setBackground(null);
            }
        }
    }

    public int getItemCount() {
        return this.dialog.builder.items != null ? this.dialog.builder.items.size() : 0;
    }

    @TargetApi(value=17)
    private void setupGravity(ViewGroup view) {
        LinearLayout itemRoot = (LinearLayout)view;
        int gravityInt = this.itemGravity.getGravityInt();
        itemRoot.setGravity(gravityInt | 0x10);
        if (view.getChildCount() == 2) {
            if (this.itemGravity == GravityEnum.END && !this.isRTL() && view.getChildAt(0) instanceof CompoundButton) {
                CompoundButton first = (CompoundButton)view.getChildAt(0);
                view.removeView((View)first);
                TextView second = (TextView)view.getChildAt(0);
                view.removeView((View)second);
                second.setPadding(second.getPaddingRight(), second.getPaddingTop(), second.getPaddingLeft(), second.getPaddingBottom());
                view.addView((View)second);
                view.addView((View)first);
            } else if (this.itemGravity == GravityEnum.START && this.isRTL() && view.getChildAt(1) instanceof CompoundButton) {
                CompoundButton first = (CompoundButton)view.getChildAt(1);
                view.removeView((View)first);
                TextView second = (TextView)view.getChildAt(0);
                view.removeView((View)second);
                second.setPadding(second.getPaddingRight(), second.getPaddingTop(), second.getPaddingRight(), second.getPaddingBottom());
                view.addView((View)first);
                view.addView((View)second);
            }
        }
    }

    @TargetApi(value=17)
    private boolean isRTL() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        Configuration config = this.dialog.getBuilder().getContext().getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }

    static class DefaultVH
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        final CompoundButton control;
        final TextView title;
        final DefaultRvAdapter adapter;

        DefaultVH(View itemView, DefaultRvAdapter adapter) {
            super(itemView);
            this.control = (CompoundButton)itemView.findViewById(R.id.md_control);
            this.title = (TextView)itemView.findViewById(R.id.md_title);
            this.adapter = adapter;
            itemView.setOnClickListener((View.OnClickListener)this);
            if (((DefaultRvAdapter)adapter).dialog.builder.listLongCallback != null) {
                itemView.setOnLongClickListener((View.OnLongClickListener)this);
            }
        }

        public void onClick(View view) {
            if (this.adapter.callback != null && this.getAdapterPosition() != -1) {
                CharSequence text = null;
                if (((DefaultRvAdapter)this.adapter).dialog.builder.items != null && this.getAdapterPosition() < ((DefaultRvAdapter)this.adapter).dialog.builder.items.size()) {
                    text = ((DefaultRvAdapter)this.adapter).dialog.builder.items.get(this.getAdapterPosition());
                }
                this.adapter.callback.onItemSelected(this.adapter.dialog, view, this.getAdapterPosition(), text, false);
            }
        }

        public boolean onLongClick(View view) {
            if (this.adapter.callback != null && this.getAdapterPosition() != -1) {
                CharSequence text = null;
                if (((DefaultRvAdapter)this.adapter).dialog.builder.items != null && this.getAdapterPosition() < ((DefaultRvAdapter)this.adapter).dialog.builder.items.size()) {
                    text = ((DefaultRvAdapter)this.adapter).dialog.builder.items.get(this.getAdapterPosition());
                }
                return this.adapter.callback.onItemSelected(this.adapter.dialog, view, this.getAdapterPosition(), text, true);
            }
            return false;
        }
    }

    static interface InternalListCallback {
        public boolean onItemSelected(MaterialDialog var1, View var2, int var3, CharSequence var4, boolean var5);
    }
}

