/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatEditText;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.TextView;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.util.DialogUtils;
import java.lang.reflect.Field;

public class MDTintHelper {
    public static void setTint(@NonNull RadioButton radioButton, @ColorInt int color2) {
        int disabledColor = DialogUtils.getDisabledColor(radioButton.getContext());
        ColorStateList sl = new ColorStateList((int[][])new int[][]{{16842910, -16842912}, {16842910, 0x10100A0}, {-16842910, -16842912}, {-16842910, 0x10100A0}}, new int[]{DialogUtils.resolveColor(radioButton.getContext(), R.attr.colorControlNormal), color2, disabledColor, disabledColor});
        if (Build.VERSION.SDK_INT >= 21) {
            radioButton.setButtonTintList(sl);
        } else {
            Drawable radioDrawable = ContextCompat.getDrawable((Context)radioButton.getContext(), (int)R.drawable.abc_btn_radio_material);
            Drawable d = DrawableCompat.wrap((Drawable)radioDrawable);
            DrawableCompat.setTintList((Drawable)d, (ColorStateList)sl);
            radioButton.setButtonDrawable(d);
        }
    }

    public static void setTint(@NonNull SeekBar seekBar, @ColorInt int color2) {
        ColorStateList s1 = ColorStateList.valueOf((int)color2);
        if (Build.VERSION.SDK_INT >= 21) {
            seekBar.setThumbTintList(s1);
            seekBar.setProgressTintList(s1);
        } else if (Build.VERSION.SDK_INT > 10) {
            Drawable progressDrawable = DrawableCompat.wrap((Drawable)seekBar.getProgressDrawable());
            seekBar.setProgressDrawable(progressDrawable);
            DrawableCompat.setTintList((Drawable)progressDrawable, (ColorStateList)s1);
            if (Build.VERSION.SDK_INT >= 16) {
                Drawable thumbDrawable = DrawableCompat.wrap((Drawable)seekBar.getThumb());
                DrawableCompat.setTintList((Drawable)thumbDrawable, (ColorStateList)s1);
                seekBar.setThumb(thumbDrawable);
            }
        } else {
            PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
            if (Build.VERSION.SDK_INT <= 10) {
                mode = PorterDuff.Mode.MULTIPLY;
            }
            if (seekBar.getIndeterminateDrawable() != null) {
                seekBar.getIndeterminateDrawable().setColorFilter(color2, mode);
            }
            if (seekBar.getProgressDrawable() != null) {
                seekBar.getProgressDrawable().setColorFilter(color2, mode);
            }
        }
    }

    public static void setTint(@NonNull ProgressBar progressBar, @ColorInt int color2) {
        MDTintHelper.setTint(progressBar, color2, false);
    }

    public static void setTint(@NonNull ProgressBar progressBar, @ColorInt int color2, boolean skipIndeterminate) {
        ColorStateList sl = ColorStateList.valueOf((int)color2);
        if (Build.VERSION.SDK_INT >= 21) {
            progressBar.setProgressTintList(sl);
            progressBar.setSecondaryProgressTintList(sl);
            if (!skipIndeterminate) {
                progressBar.setIndeterminateTintList(sl);
            }
        } else {
            PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
            if (Build.VERSION.SDK_INT <= 10) {
                mode = PorterDuff.Mode.MULTIPLY;
            }
            if (!skipIndeterminate && progressBar.getIndeterminateDrawable() != null) {
                progressBar.getIndeterminateDrawable().setColorFilter(color2, mode);
            }
            if (progressBar.getProgressDrawable() != null) {
                progressBar.getProgressDrawable().setColorFilter(color2, mode);
            }
        }
    }

    private static ColorStateList createEditTextColorStateList(@NonNull Context context, @ColorInt int color2) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = new int[]{-16842910};
        colors[i] = DialogUtils.resolveColor(context, R.attr.colorControlNormal);
        states[++i] = new int[]{-16842919, -16842908};
        colors[i] = DialogUtils.resolveColor(context, R.attr.colorControlNormal);
        states[++i] = new int[0];
        colors[i] = color2;
        return new ColorStateList((int[][])states, colors);
    }

    public static void setTint(@NonNull EditText editText, @ColorInt int color2) {
        ColorStateList editTextColorStateList = MDTintHelper.createEditTextColorStateList(editText.getContext(), color2);
        if (editText instanceof AppCompatEditText) {
            ((AppCompatEditText)editText).setSupportBackgroundTintList(editTextColorStateList);
        } else if (Build.VERSION.SDK_INT >= 21) {
            editText.setBackgroundTintList(editTextColorStateList);
        }
        MDTintHelper.setCursorTint(editText, color2);
    }

    public static void setTint(@NonNull CheckBox box, @ColorInt int color2) {
        int disabledColor = DialogUtils.getDisabledColor(box.getContext());
        ColorStateList sl = new ColorStateList((int[][])new int[][]{{16842910, -16842912}, {16842910, 0x10100A0}, {-16842910, -16842912}, {-16842910, 0x10100A0}}, new int[]{DialogUtils.resolveColor(box.getContext(), R.attr.colorControlNormal), color2, disabledColor, disabledColor});
        if (Build.VERSION.SDK_INT >= 21) {
            box.setButtonTintList(sl);
        } else {
            Drawable checkDrawable = ContextCompat.getDrawable((Context)box.getContext(), (int)R.drawable.abc_btn_check_material);
            Drawable drawable2 = DrawableCompat.wrap((Drawable)checkDrawable);
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)sl);
            box.setButtonDrawable(drawable2);
        }
    }

    private static void setCursorTint(@NonNull EditText editText, @ColorInt int color2) {
        try {
            Field fCursorDrawableRes = TextView.class.getDeclaredField("mCursorDrawableRes");
            fCursorDrawableRes.setAccessible(true);
            int mCursorDrawableRes = fCursorDrawableRes.getInt(editText);
            Field fEditor = TextView.class.getDeclaredField("mEditor");
            fEditor.setAccessible(true);
            Object editor = fEditor.get(editText);
            Class<?> clazz = editor.getClass();
            Field fCursorDrawable = clazz.getDeclaredField("mCursorDrawable");
            fCursorDrawable.setAccessible(true);
            Drawable[] drawables = new Drawable[]{ContextCompat.getDrawable((Context)editText.getContext(), (int)mCursorDrawableRes), ContextCompat.getDrawable((Context)editText.getContext(), (int)mCursorDrawableRes)};
            drawables[0].setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            drawables[1].setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            fCursorDrawable.set(editor, drawables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

