/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.text.AllCapsTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.afollestad.materialdialogs.GravityEnum;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.util.DialogUtils;

public class MDButton
extends TextView {
    private boolean mStacked = false;
    private GravityEnum mStackedGravity;
    private int mStackedEndPadding;
    private Drawable mStackedBackground;
    private Drawable mDefaultBackground;

    public MDButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public MDButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public MDButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mStackedEndPadding = context.getResources().getDimensionPixelSize(R.dimen.md_dialog_frame_margin);
        this.mStackedGravity = GravityEnum.END;
    }

    void setStacked(boolean stacked, boolean force) {
        if (this.mStacked != stacked || force) {
            this.setGravity(stacked ? 0x10 | this.mStackedGravity.getGravityInt() : 17);
            if (Build.VERSION.SDK_INT >= 17) {
                this.setTextAlignment(stacked ? this.mStackedGravity.getTextAlignment() : 4);
            }
            DialogUtils.setBackgroundCompat((View)this, stacked ? this.mStackedBackground : this.mDefaultBackground);
            if (stacked) {
                this.setPadding(this.mStackedEndPadding, this.getPaddingTop(), this.mStackedEndPadding, this.getPaddingBottom());
            }
            this.mStacked = stacked;
        }
    }

    public void setStackedGravity(GravityEnum gravity) {
        this.mStackedGravity = gravity;
    }

    public void setStackedSelector(Drawable d) {
        this.mStackedBackground = d;
        if (this.mStacked) {
            this.setStacked(true, true);
        }
    }

    public void setDefaultSelector(Drawable d) {
        this.mDefaultBackground = d;
        if (!this.mStacked) {
            this.setStacked(false, true);
        }
    }

    public void setAllCapsCompat(boolean allCaps) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setAllCaps(allCaps);
        } else if (allCaps) {
            this.setTransformationMethod((TransformationMethod)new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }
}

