/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ScrollView;
import com.afollestad.materialdialogs.GravityEnum;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.StackingBehavior;
import com.afollestad.materialdialogs.internal.MDButton;
import com.afollestad.materialdialogs.util.DialogUtils;

public class MDRootLayout
extends ViewGroup {
    private View mTitleBar;
    private View mContent;
    private static final int INDEX_NEUTRAL = 0;
    private static final int INDEX_NEGATIVE = 1;
    private static final int INDEX_POSITIVE = 2;
    private boolean mDrawTopDivider = false;
    private boolean mDrawBottomDivider = false;
    private final MDButton[] mButtons = new MDButton[3];
    private StackingBehavior mStackBehavior = StackingBehavior.ADAPTIVE;
    private boolean mIsStacked = false;
    private boolean mUseFullPadding = true;
    private boolean mReducePaddingNoTitleNoButtons;
    private boolean mNoTitleNoPadding;
    private int mNoTitlePaddingFull;
    private int mButtonPaddingFull;
    private int mButtonBarHeight;
    private GravityEnum mButtonGravity = GravityEnum.START;
    private int mButtonHorizontalEdgeMargin;
    private Paint mDividerPaint;
    private ViewTreeObserver.OnScrollChangedListener mTopOnScrollChangedListener;
    private ViewTreeObserver.OnScrollChangedListener mBottomOnScrollChangedListener;
    private int mDividerWidth;

    public MDRootLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public MDRootLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public MDRootLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public MDRootLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources r = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MDRootLayout, defStyleAttr, 0);
        this.mReducePaddingNoTitleNoButtons = a.getBoolean(R.styleable.MDRootLayout_md_reduce_padding_no_title_no_buttons, true);
        a.recycle();
        this.mNoTitlePaddingFull = r.getDimensionPixelSize(R.dimen.md_notitle_vertical_padding);
        this.mButtonPaddingFull = r.getDimensionPixelSize(R.dimen.md_button_frame_vertical_padding);
        this.mButtonHorizontalEdgeMargin = r.getDimensionPixelSize(R.dimen.md_button_padding_frame_side);
        this.mButtonBarHeight = r.getDimensionPixelSize(R.dimen.md_button_height);
        this.mDividerPaint = new Paint();
        this.mDividerWidth = r.getDimensionPixelSize(R.dimen.md_divider_height);
        this.mDividerPaint.setColor(DialogUtils.resolveColor(context, R.attr.md_divider_color));
        this.setWillNotDraw(false);
    }

    public void noTitleNoPadding() {
        this.mNoTitleNoPadding = true;
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            if (v.getId() == R.id.md_titleFrame) {
                this.mTitleBar = v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultNeutral) {
                this.mButtons[0] = (MDButton)v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultNegative) {
                this.mButtons[1] = (MDButton)v;
                continue;
            }
            if (v.getId() == R.id.md_buttonDefaultPositive) {
                this.mButtons[2] = (MDButton)v;
                continue;
            }
            this.mContent = v;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean stacked;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mUseFullPadding = true;
        boolean hasButtons = false;
        if (this.mStackBehavior == StackingBehavior.ALWAYS) {
            stacked = true;
        } else if (this.mStackBehavior == StackingBehavior.NEVER) {
            stacked = false;
        } else {
            int buttonsWidth = 0;
            MDButton[] mDButtonArray = this.mButtons;
            int n = mDButtonArray.length;
            for (int i = 0; i < n; ++i) {
                MDButton button = mDButtonArray[i];
                if (button == null || !MDRootLayout.isVisible((View)button)) continue;
                button.setStacked(false, false);
                this.measureChild((View)button, widthMeasureSpec, heightMeasureSpec);
                buttonsWidth += button.getMeasuredWidth();
                hasButtons = true;
            }
            int buttonBarPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_neutral_button_margin);
            int buttonFrameWidth = width - 2 * buttonBarPadding;
            stacked = buttonsWidth > buttonFrameWidth;
        }
        int stackedHeight = 0;
        this.mIsStacked = stacked;
        if (stacked) {
            for (MDButton button : this.mButtons) {
                if (button == null || !MDRootLayout.isVisible((View)button)) continue;
                button.setStacked(true, false);
                this.measureChild((View)button, widthMeasureSpec, heightMeasureSpec);
                stackedHeight += button.getMeasuredHeight();
                hasButtons = true;
            }
        }
        int availableHeight = height;
        int fullPadding = 0;
        int minPadding = 0;
        if (hasButtons) {
            if (this.mIsStacked) {
                availableHeight -= stackedHeight;
                fullPadding += 2 * this.mButtonPaddingFull;
                minPadding += 2 * this.mButtonPaddingFull;
            } else {
                availableHeight -= this.mButtonBarHeight;
                fullPadding += 2 * this.mButtonPaddingFull;
            }
        } else {
            fullPadding += 2 * this.mButtonPaddingFull;
        }
        if (MDRootLayout.isVisible(this.mTitleBar)) {
            this.mTitleBar.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), 0);
            availableHeight -= this.mTitleBar.getMeasuredHeight();
        } else if (!this.mNoTitleNoPadding) {
            fullPadding += this.mNoTitlePaddingFull;
        }
        if (MDRootLayout.isVisible(this.mContent)) {
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(availableHeight - minPadding), (int)Integer.MIN_VALUE));
            if (this.mContent.getMeasuredHeight() <= availableHeight - fullPadding) {
                if (!this.mReducePaddingNoTitleNoButtons || MDRootLayout.isVisible(this.mTitleBar) || hasButtons) {
                    this.mUseFullPadding = true;
                    availableHeight -= this.mContent.getMeasuredHeight() + fullPadding;
                } else {
                    this.mUseFullPadding = false;
                    availableHeight -= this.mContent.getMeasuredHeight() + minPadding;
                }
            } else {
                this.mUseFullPadding = false;
                availableHeight = 0;
            }
        }
        this.setMeasuredDimension(width, height - availableHeight);
    }

    private static boolean isVisible(View v) {
        boolean visible;
        boolean bl = visible = v != null && v.getVisibility() != 8;
        if (visible && v instanceof MDButton) {
            visible = ((MDButton)v).getText().toString().trim().length() > 0;
        }
        return visible;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mContent != null) {
            int y;
            if (this.mDrawTopDivider) {
                y = this.mContent.getTop();
                canvas.drawRect(0.0f, (float)(y - this.mDividerWidth), (float)this.getMeasuredWidth(), (float)y, this.mDividerPaint);
            }
            if (this.mDrawBottomDivider) {
                y = this.mContent.getBottom();
                canvas.drawRect(0.0f, (float)y, (float)this.getMeasuredWidth(), (float)(y + this.mDividerWidth), this.mDividerPaint);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (MDRootLayout.isVisible(this.mTitleBar)) {
            int height = this.mTitleBar.getMeasuredHeight();
            this.mTitleBar.layout(l, t, r, t + height);
            t += height;
        } else if (!this.mNoTitleNoPadding && this.mUseFullPadding) {
            t += this.mNoTitlePaddingFull;
        }
        if (MDRootLayout.isVisible(this.mContent)) {
            this.mContent.layout(l, t, r, t + this.mContent.getMeasuredHeight());
        }
        if (this.mIsStacked) {
            b -= this.mButtonPaddingFull;
            for (MDButton mButton : this.mButtons) {
                if (!MDRootLayout.isVisible((View)mButton)) continue;
                mButton.layout(l, b - mButton.getMeasuredHeight(), r, b);
                b -= mButton.getMeasuredHeight();
            }
        } else {
            int br;
            int bl;
            int barBottom = b;
            if (this.mUseFullPadding) {
                barBottom -= this.mButtonPaddingFull;
            }
            int barTop = barBottom - this.mButtonBarHeight;
            int offset = this.mButtonHorizontalEdgeMargin;
            int neutralLeft = -1;
            int neutralRight = -1;
            if (MDRootLayout.isVisible((View)this.mButtons[2])) {
                if (this.mButtonGravity == GravityEnum.END) {
                    bl = l + offset;
                    br = bl + this.mButtons[2].getMeasuredWidth();
                } else {
                    br = r - offset;
                    neutralRight = bl = br - this.mButtons[2].getMeasuredWidth();
                }
                this.mButtons[2].layout(bl, barTop, br, barBottom);
                offset += this.mButtons[2].getMeasuredWidth();
            }
            if (MDRootLayout.isVisible((View)this.mButtons[1])) {
                if (this.mButtonGravity == GravityEnum.END) {
                    bl = l + offset;
                    br = bl + this.mButtons[1].getMeasuredWidth();
                } else if (this.mButtonGravity == GravityEnum.START) {
                    br = r - offset;
                    bl = br - this.mButtons[1].getMeasuredWidth();
                } else {
                    bl = l + this.mButtonHorizontalEdgeMargin;
                    neutralLeft = br = bl + this.mButtons[1].getMeasuredWidth();
                }
                this.mButtons[1].layout(bl, barTop, br, barBottom);
            }
            if (MDRootLayout.isVisible((View)this.mButtons[0])) {
                if (this.mButtonGravity == GravityEnum.END) {
                    br = r - this.mButtonHorizontalEdgeMargin;
                    bl = br - this.mButtons[0].getMeasuredWidth();
                } else if (this.mButtonGravity == GravityEnum.START) {
                    bl = l + this.mButtonHorizontalEdgeMargin;
                    br = bl + this.mButtons[0].getMeasuredWidth();
                } else {
                    if (neutralLeft == -1 && neutralRight != -1) {
                        neutralLeft = neutralRight - this.mButtons[0].getMeasuredWidth();
                    } else if (neutralRight == -1 && neutralLeft != -1) {
                        neutralRight = neutralLeft + this.mButtons[0].getMeasuredWidth();
                    } else if (neutralRight == -1) {
                        neutralLeft = (r - l) / 2 - this.mButtons[0].getMeasuredWidth() / 2;
                        neutralRight = neutralLeft + this.mButtons[0].getMeasuredWidth();
                    }
                    bl = neutralLeft;
                    br = neutralRight;
                }
                this.mButtons[0].layout(bl, barTop, br, barBottom);
            }
        }
        this.setUpDividersVisibility(this.mContent, true, true);
    }

    public void setStackingBehavior(StackingBehavior behavior) {
        this.mStackBehavior = behavior;
        this.invalidate();
    }

    public void setDividerColor(int color2) {
        this.mDividerPaint.setColor(color2);
        this.invalidate();
    }

    public void setButtonGravity(GravityEnum gravity) {
        this.mButtonGravity = gravity;
        this.invertGravityIfNecessary();
    }

    private void invertGravityIfNecessary() {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        Configuration config = this.getResources().getConfiguration();
        if (config.getLayoutDirection() == 1) {
            switch (this.mButtonGravity) {
                case START: {
                    this.mButtonGravity = GravityEnum.END;
                    break;
                }
                case END: {
                    this.mButtonGravity = GravityEnum.START;
                }
            }
        }
    }

    public void setButtonStackedGravity(GravityEnum gravity) {
        for (MDButton mButton : this.mButtons) {
            if (mButton == null) continue;
            mButton.setStackedGravity(gravity);
        }
    }

    private void setUpDividersVisibility(final View view, final boolean setForTop, final boolean setForBottom) {
        if (view == null) {
            return;
        }
        if (view instanceof ScrollView) {
            ScrollView sv = (ScrollView)view;
            if (MDRootLayout.canScrollViewScroll(sv)) {
                this.addScrollListener((ViewGroup)sv, setForTop, setForBottom);
            } else {
                if (setForTop) {
                    this.mDrawTopDivider = false;
                }
                if (setForBottom) {
                    this.mDrawBottomDivider = false;
                }
            }
        } else if (view instanceof AdapterView) {
            AdapterView sv = (AdapterView)view;
            if (MDRootLayout.canAdapterViewScroll(sv)) {
                this.addScrollListener((ViewGroup)sv, setForTop, setForBottom);
            } else {
                if (setForTop) {
                    this.mDrawTopDivider = false;
                }
                if (setForBottom) {
                    this.mDrawBottomDivider = false;
                }
            }
        } else if (view instanceof WebView) {
            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    if (view.getMeasuredHeight() != 0) {
                        if (!MDRootLayout.canWebViewScroll((WebView)view)) {
                            if (setForTop) {
                                MDRootLayout.this.mDrawTopDivider = false;
                            }
                            if (setForBottom) {
                                MDRootLayout.this.mDrawBottomDivider = false;
                            }
                        } else {
                            MDRootLayout.this.addScrollListener((ViewGroup)view, setForTop, setForBottom);
                        }
                        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    return true;
                }
            });
        } else if (view instanceof RecyclerView) {
            boolean canScroll = MDRootLayout.canRecyclerViewScroll((RecyclerView)view);
            if (setForTop) {
                this.mDrawTopDivider = canScroll;
            }
            if (setForBottom) {
                this.mDrawBottomDivider = canScroll;
            }
        } else if (view instanceof ViewGroup) {
            View topView = MDRootLayout.getTopView((ViewGroup)view);
            this.setUpDividersVisibility(topView, setForTop, setForBottom);
            View bottomView = MDRootLayout.getBottomView((ViewGroup)view);
            if (bottomView != topView) {
                this.setUpDividersVisibility(bottomView, false, true);
            }
        }
    }

    private void addScrollListener(final ViewGroup vg, final boolean setForTop, final boolean setForBottom) {
        if (!setForBottom && this.mTopOnScrollChangedListener == null || setForBottom && this.mBottomOnScrollChangedListener == null) {
            ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    boolean hasButtons = false;
                    for (MDButton button : MDRootLayout.this.mButtons) {
                        if (button == null || button.getVisibility() == 8) continue;
                        hasButtons = true;
                        break;
                    }
                    if (vg instanceof WebView) {
                        MDRootLayout.this.invalidateDividersForWebView((WebView)vg, setForTop, setForBottom, hasButtons);
                    } else {
                        MDRootLayout.this.invalidateDividersForScrollingView(vg, setForTop, setForBottom, hasButtons);
                    }
                    MDRootLayout.this.invalidate();
                }
            };
            if (!setForBottom) {
                this.mTopOnScrollChangedListener = onScrollChangedListener;
                vg.getViewTreeObserver().addOnScrollChangedListener(this.mTopOnScrollChangedListener);
            } else {
                this.mBottomOnScrollChangedListener = onScrollChangedListener;
                vg.getViewTreeObserver().addOnScrollChangedListener(this.mBottomOnScrollChangedListener);
            }
            onScrollChangedListener.onScrollChanged();
        }
    }

    private void invalidateDividersForScrollingView(ViewGroup view, boolean setForTop, boolean setForBottom, boolean hasButtons) {
        if (setForTop && view.getChildCount() > 0) {
            boolean bl = this.mDrawTopDivider = this.mTitleBar != null && this.mTitleBar.getVisibility() != 8 && view.getScrollY() + view.getPaddingTop() > view.getChildAt(0).getTop();
        }
        if (setForBottom && view.getChildCount() > 0) {
            this.mDrawBottomDivider = hasButtons && view.getScrollY() + view.getHeight() - view.getPaddingBottom() < view.getChildAt(view.getChildCount() - 1).getBottom();
        }
    }

    private void invalidateDividersForWebView(WebView view, boolean setForTop, boolean setForBottom, boolean hasButtons) {
        if (setForTop) {
            boolean bl = this.mDrawTopDivider = this.mTitleBar != null && this.mTitleBar.getVisibility() != 8 && view.getScrollY() + view.getPaddingTop() > 0;
        }
        if (setForBottom) {
            this.mDrawBottomDivider = hasButtons && (float)(view.getScrollY() + view.getMeasuredHeight() - view.getPaddingBottom()) < (float)view.getContentHeight() * view.getScale();
        }
    }

    public static boolean canRecyclerViewScroll(RecyclerView view) {
        if (view == null || view.getAdapter() == null || view.getLayoutManager() == null) {
            return false;
        }
        RecyclerView.LayoutManager lm = view.getLayoutManager();
        int count = view.getAdapter().getItemCount();
        if (!(lm instanceof LinearLayoutManager)) {
            throw new MaterialDialog.NotImplementedException("Material Dialogs currently only supports LinearLayoutManager. Please report any new layout managers.");
        }
        LinearLayoutManager llm = (LinearLayoutManager)lm;
        int lastVisible = llm.findLastVisibleItemPosition();
        if (lastVisible == -1) {
            return false;
        }
        boolean lastItemVisible = lastVisible == count - 1;
        return !lastItemVisible || view.getChildCount() > 0 && view.getChildAt(view.getChildCount() - 1).getBottom() > view.getHeight() - view.getPaddingBottom();
    }

    private static boolean canScrollViewScroll(ScrollView sv) {
        if (sv.getChildCount() == 0) {
            return false;
        }
        int childHeight = sv.getChildAt(0).getMeasuredHeight();
        return sv.getMeasuredHeight() - sv.getPaddingTop() - sv.getPaddingBottom() < childHeight;
    }

    private static boolean canWebViewScroll(WebView view) {
        return (float)view.getMeasuredHeight() < (float)view.getContentHeight() * view.getScale();
    }

    private static boolean canAdapterViewScroll(AdapterView lv) {
        boolean lastItemVisible;
        if (lv.getLastVisiblePosition() == -1) {
            return false;
        }
        boolean firstItemVisible = lv.getFirstVisiblePosition() == 0;
        boolean bl = lastItemVisible = lv.getLastVisiblePosition() == lv.getCount() - 1;
        if (firstItemVisible && lastItemVisible && lv.getChildCount() > 0) {
            if (lv.getChildAt(0).getTop() < lv.getPaddingTop()) {
                return true;
            }
            return lv.getChildAt(lv.getChildCount() - 1).getBottom() > lv.getHeight() - lv.getPaddingBottom();
        }
        return true;
    }

    @Nullable
    private static View getBottomView(ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getChildCount() == 0) {
            return null;
        }
        View bottomView = null;
        for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (child.getVisibility() != 0 || child.getBottom() != viewGroup.getMeasuredHeight()) continue;
            bottomView = child;
            break;
        }
        return bottomView;
    }

    @Nullable
    private static View getTopView(ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getChildCount() == 0) {
            return null;
        }
        View topView = null;
        for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (child.getVisibility() != 0 || child.getTop() != 0) continue;
            topView = child;
            break;
        }
        return topView;
    }
}

