/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.afollestad.materialdialogs.GravityEnum;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.R;
import com.afollestad.materialdialogs.internal.MDTintHelper;
import com.afollestad.materialdialogs.util.DialogUtils;

class DefaultAdapter
extends BaseAdapter {
    private final MaterialDialog dialog;
    @LayoutRes
    private final int layout;
    private final GravityEnum itemGravity;

    public DefaultAdapter(MaterialDialog dialog, @LayoutRes int layout2) {
        this.dialog = dialog;
        this.layout = layout2;
        this.itemGravity = dialog.mBuilder.itemsGravity;
    }

    public boolean hasStableIds() {
        return true;
    }

    public int getCount() {
        return this.dialog.mBuilder.items != null ? this.dialog.mBuilder.items.length : 0;
    }

    public Object getItem(int position) {
        return this.dialog.mBuilder.items[position];
    }

    public long getItemId(int position) {
        return position;
    }

    @SuppressLint(value={"WrongViewCast"})
    public View getView(int index, View view, ViewGroup parent) {
        ViewGroup group;
        if (view == null) {
            view = LayoutInflater.from((Context)this.dialog.getContext()).inflate(this.layout, parent, false);
        }
        boolean disabled = DialogUtils.isIn(index, this.dialog.mBuilder.disabledIndices);
        TextView tv = (TextView)view.findViewById(R.id.title);
        switch (this.dialog.listType) {
            case SINGLE: {
                RadioButton radio = (RadioButton)view.findViewById(R.id.control);
                boolean selected = this.dialog.mBuilder.selectedIndex == index;
                MDTintHelper.setTint(radio, this.dialog.mBuilder.widgetColor);
                radio.setChecked(selected);
                radio.setEnabled(!disabled);
                break;
            }
            case MULTI: {
                CheckBox checkbox = (CheckBox)view.findViewById(R.id.control);
                boolean selected = this.dialog.selectedIndicesList.contains(index);
                MDTintHelper.setTint(checkbox, this.dialog.mBuilder.widgetColor);
                checkbox.setChecked(selected);
                checkbox.setEnabled(!disabled);
                break;
            }
        }
        tv.setText(this.dialog.mBuilder.items[index]);
        tv.setTextColor(this.dialog.mBuilder.itemColor);
        this.dialog.setTypeface(tv, this.dialog.mBuilder.regularFont);
        view.setTag((Object)(index + ":" + this.dialog.mBuilder.items[index]));
        this.setupGravity((ViewGroup)view);
        if (this.dialog.mBuilder.itemIds != null) {
            if (index < this.dialog.mBuilder.itemIds.length) {
                view.setId(this.dialog.mBuilder.itemIds[index]);
            } else {
                view.setId(-1);
            }
        }
        if (Build.VERSION.SDK_INT >= 21 && (group = (ViewGroup)view).getChildCount() == 2) {
            if (group.getChildAt(0) instanceof CompoundButton) {
                group.getChildAt(0).setBackground(null);
            } else if (group.getChildAt(1) instanceof CompoundButton) {
                group.getChildAt(1).setBackground(null);
            }
        }
        return view;
    }

    @TargetApi(value=17)
    private void setupGravity(ViewGroup view) {
        LinearLayout itemRoot = (LinearLayout)view;
        int gravityInt = this.itemGravity.getGravityInt();
        itemRoot.setGravity(gravityInt | 0x10);
        if (view.getChildCount() == 2) {
            if (this.itemGravity == GravityEnum.END && !this.isRTL() && view.getChildAt(0) instanceof CompoundButton) {
                CompoundButton first = (CompoundButton)view.getChildAt(0);
                view.removeView((View)first);
                TextView second = (TextView)view.getChildAt(0);
                view.removeView((View)second);
                second.setPadding(second.getPaddingRight(), second.getPaddingTop(), second.getPaddingLeft(), second.getPaddingBottom());
                view.addView((View)second);
                view.addView((View)first);
            } else if (this.itemGravity == GravityEnum.START && this.isRTL() && view.getChildAt(1) instanceof CompoundButton) {
                CompoundButton first = (CompoundButton)view.getChildAt(1);
                view.removeView((View)first);
                TextView second = (TextView)view.getChildAt(0);
                view.removeView((View)second);
                second.setPadding(second.getPaddingRight(), second.getPaddingTop(), second.getPaddingRight(), second.getPaddingBottom());
                view.addView((View)first);
                view.addView((View)second);
            }
        }
    }

    @TargetApi(value=17)
    private boolean isRTL() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        Configuration config = this.dialog.getBuilder().getContext().getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }
}

