/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.afollestad.date.util.ColorsKt;
import com.afollestad.date.util.ContextsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0006H\u0007J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/afollestad/date/util/Util;", "", "()V", "circleShape", "Landroid/graphics/drawable/Drawable;", "color", "", "coloredDrawable", "context", "Landroid/content/Context;", "shapeRes", "createCircularSelector", "selectedColor", "createTextSelector", "Landroid/content/res/ColorStateList;", "overColoredBackground", "", "com.afollestad.date-picker"})
public final class Util {
    public static final Util INSTANCE;

    @CheckResult
    @NotNull
    public final ColorStateList createTextSelector(@NotNull Context context, @ColorInt int selectedColor, boolean overColoredBackground) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int[][] states = new int[][]{{-16842910}, {16842910, -16842913}, {16842910, 0x10100A1}};
        int disabledTextColor = ContextsKt.resolveColor$default(context, 16842807, null, 2, null);
        int primaryTextColor = ContextsKt.resolveColor$default(context, 16842806, null, 2, null);
        int[] nArray = new int[3];
        nArray[0] = disabledTextColor;
        nArray[1] = primaryTextColor;
        nArray[2] = overColoredBackground ? (ColorsKt.isColorDark$default(selectedColor, 0.0, 1, null) ? -1 : -16777216) : selectedColor;
        int[] colors = nArray;
        return new ColorStateList(states, colors);
    }

    public static /* synthetic */ ColorStateList createTextSelector$default(Util util, Context context, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return util.createTextSelector(context, n, bl);
    }

    @CheckResult
    @NotNull
    public final Drawable createCircularSelector(@ColorInt int selectedColor) {
        Drawable selected = this.circleShape(selectedColor);
        if (Build.VERSION.SDK_INT >= 21) {
            StateListDrawable stateListDrawable = new StateListDrawable();
            ColorStateList colorStateList = ColorStateList.valueOf((int)selectedColor);
            boolean bl = false;
            boolean bl2 = false;
            StateListDrawable $this$apply = stateListDrawable;
            boolean bl3 = false;
            $this$apply.addState(new int[]{0x10100A1}, selected);
            StateListDrawable stateListDrawable2 = stateListDrawable;
            Drawable drawable2 = selected;
            Drawable drawable3 = (Drawable)stateListDrawable2;
            ColorStateList colorStateList2 = colorStateList;
            return (Drawable)new RippleDrawable(colorStateList2, drawable3, drawable2);
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        boolean bl = false;
        boolean bl4 = false;
        StateListDrawable $this$apply = stateListDrawable;
        boolean bl5 = false;
        Drawable drawable4 = selected.mutate();
        int[] nArray = new int[]{16842910, 16842919};
        StateListDrawable stateListDrawable3 = $this$apply;
        boolean bl6 = false;
        boolean bl7 = false;
        Drawable $this$apply2 = drawable4;
        boolean bl8 = false;
        $this$apply2.setAlpha((int)76.5);
        Drawable drawable5 = drawable4;
        stateListDrawable3.addState(nArray, drawable5);
        $this$apply.addState(new int[]{16842910, 0x10100A1}, selected);
        return (Drawable)stateListDrawable;
    }

    @CheckResult
    @NotNull
    public final Drawable coloredDrawable(@NotNull Context context, @DrawableRes int shapeRes, @ColorInt int color) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)shapeRes);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Drawable drawable3 = drawable2;
        boolean bl = false;
        boolean bl2 = false;
        Drawable $this$apply = drawable3;
        boolean bl3 = false;
        $this$apply.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        $this$apply.setAlpha(Color.alpha((int)color));
        Drawable drawable4 = drawable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable4, (String)"ContextCompat.getDrawabl\u2026 Color.alpha(color)\n    }");
        return drawable4;
    }

    private final Drawable circleShape(@ColorInt int color) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable $this$apply = gradientDrawable;
        boolean bl3 = false;
        $this$apply.setShape(1);
        $this$apply.setColors(new int[]{color, color});
        return (Drawable)gradientDrawable;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

