/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.renderers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import com.afollestad.date.R;
import com.afollestad.date.controllers.MinMaxController;
import com.afollestad.date.data.DayOfWeek;
import com.afollestad.date.data.MonthItem;
import com.afollestad.date.data.snapshot.DateSnapshot;
import com.afollestad.date.util.AttrsKt;
import com.afollestad.date.util.ColorsKt;
import com.afollestad.date.util.ContextsKt;
import com.afollestad.date.util.DebouncerKt;
import com.afollestad.date.util.Util;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0017J4\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/afollestad/date/renderers/MonthItemRenderer;", "", "context", "Landroid/content/Context;", "typedArray", "Landroid/content/res/TypedArray;", "normalFont", "Landroid/graphics/Typeface;", "minMaxController", "Lcom/afollestad/date/controllers/MinMaxController;", "(Landroid/content/Context;Landroid/content/res/TypedArray;Landroid/graphics/Typeface;Lcom/afollestad/date/controllers/MinMaxController;)V", "disabledBackgroundColor", "", "selectionColor", "render", "", "item", "Lcom/afollestad/date/data/MonthItem;", "rootView", "Landroid/view/View;", "textView", "Landroid/widget/TextView;", "onSelection", "Lkotlin/Function1;", "Lcom/afollestad/date/data/MonthItem$DayOfMonth;", "renderDayOfMonth", "dayOfMonth", "renderWeekHeader", "dayOfWeek", "Lcom/afollestad/date/data/DayOfWeek;", "positiveOrEmptyAsString", "", "Companion", "com.afollestad.date-picker"})
public final class MonthItemRenderer {
    private final int selectionColor;
    private final int disabledBackgroundColor;
    private final Context context;
    private final Typeface normalFont;
    private final MinMaxController minMaxController;
    public static final float DEFAULT_DISABLED_BACKGROUND_OPACITY = 0.3f;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    public final void render(@NotNull MonthItem item, @NotNull View rootView, @NotNull TextView textView, @NotNull Function1<? super MonthItem.DayOfMonth, Unit> onSelection) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        Intrinsics.checkParameterIsNotNull(onSelection, (String)"onSelection");
        MonthItem monthItem = item;
        if (monthItem instanceof MonthItem.WeekHeader) {
            this.renderWeekHeader(((MonthItem.WeekHeader)item).getDayOfWeek(), textView);
        } else if (monthItem instanceof MonthItem.DayOfMonth) {
            this.renderDayOfMonth((MonthItem.DayOfMonth)item, rootView, textView, onSelection);
        }
    }

    private final void renderWeekHeader(DayOfWeek dayOfWeek, TextView textView) {
        TextView textView2 = textView;
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView2;
        boolean bl3 = false;
        Context context = $this$apply.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        $this$apply.setTextColor(ContextsKt.resolveColor$default(context, 16842808, null, 2, null));
        $this$apply.setText((CharSequence)String.valueOf(StringsKt.first((CharSequence)dayOfWeek.name())));
        $this$apply.setTypeface(this.normalFont);
    }

    private final void renderDayOfMonth(MonthItem.DayOfMonth dayOfMonth, View rootView, TextView textView, Function1<? super MonthItem.DayOfMonth, Unit> onSelection) {
        rootView.setBackground((Drawable)null);
        TextView textView2 = textView;
        int n = 0;
        int n2 = 0;
        TextView $this$apply = textView2;
        boolean bl = false;
        Context context = $this$apply.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        $this$apply.setTextColor(Util.createTextSelector$default(Util.INSTANCE, context, this.selectionColor, false, 4, null));
        $this$apply.setText((CharSequence)this.positiveOrEmptyAsString(dayOfMonth.getDate()));
        $this$apply.setTypeface(this.normalFont);
        $this$apply.setGravity(17);
        $this$apply.setBackground((Drawable)null);
        $this$apply.setOnClickListener(null);
        if (dayOfMonth.getDate() == -1) {
            rootView.setEnabled(false);
            textView.setSelected(false);
            return;
        }
        n = dayOfMonth.getDate();
        n2 = dayOfMonth.getMonth().getYear();
        DateSnapshot currentDate = new DateSnapshot(dayOfMonth.getMonth().getMonth(), n, n2);
        textView.setSelected(dayOfMonth.isSelected());
        if (this.minMaxController.isOutOfMinRange(currentDate)) {
            int drawableRes = this.minMaxController.getOutOfMinRangeBackgroundRes(currentDate);
            View view = rootView;
            boolean bl2 = false;
            bl = false;
            View $this$apply2 = view;
            boolean bl3 = false;
            Context context2 = $this$apply2.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            $this$apply2.setBackground(Util.INSTANCE.coloredDrawable(context2, drawableRes, this.disabledBackgroundColor));
            $this$apply2.setEnabled(false);
        } else if (this.minMaxController.isOutOfMaxRange(currentDate)) {
            int drawable2 = this.minMaxController.getOutOfMaxRangeBackgroundRes(currentDate);
            View view = rootView;
            boolean bl4 = false;
            bl = false;
            View $this$apply3 = view;
            boolean bl5 = false;
            Context context3 = $this$apply3.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
            $this$apply3.setBackground(Util.INSTANCE.coloredDrawable(context3, drawable2, this.disabledBackgroundColor));
            $this$apply3.setEnabled(false);
        } else {
            CharSequence charSequence = ((Object)textView.getText()).toString();
            View view = rootView;
            n2 = 0;
            boolean bl6 = charSequence.length() > 0;
            view.setEnabled(bl6);
            charSequence = textView;
            n2 = 0;
            boolean bl7 = false;
            CharSequence $this$apply4 = charSequence;
            boolean bl8 = false;
            $this$apply4.setBackground(Util.INSTANCE.createCircularSelector(this.selectionColor));
            DebouncerKt.onClickDebounced((View)$this$apply4, (Function1)new Function1<TextView, Unit>(this, onSelection, dayOfMonth){
                final /* synthetic */ MonthItemRenderer this$0;
                final /* synthetic */ Function1 $onSelection$inlined;
                final /* synthetic */ MonthItem.DayOfMonth $dayOfMonth$inlined;
                {
                    this.this$0 = monthItemRenderer;
                    this.$onSelection$inlined = function1;
                    this.$dayOfMonth$inlined = dayOfMonth;
                    super(1);
                }

                public final void invoke(@NotNull TextView it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$onSelection$inlined.invoke((Object)this.$dayOfMonth$inlined);
                }
            });
        }
    }

    private final String positiveOrEmptyAsString(int $this$positiveOrEmptyAsString) {
        return $this$positiveOrEmptyAsString < 1 ? "" : String.valueOf($this$positiveOrEmptyAsString);
    }

    public MonthItemRenderer(@NotNull Context context, @NotNull TypedArray typedArray, @NotNull Typeface normalFont2, @NotNull MinMaxController minMaxController) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        Intrinsics.checkParameterIsNotNull((Object)normalFont2, (String)"normalFont");
        Intrinsics.checkParameterIsNotNull((Object)minMaxController, (String)"minMaxController");
        this.context = context;
        this.normalFont = normalFont2;
        this.minMaxController = minMaxController;
        this.selectionColor = AttrsKt.color(typedArray, R.styleable.DatePicker_date_picker_selection_color, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ MonthItemRenderer this$0;

            public final int invoke() {
                return ContextsKt.resolveColor$default(MonthItemRenderer.access$getContext$p(this.this$0), R.attr.colorAccent, null, 2, null);
            }
            {
                this.this$0 = monthItemRenderer;
                super(0);
            }
        }));
        this.disabledBackgroundColor = AttrsKt.color(typedArray, R.styleable.DatePicker_date_picker_disabled_background_color, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ MonthItemRenderer this$0;

            public final int invoke() {
                int n = ContextsKt.resolveColor$default(MonthItemRenderer.access$getContext$p(this.this$0), 16842808, null, 2, null);
                MonthItemRenderer.access$Companion();
                return ColorsKt.withAlpha(n, 0.3f);
            }
            {
                this.this$0 = monthItemRenderer;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Context access$getContext$p(MonthItemRenderer $this) {
        return $this.context;
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/afollestad/date/renderers/MonthItemRenderer$Companion;", "", "()V", "DEFAULT_DISABLED_BACKGROUND_OPACITY", "", "com.afollestad.date-picker"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

