/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.managers;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.CheckResult;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.afollestad.date.R;
import com.afollestad.date.adapters.MonthAdapter;
import com.afollestad.date.adapters.MonthItemAdapter;
import com.afollestad.date.adapters.YearAdapter;
import com.afollestad.date.controllers.VibratorController;
import com.afollestad.date.data.DateFormatter;
import com.afollestad.date.managers.DatePickerLayoutManager;
import com.afollestad.date.managers.DatePickerLayoutManager$WhenMappings;
import com.afollestad.date.util.AttrsKt;
import com.afollestad.date.util.ContextsKt;
import com.afollestad.date.util.DebouncerKt;
import com.afollestad.date.util.RecyclerViewsKt;
import com.afollestad.date.util.Util;
import com.afollestad.date.util.ViewsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 P2\u00020\u0001:\u0004PQRSB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\fJ\u0018\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\fH\u0007J\"\u00104\u001a\u00020-2\f\u00105\u001a\b\u0012\u0004\u0012\u00020-062\f\u00107\u001a\b\u0012\u0004\u0012\u00020-06J\u000e\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020\fJ\u000e\u0010:\u001a\u00020-2\u0006\u00109\u001a\u00020\fJ\u001e\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ\u0016\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DJ\u000e\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020HJ\b\u0010I\u001a\u00020-H\u0002J\b\u0010J\u001a\u00020-H\u0002J\b\u0010K\u001a\u00020-H\u0002J\u000e\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020-2\u0006\u0010M\u001a\u00020NR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager;", "", "context", "Landroid/content/Context;", "typedArray", "Landroid/content/res/TypedArray;", "root", "Landroid/view/ViewGroup;", "vibrator", "Lcom/afollestad/date/controllers/VibratorController;", "(Landroid/content/Context;Landroid/content/res/TypedArray;Landroid/view/ViewGroup;Lcom/afollestad/date/controllers/VibratorController;)V", "calendarHorizontalPadding", "", "chevronsTopMargin", "currentMonthHeight", "currentMonthTopMargin", "dateFormatter", "Lcom/afollestad/date/data/DateFormatter;", "daysRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "dividerHeight", "goNextMonthView", "Landroid/widget/ImageView;", "goPreviousMonthView", "headerBackgroundColor", "headersWithFactor", "listsDividerView", "Landroid/view/View;", "mediumFont", "Landroid/graphics/Typeface;", "monthRecyclerView", "normalFont", "orientation", "Lcom/afollestad/date/managers/DatePickerLayoutManager$Orientation;", "selectedDateView", "Landroid/widget/TextView;", "selectedYearView", "selectionColor", "getSelectionColor", "()I", "size", "Lcom/afollestad/date/managers/DatePickerLayoutManager$Size;", "visibleMonthView", "yearsRecyclerView", "onLayout", "", "left", "top", "right", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onNavigate", "onGoToPrevious", "Lkotlin/Function0;", "onGoToNext", "scrollToMonthPosition", "pos", "scrollToYearPosition", "setAdapters", "monthItemAdapter", "Lcom/afollestad/date/adapters/MonthItemAdapter;", "yearAdapter", "Lcom/afollestad/date/adapters/YearAdapter;", "monthAdapter", "Lcom/afollestad/date/adapters/MonthAdapter;", "setHeadersContent", "currentMonth", "Ljava/util/Calendar;", "selectedDate", "setMode", "mode", "Lcom/afollestad/date/managers/DatePickerLayoutManager$Mode;", "setupHeaderViews", "setupListViews", "setupNavigationViews", "showOrHideGoNext", "show", "", "showOrHideGoPrevious", "Companion", "Mode", "Orientation", "Size", "com.afollestad.date-picker"})
public final class DatePickerLayoutManager {
    private final int selectionColor;
    private final int headerBackgroundColor;
    private final Typeface normalFont;
    private final Typeface mediumFont;
    private final int calendarHorizontalPadding;
    private TextView selectedYearView;
    private TextView selectedDateView;
    private ImageView goPreviousMonthView;
    private TextView visibleMonthView;
    private ImageView goNextMonthView;
    private View listsDividerView;
    private RecyclerView daysRecyclerView;
    private RecyclerView yearsRecyclerView;
    private RecyclerView monthRecyclerView;
    private final int currentMonthTopMargin;
    private final int chevronsTopMargin;
    private final int currentMonthHeight;
    private final int dividerHeight;
    private final int headersWithFactor;
    private final DateFormatter dateFormatter;
    private final Size size;
    private final Orientation orientation;
    private final VibratorController vibrator;
    private static final int DAYS_IN_WEEK = 7;
    public static final Companion Companion = new Companion(null);

    public final int getSelectionColor() {
        return this.selectionColor;
    }

    @CheckResult
    @NotNull
    public final Size onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int headersWidth = parentWidth / this.headersWithFactor;
        this.selectedYearView.measure(View.MeasureSpec.makeMeasureSpec((int)headersWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.selectedDateView.measure(View.MeasureSpec.makeMeasureSpec((int)headersWidth, (int)0x40000000), parentHeight <= 0 || this.orientation == Orientation.PORTRAIT ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)(parentHeight - this.selectedYearView.getMeasuredHeight()), (int)0x40000000));
        int nonHeadersWidth = this.orientation == Orientation.PORTRAIT ? parentWidth : parentWidth - headersWidth;
        this.visibleMonthView.measure(View.MeasureSpec.makeMeasureSpec((int)nonHeadersWidth, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.currentMonthHeight, (int)0x40000000));
        this.listsDividerView.measure(View.MeasureSpec.makeMeasureSpec((int)nonHeadersWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.dividerHeight, (int)0x40000000));
        int heightSoFar = this.orientation == Orientation.PORTRAIT ? this.selectedYearView.getMeasuredHeight() + this.selectedDateView.getMeasuredHeight() + this.visibleMonthView.getMeasuredHeight() + this.listsDividerView.getMeasuredHeight() : this.visibleMonthView.getMeasuredHeight() + this.listsDividerView.getMeasuredHeight();
        int recyclerViewsWidth = nonHeadersWidth - this.calendarHorizontalPadding * 2;
        this.daysRecyclerView.measure(View.MeasureSpec.makeMeasureSpec((int)recyclerViewsWidth, (int)0x40000000), parentHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)(parentHeight - heightSoFar), (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        int chevronWidthAndHeight = recyclerViewsWidth / 7;
        this.goPreviousMonthView.measure(View.MeasureSpec.makeMeasureSpec((int)chevronWidthAndHeight, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)chevronWidthAndHeight, (int)0x40000000));
        this.goNextMonthView.measure(View.MeasureSpec.makeMeasureSpec((int)chevronWidthAndHeight, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)chevronWidthAndHeight, (int)0x40000000));
        this.yearsRecyclerView.measure(View.MeasureSpec.makeMeasureSpec((int)this.daysRecyclerView.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.daysRecyclerView.getMeasuredHeight(), (int)0x40000000));
        this.monthRecyclerView.measure(View.MeasureSpec.makeMeasureSpec((int)this.daysRecyclerView.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.daysRecyclerView.getMeasuredHeight(), (int)0x40000000));
        Size size = this.size;
        boolean bl = false;
        boolean bl2 = false;
        Size $this$apply = size;
        boolean bl3 = false;
        $this$apply.setWidth(parentWidth);
        $this$apply.setHeight(heightSoFar + this.daysRecyclerView.getMeasuredHeight() + this.chevronsTopMargin + this.currentMonthTopMargin);
        return size;
    }

    public final void onLayout(int left, int top, int right) {
        ViewsKt.placeAt$default((View)this.selectedYearView, top, 0, 0, 0, 14, null);
        ViewsKt.placeAt$default((View)this.selectedDateView, this.selectedYearView.getBottom(), 0, 0, 0, 14, null);
        int nonHeaderLeft = this.orientation == Orientation.PORTRAIT ? left : this.selectedDateView.getRight();
        int nonHeaderWidth = right - nonHeaderLeft;
        int middleX = right - nonHeaderWidth / 2;
        int n = 0;
        int n2 = 0;
        int n3 = this.orientation == Orientation.PORTRAIT ? this.selectedDateView.getBottom() + this.currentMonthTopMargin : this.currentMonthTopMargin;
        int n4 = middleX - this.visibleMonthView.getMeasuredWidth() / 2;
        ViewsKt.placeAt$default((View)this.visibleMonthView, n3, n4, n2, n, 12, null);
        ViewsKt.placeAt$default(this.listsDividerView, this.visibleMonthView.getBottom(), nonHeaderLeft, 0, 0, 12, null);
        n = 0;
        n2 = 0;
        n3 = this.listsDividerView.getBottom();
        n4 = nonHeaderLeft + this.calendarHorizontalPadding;
        ViewsKt.placeAt$default((View)this.daysRecyclerView, n3, n4, n2, n, 12, null);
        int chevronsMiddleY = this.visibleMonthView.getBottom() - this.visibleMonthView.getMeasuredHeight() / 2;
        int chevronsTop = chevronsMiddleY - this.goPreviousMonthView.getMeasuredHeight() / 2 + this.chevronsTopMargin;
        n3 = 0;
        n4 = 0;
        int n5 = chevronsTop;
        int n6 = this.daysRecyclerView.getLeft() + this.calendarHorizontalPadding;
        ViewsKt.placeAt$default((View)this.goPreviousMonthView, n5, n6, n4, n3, 12, null);
        n3 = 0;
        n4 = 0;
        n5 = chevronsTop;
        n6 = this.daysRecyclerView.getRight() - this.goNextMonthView.getMeasuredWidth() - this.calendarHorizontalPadding;
        ViewsKt.placeAt$default((View)this.goNextMonthView, n5, n6, n4, n3, 12, null);
        this.yearsRecyclerView.layout(this.daysRecyclerView.getLeft(), this.daysRecyclerView.getTop(), this.daysRecyclerView.getRight(), this.daysRecyclerView.getBottom());
        this.monthRecyclerView.layout(this.daysRecyclerView.getLeft(), this.daysRecyclerView.getTop(), this.daysRecyclerView.getRight(), this.daysRecyclerView.getBottom());
    }

    public final void setAdapters(@NotNull MonthItemAdapter monthItemAdapter, @NotNull YearAdapter yearAdapter, @NotNull MonthAdapter monthAdapter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)monthItemAdapter), (String)"monthItemAdapter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)yearAdapter), (String)"yearAdapter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)monthAdapter), (String)"monthAdapter");
        this.daysRecyclerView.setAdapter((RecyclerView.Adapter)monthItemAdapter);
        this.yearsRecyclerView.setAdapter((RecyclerView.Adapter)yearAdapter);
        this.monthRecyclerView.setAdapter((RecyclerView.Adapter)monthAdapter);
    }

    public final void showOrHideGoPrevious(boolean show) {
        ViewsKt.showOrConceal((View)this.goPreviousMonthView, show);
    }

    public final void showOrHideGoNext(boolean show) {
        ViewsKt.showOrConceal((View)this.goNextMonthView, show);
    }

    public final void setHeadersContent(@NotNull Calendar currentMonth, @NotNull Calendar selectedDate) {
        Intrinsics.checkParameterIsNotNull((Object)currentMonth, (String)"currentMonth");
        Intrinsics.checkParameterIsNotNull((Object)selectedDate, (String)"selectedDate");
        this.visibleMonthView.setText((CharSequence)this.dateFormatter.monthAndYear(currentMonth));
        this.selectedYearView.setText((CharSequence)this.dateFormatter.year(selectedDate));
        this.selectedDateView.setText((CharSequence)this.dateFormatter.date(selectedDate));
    }

    public final void scrollToYearPosition(int pos) {
        this.yearsRecyclerView.scrollToPosition(pos - 2);
    }

    public final void scrollToMonthPosition(int pos) {
        this.monthRecyclerView.scrollToPosition(pos - 2);
    }

    public final void onNavigate(@NotNull Function0<Unit> onGoToPrevious, @NotNull Function0<Unit> onGoToNext) {
        Intrinsics.checkParameterIsNotNull(onGoToPrevious, (String)"onGoToPrevious");
        Intrinsics.checkParameterIsNotNull(onGoToNext, (String)"onGoToNext");
        DebouncerKt.onClickDebounced((View)this.goPreviousMonthView, (Function1)new Function1<ImageView, Unit>(onGoToPrevious){
            final /* synthetic */ Function0 $onGoToPrevious;

            public final void invoke(@NotNull ImageView it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$onGoToPrevious.invoke();
            }
            {
                this.$onGoToPrevious = function0;
                super(1);
            }
        });
        DebouncerKt.onClickDebounced((View)this.goNextMonthView, (Function1)new Function1<ImageView, Unit>(onGoToNext){
            final /* synthetic */ Function0 $onGoToNext;

            public final void invoke(@NotNull ImageView it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$onGoToNext.invoke();
            }
            {
                this.$onGoToNext = function0;
                super(1);
            }
        });
    }

    private final void setupHeaderViews() {
        TextView textView = this.selectedYearView;
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        $this$apply.setBackground((Drawable)new ColorDrawable(this.headerBackgroundColor));
        $this$apply.setTypeface(this.normalFont);
        DebouncerKt.onClickDebounced((View)$this$apply, (Function1)new Function1<TextView, Unit>(this){
            final /* synthetic */ DatePickerLayoutManager this$0;
            {
                this.this$0 = datePickerLayoutManager;
                super(1);
            }

            public final void invoke(@NotNull TextView it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setMode(Mode.YEAR_LIST);
            }
        });
        textView = this.selectedDateView;
        bl = false;
        bl2 = false;
        $this$apply = textView;
        boolean bl4 = false;
        $this$apply.setSelected(true);
        $this$apply.setBackground((Drawable)new ColorDrawable(this.headerBackgroundColor));
        $this$apply.setTypeface(this.mediumFont);
        DebouncerKt.onClickDebounced((View)$this$apply, (Function1)new Function1<TextView, Unit>(this){
            final /* synthetic */ DatePickerLayoutManager this$0;
            {
                this.this$0 = datePickerLayoutManager;
                super(1);
            }

            public final void invoke(@NotNull TextView it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setMode(Mode.CALENDAR);
            }
        });
    }

    private final void setupNavigationViews() {
        this.goPreviousMonthView.setBackground(Util.INSTANCE.createCircularSelector(this.selectionColor));
        TextView textView = this.visibleMonthView;
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        $this$apply.setTypeface(this.mediumFont);
        DebouncerKt.onClickDebounced((View)$this$apply, (Function1)new Function1<TextView, Unit>(this){
            final /* synthetic */ DatePickerLayoutManager this$0;
            {
                this.this$0 = datePickerLayoutManager;
                super(1);
            }

            public final void invoke(@NotNull TextView it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setMode(Mode.MONTH_LIST);
            }
        });
        this.goNextMonthView.setBackground(Util.INSTANCE.createCircularSelector(this.selectionColor));
    }

    private final void setupListViews() {
        RecyclerView recyclerView = this.daysRecyclerView;
        boolean bl = false;
        boolean bl2 = false;
        RecyclerView $this$apply = recyclerView;
        boolean bl3 = false;
        $this$apply.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager($this$apply.getContext(), $this$apply.getResources().getInteger(R.integer.day_grid_span)));
        RecyclerViewsKt.attachTopDivider($this$apply, this.listsDividerView);
        ViewsKt.updatePadding$default((View)$this$apply, this.calendarHorizontalPadding, 0, this.calendarHorizontalPadding, 0, 10, null);
        recyclerView = this.yearsRecyclerView;
        bl = false;
        bl2 = false;
        $this$apply = recyclerView;
        boolean bl4 = false;
        $this$apply.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$apply.getContext()));
        $this$apply.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration($this$apply.getContext(), 1));
        RecyclerViewsKt.attachTopDivider($this$apply, this.listsDividerView);
        recyclerView = this.monthRecyclerView;
        bl = false;
        bl2 = false;
        $this$apply = recyclerView;
        boolean bl5 = false;
        $this$apply.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$apply.getContext()));
        $this$apply.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration($this$apply.getContext(), 1));
        RecyclerViewsKt.attachTopDivider($this$apply, this.listsDividerView);
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        ViewsKt.showOrConceal((View)this.daysRecyclerView, mode == Mode.CALENDAR);
        ViewsKt.showOrConceal((View)this.yearsRecyclerView, mode == Mode.YEAR_LIST);
        ViewsKt.showOrConceal((View)this.monthRecyclerView, mode == Mode.MONTH_LIST);
        switch (DatePickerLayoutManager$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                RecyclerViewsKt.invalidateTopDividerNow(this.daysRecyclerView, this.listsDividerView);
                break;
            }
            case 2: {
                RecyclerViewsKt.invalidateTopDividerNow(this.monthRecyclerView, this.listsDividerView);
                break;
            }
            case 3: {
                RecyclerViewsKt.invalidateTopDividerNow(this.yearsRecyclerView, this.listsDividerView);
            }
        }
        TextView textView = this.selectedYearView;
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        $this$apply.setSelected(mode == Mode.YEAR_LIST);
        $this$apply.setTypeface(mode == Mode.YEAR_LIST ? this.mediumFont : this.normalFont);
        textView = this.selectedDateView;
        bl = false;
        bl2 = false;
        $this$apply = textView;
        boolean bl4 = false;
        $this$apply.setSelected(mode == Mode.CALENDAR);
        $this$apply.setTypeface(mode == Mode.CALENDAR ? this.mediumFont : this.normalFont);
        this.vibrator.vibrateForSelection();
    }

    public DatePickerLayoutManager(@NotNull Context context, @NotNull TypedArray typedArray, @NotNull ViewGroup root, @NotNull VibratorController vibrator) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)vibrator, (String)"vibrator");
        this.vibrator = vibrator;
        this.selectionColor = AttrsKt.color(typedArray, R.styleable.DatePicker_date_picker_selection_color, (Function0<Integer>)((Function0)new Function0<Integer>(context){
            final /* synthetic */ Context $context;

            public final int invoke() {
                return ContextsKt.resolveColor$default(this.$context, R.attr.colorAccent, null, 2, null);
            }
            {
                this.$context = context;
                super(0);
            }
        }));
        this.headerBackgroundColor = AttrsKt.color(typedArray, R.styleable.DatePicker_date_picker_header_background_color, (Function0<Integer>)((Function0)new Function0<Integer>(context){
            final /* synthetic */ Context $context;

            public final int invoke() {
                return ContextsKt.resolveColor$default(this.$context, R.attr.colorAccent, null, 2, null);
            }
            {
                this.$context = context;
                super(0);
            }
        }));
        this.normalFont = AttrsKt.font(typedArray, context, R.styleable.DatePicker_date_picker_normal_font, (Function0<? extends Typeface>)((Function0)normalFont.1.INSTANCE));
        this.mediumFont = AttrsKt.font(typedArray, context, R.styleable.DatePicker_date_picker_medium_font, (Function0<? extends Typeface>)((Function0)mediumFont.1.INSTANCE));
        this.calendarHorizontalPadding = typedArray.getDimensionPixelSize(R.styleable.DatePicker_date_picker_calendar_horizontal_padding, 0);
        View view = root.findViewById(R.id.current_year);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"root.findViewById(R.id.current_year)");
        this.selectedYearView = (TextView)view;
        View view2 = root.findViewById(R.id.current_date);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"root.findViewById(R.id.current_date)");
        this.selectedDateView = (TextView)view2;
        View view3 = root.findViewById(R.id.left_chevron);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"root.findViewById(R.id.left_chevron)");
        this.goPreviousMonthView = (ImageView)view3;
        View view4 = root.findViewById(R.id.current_month);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"root.findViewById(R.id.current_month)");
        this.visibleMonthView = (TextView)view4;
        View view5 = root.findViewById(R.id.right_chevron);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"root.findViewById(R.id.right_chevron)");
        this.goNextMonthView = (ImageView)view5;
        View view6 = root.findViewById(R.id.year_month_list_divider);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"root.findViewById(R.id.year_month_list_divider)");
        this.listsDividerView = view6;
        View view7 = root.findViewById(R.id.day_list);
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"root.findViewById(R.id.day_list)");
        this.daysRecyclerView = (RecyclerView)view7;
        View view8 = root.findViewById(R.id.year_list);
        Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"root.findViewById(R.id.year_list)");
        this.yearsRecyclerView = (RecyclerView)view8;
        View view9 = root.findViewById(R.id.month_list);
        Intrinsics.checkExpressionValueIsNotNull((Object)view9, (String)"root.findViewById(R.id.month_list)");
        this.monthRecyclerView = (RecyclerView)view9;
        this.currentMonthTopMargin = context.getResources().getDimensionPixelSize(R.dimen.current_month_top_margin);
        this.chevronsTopMargin = context.getResources().getDimensionPixelSize(R.dimen.chevrons_top_margin);
        this.currentMonthHeight = context.getResources().getDimensionPixelSize(R.dimen.current_month_header_height);
        this.dividerHeight = context.getResources().getDimensionPixelSize(R.dimen.divider_height);
        this.headersWithFactor = context.getResources().getInteger(R.integer.headers_width_factor);
        this.dateFormatter = new DateFormatter();
        this.size = new Size(0, 0);
        this.orientation = Orientation.Companion.get(context);
        this.setupHeaderViews();
        this.setupNavigationViews();
        this.setupListViews();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager$Mode;", "", "(Ljava/lang/String;I)V", "CALENDAR", "MONTH_LIST", "YEAR_LIST", "com.afollestad.date-picker"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode CALENDAR;
        public static final /* enum */ Mode MONTH_LIST;
        public static final /* enum */ Mode YEAR_LIST;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = CALENDAR = new Mode();
            modeArray[1] = MONTH_LIST = new Mode();
            modeArray[2] = YEAR_LIST = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager$Orientation;", "", "(Ljava/lang/String;I)V", "PORTRAIT", "LANDSCAPE", "Companion", "com.afollestad.date-picker"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation PORTRAIT;
        public static final /* enum */ Orientation LANDSCAPE;
        private static final /* synthetic */ Orientation[] $VALUES;
        public static final Companion Companion;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = PORTRAIT = new Orientation();
            orientationArray[1] = LANDSCAPE = new Orientation();
            $VALUES = orientationArray;
            Companion = new Companion(null);
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager$Orientation$Companion;", "", "()V", "get", "Lcom/afollestad/date/managers/DatePickerLayoutManager$Orientation;", "context", "Landroid/content/Context;", "com.afollestad.date-picker"})
        public static final class Companion {
            @NotNull
            public final Orientation get(@NotNull Context context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Resources resources = context.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
                return resources.getConfiguration().orientation == 1 ? PORTRAIT : LANDSCAPE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager$Size;", "", "width", "", "height", "(II)V", "getHeight", "()I", "setHeight", "(I)V", "getWidth", "setWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "com.afollestad.date-picker"})
    public static final class Size {
        private int width;
        private int height;

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final Size copy(int width, int height) {
            return new Size(width, height);
        }

        public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = size.width;
            }
            if ((n3 & 2) != 0) {
                n2 = size.height;
            }
            return size.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Size(width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            return this.width * 31 + this.height;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Size)) break block3;
                    Size size = (Size)object;
                    if (!(this.width == size.width) || !(this.height == size.height)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/afollestad/date/managers/DatePickerLayoutManager$Companion;", "", "()V", "DAYS_IN_WEEK", "", "inflateInto", "Lcom/afollestad/date/managers/DatePickerLayoutManager;", "context", "Landroid/content/Context;", "typedArray", "Landroid/content/res/TypedArray;", "container", "Landroid/view/ViewGroup;", "com.afollestad.date-picker"})
    public static final class Companion {
        @CheckResult
        @NotNull
        public final DatePickerLayoutManager inflateInto(@NotNull Context context, @NotNull TypedArray typedArray, @NotNull ViewGroup container) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            View.inflate((Context)context, (int)R.layout.date_picker, (ViewGroup)container);
            VibratorController vibrator = new VibratorController(context, typedArray);
            return new DatePickerLayoutManager(context, typedArray, container, vibrator);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

