/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.data;

import androidx.annotation.CheckResult;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/afollestad/date/data/DateFormatter;", "", "()V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "monthAndYearFormatter", "monthFormatter", "yearFormatter", "date", "", "calendar", "Ljava/util/Calendar;", "month", "monthAndYear", "year", "com.afollestad.date-picker"})
public final class DateFormatter {
    private final SimpleDateFormat monthAndYearFormatter = new SimpleDateFormat("MMMM yyyy", Locale.getDefault());
    private final SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy", Locale.getDefault());
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, MMM dd", Locale.getDefault());
    private final SimpleDateFormat monthFormatter = new SimpleDateFormat("MMMM", Locale.getDefault());

    @CheckResult
    @NotNull
    public final String monthAndYear(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        String string = this.monthAndYearFormatter.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"monthAndYearFormatter.format(calendar.time)");
        return string;
    }

    @CheckResult
    @NotNull
    public final String year(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        String string = this.yearFormatter.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"yearFormatter.format(calendar.time)");
        return string;
    }

    @CheckResult
    @NotNull
    public final String date(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        String string = this.dateFormatter.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dateFormatter.format(calendar.time)");
        return string;
    }

    @CheckResult
    @NotNull
    public final String month(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        String string = this.monthFormatter.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"monthFormatter.format(calendar.time)");
        return string;
    }
}

