/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.controllers;

import androidx.annotation.CheckResult;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import com.afollestad.date.CalendarsKt;
import com.afollestad.date.R;
import com.afollestad.date.data.snapshot.DateSnapshot;
import com.afollestad.date.data.snapshot.DateSnapshotKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\n\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0012\u0010\u0011\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0012\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tJ\"\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tJ\"\u0010\u0018\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\u0014H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/afollestad/date/controllers/MinMaxController;", "", "()V", "maxDate", "Lcom/afollestad/date/data/snapshot/DateSnapshot;", "minDate", "canGoBack", "", "from", "Ljava/util/Calendar;", "canGoForward", "getMaxDate", "getMinDate", "getOutOfMaxRangeBackgroundRes", "", "date", "getOutOfMinRangeBackgroundRes", "isOutOfMaxRange", "isOutOfMinRange", "setMaxDate", "", "year", "month", "dayOfMonth", "setMinDate", "validateMinAndMax", "com.afollestad.date-picker"})
public final class MinMaxController {
    private DateSnapshot minDate;
    private DateSnapshot maxDate;

    @CheckResult
    @Nullable
    public final Calendar getMinDate() {
        DateSnapshot dateSnapshot = this.minDate;
        return dateSnapshot != null ? dateSnapshot.asCalendar() : null;
    }

    public final void setMinDate(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.minDate = DateSnapshotKt.snapshot(date);
        this.validateMinAndMax();
    }

    public final void setMinDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) int year, int month, @IntRange(from=1L, to=31L) int dayOfMonth) {
        int n = dayOfMonth;
        int n2 = year;
        this.minDate = new DateSnapshot(month, n, n2);
        this.validateMinAndMax();
    }

    @CheckResult
    @Nullable
    public final Calendar getMaxDate() {
        DateSnapshot dateSnapshot = this.maxDate;
        return dateSnapshot != null ? dateSnapshot.asCalendar() : null;
    }

    public final void setMaxDate(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.maxDate = DateSnapshotKt.snapshot(date);
        this.validateMinAndMax();
    }

    public final void setMaxDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) int year, int month, @IntRange(from=1L, to=31L) int dayOfMonth) {
        int n = dayOfMonth;
        int n2 = year;
        this.maxDate = new DateSnapshot(month, n, n2);
        this.validateMinAndMax();
    }

    @CheckResult
    public final boolean canGoBack(@NotNull Calendar from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (this.minDate == null) {
            return true;
        }
        DateSnapshot lastMonth = DateSnapshotKt.snapshot(CalendarsKt.decrementMonth(from));
        return !this.isOutOfMinRange(lastMonth);
    }

    @CheckResult
    public final boolean canGoForward(@NotNull Calendar from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (this.maxDate == null) {
            return true;
        }
        DateSnapshot nextMonth = DateSnapshotKt.snapshot(CalendarsKt.incrementMonth(from));
        return !this.isOutOfMaxRange(nextMonth);
    }

    @CheckResult
    public final boolean isOutOfMinRange(@Nullable DateSnapshot date) {
        if (date == null || this.minDate == null) {
            return false;
        }
        DateSnapshot dateSnapshot = this.minDate;
        if (dateSnapshot == null) {
            Intrinsics.throwNpe();
        }
        return date.compareTo(dateSnapshot) < 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @DrawableRes
    @CheckResult
    public final int getOutOfMinRangeBackgroundRes(@NotNull DateSnapshot date) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar calendar = date.asCalendar();
        boolean isLastInMonth = CalendarsKt.getDayOfMonth(calendar) == CalendarsKt.getTotalDaysInMonth(calendar);
        if (isLastInMonth) {
            n = R.drawable.ic_tube_end;
            return n;
        }
        if (date.getDay() == 1) {
            n = R.drawable.ic_tube_start;
            return n;
        }
        int n2 = date.getDay();
        DateSnapshot dateSnapshot = this.minDate;
        if (dateSnapshot == null) {
            Intrinsics.throwNpe();
        }
        if (n2 == dateSnapshot.getDay() - 1) {
            int n3 = date.getMonth();
            DateSnapshot dateSnapshot2 = this.minDate;
            if (dateSnapshot2 == null) {
                Intrinsics.throwNpe();
            }
            if (n3 == dateSnapshot2.getMonth()) {
                int n4 = date.getYear();
                DateSnapshot dateSnapshot3 = this.minDate;
                if (dateSnapshot3 == null) {
                    Intrinsics.throwNpe();
                }
                if (n4 == dateSnapshot3.getYear()) {
                    n = R.drawable.ic_tube_end;
                    return n;
                }
            }
        }
        n = R.drawable.ic_tube_middle;
        return n;
    }

    @CheckResult
    public final boolean isOutOfMaxRange(@Nullable DateSnapshot date) {
        if (date == null || this.maxDate == null) {
            return false;
        }
        DateSnapshot dateSnapshot = this.maxDate;
        if (dateSnapshot == null) {
            Intrinsics.throwNpe();
        }
        return date.compareTo(dateSnapshot) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @DrawableRes
    @CheckResult
    public final int getOutOfMaxRangeBackgroundRes(@NotNull DateSnapshot date) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar calendar = date.asCalendar();
        boolean isLastInMonth = CalendarsKt.getDayOfMonth(calendar) == CalendarsKt.getTotalDaysInMonth(calendar);
        if (date.getDay() == 1) {
            n = R.drawable.ic_tube_start;
            return n;
        }
        int n2 = date.getDay();
        DateSnapshot dateSnapshot = this.maxDate;
        if (dateSnapshot == null) {
            Intrinsics.throwNpe();
        }
        if (n2 == dateSnapshot.getDay() + 1) {
            int n3 = date.getMonth();
            DateSnapshot dateSnapshot2 = this.maxDate;
            if (dateSnapshot2 == null) {
                Intrinsics.throwNpe();
            }
            if (n3 == dateSnapshot2.getMonth()) {
                int n4 = date.getYear();
                DateSnapshot dateSnapshot3 = this.maxDate;
                if (dateSnapshot3 == null) {
                    Intrinsics.throwNpe();
                }
                if (n4 == dateSnapshot3.getYear()) {
                    n = R.drawable.ic_tube_start;
                    return n;
                }
            }
        }
        if (isLastInMonth) {
            n = R.drawable.ic_tube_end;
            return n;
        }
        n = R.drawable.ic_tube_middle;
        return n;
    }

    private final void validateMinAndMax() {
        if (this.minDate != null && this.maxDate != null) {
            DateSnapshot dateSnapshot = this.minDate;
            if (dateSnapshot == null) {
                Intrinsics.throwNpe();
            }
            DateSnapshot dateSnapshot2 = this.maxDate;
            if (dateSnapshot2 == null) {
                Intrinsics.throwNpe();
            }
            boolean bl = dateSnapshot.compareTo(dateSnapshot2) < 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Min date must be less than max date.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }
}

