/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.controllers;

import androidx.annotation.CheckResult;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import com.afollestad.date.CalendarsKt;
import com.afollestad.date.controllers.MinMaxController;
import com.afollestad.date.controllers.VibratorController;
import com.afollestad.date.data.MonthGraph;
import com.afollestad.date.data.MonthItem;
import com.afollestad.date.data.snapshot.DateSnapshot;
import com.afollestad.date.data.snapshot.DateSnapshotKt;
import com.afollestad.date.data.snapshot.MonthSnapshot;
import com.afollestad.date.data.snapshot.MonthSnapshotKt;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u00ad\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\t0\u000b\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\t0\u000b\u0012!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\t0\u000b\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0015\u00a2\u0006\u0002\u0010\u0017JB\u0010;\u001a\u00020\t2:\u0010<\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\u001cJ\u0006\u0010=\u001a\u00020\tJ\b\u0010>\u001a\u00020\bH\u0002J\n\u0010?\u001a\u0004\u0018\u00010\bH\u0007J\u0006\u0010@\u001a\u00020\tJ\u0006\u0010A\u001a\u00020\tJ\u001e\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002J\u0006\u0010E\u001a\u00020\tJ\u0010\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\bH\u0002J\u000e\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020JJ\u0018\u0010K\u001a\u00020\t2\u0006\u0010G\u001a\u00020\b2\b\b\u0002\u0010B\u001a\u00020\u000fJ5\u0010K\u001a\u00020\t2\n\b\u0003\u0010L\u001a\u0004\u0018\u00010J2\u0006\u0010M\u001a\u00020J2\n\b\u0003\u0010-\u001a\u0004\u0018\u00010J2\b\b\u0002\u0010B\u001a\u00020\u000f\u00a2\u0006\u0002\u0010NJ\u000e\u0010O\u001a\u00020\t2\u0006\u0010M\u001a\u00020JJ\u000e\u0010P\u001a\u00020\t2\u0006\u0010L\u001a\u00020JJ\u0010\u0010Q\u001a\u00020\t2\u0006\u0010G\u001a\u00020\bH\u0002RH\u0010\u0018\u001a<\u00128\u00126\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010$\u001a\u0004\u0018\u00010%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010-\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b.\u0010\u001f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u00104\u001a\u0004\u0018\u0001058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b6\u0010\u001f\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006R"}, d2={"Lcom/afollestad/date/controllers/DatePickerController;", "", "vibrator", "Lcom/afollestad/date/controllers/VibratorController;", "minMaxController", "Lcom/afollestad/date/controllers/MinMaxController;", "renderHeaders", "Lkotlin/Function2;", "Ljava/util/Calendar;", "", "renderMonthItems", "Lkotlin/Function1;", "", "Lcom/afollestad/date/data/MonthItem;", "goBackVisibility", "", "Lkotlin/ParameterName;", "name", "visible", "goForwardVisibility", "switchToDaysOfMonthMode", "Lkotlin/Function0;", "getNow", "(Lcom/afollestad/date/controllers/VibratorController;Lcom/afollestad/date/controllers/MinMaxController;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "dateChangedListeners", "", "previous", "date", "Lcom/afollestad/date/OnDateChanged;", "didInit", "didInit$annotations", "()V", "getDidInit", "()Z", "setDidInit", "(Z)V", "monthGraph", "Lcom/afollestad/date/data/MonthGraph;", "monthGraph$annotations", "getMonthGraph", "()Lcom/afollestad/date/data/MonthGraph;", "setMonthGraph", "(Lcom/afollestad/date/data/MonthGraph;)V", "value", "Lcom/afollestad/date/data/snapshot/DateSnapshot;", "selectedDate", "selectedDate$annotations", "getSelectedDate", "()Lcom/afollestad/date/data/snapshot/DateSnapshot;", "setSelectedDate", "(Lcom/afollestad/date/data/snapshot/DateSnapshot;)V", "selectedDateCalendar", "viewingMonth", "Lcom/afollestad/date/data/snapshot/MonthSnapshot;", "viewingMonth$annotations", "getViewingMonth", "()Lcom/afollestad/date/data/snapshot/MonthSnapshot;", "setViewingMonth", "(Lcom/afollestad/date/data/snapshot/MonthSnapshot;)V", "addDateChangedListener", "listener", "clearDateChangedListeners", "currentSelectedOrNow", "getFullDate", "maybeInit", "nextMonth", "notifyListeners", "old", "block", "previousMonth", "render", "calendar", "setDayOfMonth", "day", "", "setFullDate", "year", "month", "(Ljava/lang/Integer;ILjava/lang/Integer;Z)V", "setMonth", "setYear", "updateCurrentMonth", "com.afollestad.date-picker"})
public final class DatePickerController {
    private boolean didInit;
    private final List<Function2<Calendar, Calendar, Unit>> dateChangedListeners;
    @Nullable
    private MonthSnapshot viewingMonth;
    @Nullable
    private MonthGraph monthGraph;
    @Nullable
    private DateSnapshot selectedDate;
    private Calendar selectedDateCalendar;
    private final VibratorController vibrator;
    private final MinMaxController minMaxController;
    private final Function2<Calendar, Calendar, Unit> renderHeaders;
    private final Function1<List<? extends MonthItem>, Unit> renderMonthItems;
    private final Function1<Boolean, Unit> goBackVisibility;
    private final Function1<Boolean, Unit> goForwardVisibility;
    private final Function0<Unit> switchToDaysOfMonthMode;
    private final Function0<Calendar> getNow;

    @VisibleForTesting
    public static /* synthetic */ void didInit$annotations() {
    }

    public final boolean getDidInit() {
        return this.didInit;
    }

    public final void setDidInit(boolean bl) {
        this.didInit = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void viewingMonth$annotations() {
    }

    @Nullable
    public final MonthSnapshot getViewingMonth() {
        return this.viewingMonth;
    }

    public final void setViewingMonth(@Nullable MonthSnapshot monthSnapshot) {
        this.viewingMonth = monthSnapshot;
    }

    @VisibleForTesting
    public static /* synthetic */ void monthGraph$annotations() {
    }

    @Nullable
    public final MonthGraph getMonthGraph() {
        return this.monthGraph;
    }

    public final void setMonthGraph(@Nullable MonthGraph monthGraph) {
        this.monthGraph = monthGraph;
    }

    @VisibleForTesting
    public static /* synthetic */ void selectedDate$annotations() {
    }

    @Nullable
    public final DateSnapshot getSelectedDate() {
        return this.selectedDate;
    }

    public final void setSelectedDate(@Nullable DateSnapshot value) {
        this.selectedDate = value;
        DateSnapshot dateSnapshot = value;
        this.selectedDateCalendar = dateSnapshot != null ? dateSnapshot.asCalendar() : null;
    }

    public final void maybeInit() {
        if (!this.didInit) {
            Calendar now = (Calendar)this.getNow.invoke();
            DateSnapshot nowSnapshot = DateSnapshotKt.snapshot(now);
            if (this.minMaxController.isOutOfMaxRange(nowSnapshot)) {
                Calendar calendar = this.minMaxController.getMaxDate();
                if (calendar == null) {
                    Intrinsics.throwNpe();
                }
                now = calendar;
            } else if (this.minMaxController.isOutOfMinRange(nowSnapshot)) {
                Calendar calendar = this.minMaxController.getMinDate();
                if (calendar == null) {
                    Intrinsics.throwNpe();
                }
                now = calendar;
            }
            this.setFullDate(now, false);
        }
    }

    public final void previousMonth() {
        this.switchToDaysOfMonthMode.invoke();
        MonthSnapshot monthSnapshot = this.viewingMonth;
        if (monthSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = CalendarsKt.decrementMonth(MonthSnapshotKt.asCalendar(monthSnapshot, 1));
        this.updateCurrentMonth(calendar);
        this.render(calendar);
        this.vibrator.vibrateForSelection();
    }

    public final void nextMonth() {
        this.switchToDaysOfMonthMode.invoke();
        MonthSnapshot monthSnapshot = this.viewingMonth;
        if (monthSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = CalendarsKt.incrementMonth(MonthSnapshotKt.asCalendar(monthSnapshot, 1));
        this.updateCurrentMonth(calendar);
        this.render(calendar);
        this.vibrator.vibrateForSelection();
    }

    public final void setMonth(int month) {
        this.switchToDaysOfMonthMode.invoke();
        MonthSnapshot monthSnapshot = this.viewingMonth;
        if (monthSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = MonthSnapshotKt.asCalendar(monthSnapshot, 1);
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = calendar;
        boolean bl3 = false;
        CalendarsKt.setMonth($this$apply, month);
        Calendar calendar2 = calendar;
        this.updateCurrentMonth(calendar2);
        this.render(calendar2);
        this.vibrator.vibrateForSelection();
    }

    public final void setFullDate(@NotNull Calendar calendar, boolean notifyListeners) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        Calendar oldSelected = this.currentSelectedOrNow();
        this.didInit = true;
        this.setSelectedDate(DateSnapshotKt.snapshot(calendar));
        if (notifyListeners) {
            this.notifyListeners(oldSelected, (Function0<? extends Calendar>)((Function0)new Function0<Calendar>(calendar){
                final /* synthetic */ Calendar $calendar;

                @NotNull
                public final Calendar invoke() {
                    Object object = this.$calendar.clone();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Calendar");
                    }
                    return (Calendar)object;
                }
                {
                    this.$calendar = calendar;
                    super(0);
                }
            }));
        }
        this.updateCurrentMonth(calendar);
        this.render(calendar);
    }

    public static /* synthetic */ void setFullDate$default(DatePickerController datePickerController, Calendar calendar, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        datePickerController.setFullDate(calendar, bl);
    }

    public final void setFullDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) @Nullable Integer year, int month, @IntRange(from=1L, to=31L) @Nullable Integer selectedDate, boolean notifyListeners) {
        Object object = this.getNow.invoke();
        DatePickerController datePickerController = this;
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = (Calendar)object;
        boolean bl3 = false;
        if (year != null) {
            CalendarsKt.setYear($this$apply, year);
        }
        CalendarsKt.setMonth($this$apply, month);
        if (selectedDate != null) {
            CalendarsKt.setDayOfMonth($this$apply, selectedDate);
        }
        Object object2 = object;
        datePickerController.setFullDate((Calendar)object2, notifyListeners);
    }

    public static /* synthetic */ void setFullDate$default(DatePickerController datePickerController, Integer n, int n2, Integer n3, boolean bl, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        if ((n4 & 8) != 0) {
            bl = true;
        }
        datePickerController.setFullDate(n, n2, n3, bl);
    }

    @CheckResult
    @Nullable
    public final Calendar getFullDate() {
        if (this.minMaxController.isOutOfMinRange(this.selectedDate) || this.minMaxController.isOutOfMaxRange(this.selectedDate)) {
            return null;
        }
        return this.selectedDateCalendar;
    }

    public final void setDayOfMonth(int day) {
        if (!this.didInit) {
            Object object = this.getNow.invoke();
            DatePickerController datePickerController = this;
            boolean bl = false;
            boolean bl2 = false;
            Calendar $this$apply = (Calendar)object;
            boolean bl3 = false;
            CalendarsKt.setDayOfMonth($this$apply, day);
            Object object2 = object;
            DatePickerController.setFullDate$default(datePickerController, (Calendar)object2, false, 2, null);
            return;
        }
        Calendar oldSelected = this.currentSelectedOrNow();
        MonthSnapshot monthSnapshot = this.viewingMonth;
        if (monthSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = MonthSnapshotKt.asCalendar(monthSnapshot, day);
        this.setSelectedDate(DateSnapshotKt.snapshot(calendar));
        this.vibrator.vibrateForSelection();
        this.notifyListeners(oldSelected, (Function0<? extends Calendar>)((Function0)new Function0<Calendar>(calendar){
            final /* synthetic */ Calendar $calendar;

            @NotNull
            public final Calendar invoke() {
                return this.$calendar;
            }
            {
                this.$calendar = calendar;
                super(0);
            }
        }));
        this.render(calendar);
    }

    public final void setYear(int year) {
        int n;
        MonthSnapshot monthSnapshot = this.viewingMonth;
        if (monthSnapshot != null) {
            n = monthSnapshot.getMonth();
        } else {
            DateSnapshot dateSnapshot = this.selectedDate;
            if (dateSnapshot == null) {
                Intrinsics.throwNpe();
            }
            n = dateSnapshot.getMonth();
        }
        DateSnapshot dateSnapshot = this.selectedDate;
        boolean bl = false;
        Integer n2 = dateSnapshot != null ? Integer.valueOf(dateSnapshot.getDay()) : null;
        Integer n3 = year;
        int n4 = n;
        DatePickerController.setFullDate$default(this, n3, n4, n2, bl, 8, null);
        this.switchToDaysOfMonthMode.invoke();
    }

    public final void addDateChangedListener(@NotNull Function2<? super Calendar, ? super Calendar, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.dateChangedListeners.add(listener);
    }

    public final void clearDateChangedListeners() {
        this.dateChangedListeners.clear();
    }

    private final void updateCurrentMonth(Calendar calendar) {
        this.viewingMonth = MonthSnapshotKt.snapshotMonth(calendar);
        this.monthGraph = new MonthGraph(calendar);
    }

    private final void render(Calendar calendar) {
        Calendar calendar2 = this.selectedDateCalendar;
        if (calendar2 == null) {
            Intrinsics.throwNpe();
        }
        this.renderHeaders.invoke((Object)calendar, (Object)calendar2);
        MonthGraph monthGraph = this.monthGraph;
        if (monthGraph == null) {
            Intrinsics.throwNpe();
        }
        DateSnapshot dateSnapshot = this.selectedDate;
        if (dateSnapshot == null) {
            Intrinsics.throwNpe();
        }
        this.renderMonthItems.invoke(monthGraph.getMonthItems(dateSnapshot));
        this.goBackVisibility.invoke((Object)this.minMaxController.canGoBack(calendar));
        this.goForwardVisibility.invoke((Object)this.minMaxController.canGoForward(calendar));
    }

    private final void notifyListeners(Calendar old, Function0<? extends Calendar> block) {
        if (this.dateChangedListeners.isEmpty()) {
            return;
        }
        Calendar arg = (Calendar)block.invoke();
        DateSnapshot argSnapshot = DateSnapshotKt.snapshot(arg);
        if (this.minMaxController.isOutOfMinRange(argSnapshot) || this.minMaxController.isOutOfMaxRange(argSnapshot)) {
            return;
        }
        Iterable $this$forEach$iv = this.dateChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)old, (Object)arg);
        }
    }

    private final Calendar currentSelectedOrNow() {
        Calendar calendar = this.selectedDateCalendar;
        if (calendar == null) {
            calendar = (Calendar)this.getNow.invoke();
        }
        return calendar;
    }

    public DatePickerController(@NotNull VibratorController vibrator, @NotNull MinMaxController minMaxController, @NotNull Function2<? super Calendar, ? super Calendar, Unit> renderHeaders, @NotNull Function1<? super List<? extends MonthItem>, Unit> renderMonthItems, @NotNull Function1<? super Boolean, Unit> goBackVisibility, @NotNull Function1<? super Boolean, Unit> goForwardVisibility, @NotNull Function0<Unit> switchToDaysOfMonthMode, @NotNull Function0<? extends Calendar> getNow) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)vibrator, (String)"vibrator");
        Intrinsics.checkParameterIsNotNull((Object)minMaxController, (String)"minMaxController");
        Intrinsics.checkParameterIsNotNull(renderHeaders, (String)"renderHeaders");
        Intrinsics.checkParameterIsNotNull(renderMonthItems, (String)"renderMonthItems");
        Intrinsics.checkParameterIsNotNull(goBackVisibility, (String)"goBackVisibility");
        Intrinsics.checkParameterIsNotNull(goForwardVisibility, (String)"goForwardVisibility");
        Intrinsics.checkParameterIsNotNull(switchToDaysOfMonthMode, (String)"switchToDaysOfMonthMode");
        Intrinsics.checkParameterIsNotNull(getNow, (String)"getNow");
        this.vibrator = vibrator;
        this.minMaxController = minMaxController;
        this.renderHeaders = renderHeaders;
        this.renderMonthItems = renderMonthItems;
        this.goBackVisibility = goBackVisibility;
        this.goForwardVisibility = goForwardVisibility;
        this.switchToDaysOfMonthMode = switchToDaysOfMonthMode;
        this.getNow = getNow;
        DatePickerController datePickerController = this;
        boolean bl = false;
        datePickerController.dateChangedListeners = list = (List)new ArrayList();
    }

    public /* synthetic */ DatePickerController(VibratorController vibratorController, MinMaxController minMaxController, Function2 function2, Function1 function1, Function1 function12, Function1 function13, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            function02 = 1.INSTANCE;
        }
        this(vibratorController, minMaxController, (Function2<? super Calendar, ? super Calendar, Unit>)function2, (Function1<? super List<? extends MonthItem>, Unit>)function1, (Function1<? super Boolean, Unit>)function12, (Function1<? super Boolean, Unit>)function13, (Function0<Unit>)function0, (Function0<? extends Calendar>)function02);
    }
}

