/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.adapters;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;
import com.afollestad.date.CalendarsKt;
import com.afollestad.date.R;
import com.afollestad.date.adapters.YearViewHolder;
import com.afollestad.date.util.Util;
import com.afollestad.date.util.ViewsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BB\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\r\u0010\u001c\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0015\u0010#\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b$J\f\u0010%\u001a\u00020\u0007*\u00020\u0007H\u0002J\f\u0010&\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/afollestad/date/adapters/YearAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/afollestad/date/adapters/YearViewHolder;", "normalFont", "Landroid/graphics/Typeface;", "mediumFont", "selectionColor", "", "onSelection", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "year", "", "(Landroid/graphics/Typeface;Landroid/graphics/Typeface;ILkotlin/jvm/functions/Function1;)V", "value", "selectedYear", "getSelectedYear", "()Ljava/lang/Integer;", "setSelectedYear", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "yearRange", "Lkotlin/Pair;", "getItemCount", "getItemId", "", "position", "getSelectedPosition", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onRowClicked", "onRowClicked$com_afollestad_date_picker", "asPosition", "asYear", "com.afollestad.date-picker"})
public final class YearAdapter
extends RecyclerView.Adapter<YearViewHolder> {
    @Nullable
    private Integer selectedYear;
    private final Pair<Integer, Integer> yearRange;
    private final Typeface normalFont;
    private final Typeface mediumFont;
    private final int selectionColor;
    private final Function1<Integer, Unit> onSelection;

    @Nullable
    public final Integer getSelectedYear() {
        return this.selectedYear;
    }

    public final void setSelectedYear(@Nullable Integer value) {
        Integer lastSelectedYear = this.selectedYear;
        this.selectedYear = value;
        if (lastSelectedYear != null) {
            this.notifyItemChanged(this.asPosition(lastSelectedYear));
        }
        if (value != null) {
            this.notifyItemChanged(this.asPosition(value));
        }
    }

    public long getItemId(int position) {
        return this.asYear(position);
    }

    @NotNull
    public YearViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Context context = parent.getContext();
        View view = ViewsKt.inflate(parent, R.layout.year_list_row);
        YearViewHolder yearViewHolder = new YearViewHolder(view, this);
        boolean bl = false;
        boolean bl2 = false;
        YearViewHolder $this$apply = yearViewHolder;
        boolean bl3 = false;
        TextView textView = $this$apply.getTextView();
        Context context2 = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        textView.setTextColor(Util.INSTANCE.createTextSelector(context2, this.selectionColor, false));
        return yearViewHolder;
    }

    public int getItemCount() {
        return ((Number)this.yearRange.getSecond()).intValue() - ((Number)this.yearRange.getFirst()).intValue();
    }

    public void onBindViewHolder(@NotNull YearViewHolder holder, int position) {
        int currentYear;
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Integer n = this.selectedYear;
        boolean isSelected = n != null && (currentYear = this.asYear(position)) == n;
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"holder.itemView.context");
        Resources res = context.getResources();
        holder.getTextView().setText((CharSequence)String.valueOf(currentYear));
        holder.getTextView().setSelected(isSelected);
        holder.getTextView().setTextSize(0, res.getDimension(isSelected ? R.dimen.year_month_list_text_size_selected : R.dimen.year_month_list_text_size));
        holder.getTextView().setTypeface(isSelected ? this.mediumFont : this.normalFont);
    }

    @Nullable
    public final Integer getSelectedPosition() {
        Integer n = this.selectedYear;
        return n != null ? Integer.valueOf(this.asPosition(n)) : null;
    }

    public final void onRowClicked$com_afollestad_date_picker(int position) {
        Integer n = this.asYear(position);
        YearAdapter yearAdapter = this;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        this.onSelection.invoke((Object)it);
        Integer n2 = n;
        yearAdapter.setSelectedYear(n2);
    }

    private final int asPosition(int $this$asPosition) {
        int base = ((Number)this.yearRange.getFirst()).intValue();
        return $this$asPosition - base - 1;
    }

    private final int asYear(int $this$asYear) {
        int base = ((Number)this.yearRange.getFirst()).intValue();
        return $this$asYear + 1 + base;
    }

    public YearAdapter(@NotNull Typeface normalFont2, @NotNull Typeface mediumFont2, @ColorInt int selectionColor2, @NotNull Function1<? super Integer, Unit> onSelection) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)normalFont2, (String)"normalFont");
        Intrinsics.checkParameterIsNotNull((Object)mediumFont2, (String)"mediumFont");
        Intrinsics.checkParameterIsNotNull(onSelection, (String)"onSelection");
        this.normalFont = normalFont2;
        this.mediumFont = mediumFont2;
        this.selectionColor = selectionColor2;
        this.onSelection = onSelection;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        int n = CalendarsKt.getYear(calendar);
        YearAdapter yearAdapter = this;
        boolean bl = false;
        boolean bl2 = false;
        int $this$with = n;
        boolean bl3 = false;
        yearAdapter.yearRange = pair = new Pair((Object)($this$with - 100), (Object)($this$with + 100));
        this.setHasStableIds(true);
    }
}

