/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date.adapters;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;
import com.afollestad.date.CalendarsKt;
import com.afollestad.date.R;
import com.afollestad.date.adapters.MonthViewHolder;
import com.afollestad.date.data.DateFormatter;
import com.afollestad.date.util.Util;
import com.afollestad.date.util.ViewsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BJ\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0016J\u0015\u0010%\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b&J\f\u0010'\u001a\u00020(*\u00020\u0004H\u0002R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/afollestad/date/adapters/MonthAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/afollestad/date/adapters/MonthViewHolder;", "selectionColor", "", "normalFont", "Landroid/graphics/Typeface;", "mediumFont", "dateFormatter", "Lcom/afollestad/date/data/DateFormatter;", "onSelection", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "month", "", "(ILandroid/graphics/Typeface;Landroid/graphics/Typeface;Lcom/afollestad/date/data/DateFormatter;Lkotlin/jvm/functions/Function1;)V", "calendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "value", "selectedMonth", "getSelectedMonth", "()Ljava/lang/Integer;", "setSelectedMonth", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getItemCount", "getItemId", "", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onRowClicked", "onRowClicked$com_afollestad_date_picker", "nameOfMonth", "", "com.afollestad.date-picker"})
public final class MonthAdapter
extends RecyclerView.Adapter<MonthViewHolder> {
    @Nullable
    private Integer selectedMonth;
    private final Calendar calendar;
    private final int selectionColor;
    private final Typeface normalFont;
    private final Typeface mediumFont;
    private final DateFormatter dateFormatter;
    private final Function1<Integer, Unit> onSelection;

    @Nullable
    public final Integer getSelectedMonth() {
        return this.selectedMonth;
    }

    public final void setSelectedMonth(@Nullable Integer value) {
        Integer lastSelectedMonth = this.selectedMonth;
        this.selectedMonth = value;
        if (lastSelectedMonth != null) {
            this.notifyItemChanged(lastSelectedMonth);
        }
        if (value != null) {
            this.notifyItemChanged(value);
        }
    }

    public long getItemId(int position) {
        return position;
    }

    @NotNull
    public MonthViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Context context = parent.getContext();
        View view = ViewsKt.inflate(parent, R.layout.year_list_row);
        MonthViewHolder monthViewHolder = new MonthViewHolder(view, this);
        boolean bl = false;
        boolean bl2 = false;
        MonthViewHolder $this$apply = monthViewHolder;
        boolean bl3 = false;
        TextView textView = $this$apply.getTextView();
        Context context2 = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        textView.setTextColor(Util.INSTANCE.createTextSelector(context2, this.selectionColor, false));
        return monthViewHolder;
    }

    public int getItemCount() {
        return this.calendar.getActualMaximum(2) + 1;
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Integer n = this.selectedMonth;
        boolean isSelected = n != null && position == n;
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"holder.itemView.context");
        Resources res = context.getResources();
        holder.getTextView().setText((CharSequence)this.nameOfMonth(position));
        holder.getTextView().setSelected(isSelected);
        holder.getTextView().setTextSize(0, res.getDimension(isSelected ? R.dimen.year_month_list_text_size_selected : R.dimen.year_month_list_text_size));
        holder.getTextView().setTypeface(isSelected ? this.mediumFont : this.normalFont);
    }

    public final void onRowClicked$com_afollestad_date_picker(int position) {
        Integer n = position;
        MonthAdapter monthAdapter = this;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        this.onSelection.invoke((Object)it);
        Integer n2 = n;
        monthAdapter.setSelectedMonth(n2);
    }

    private final String nameOfMonth(int $this$nameOfMonth) {
        Calendar calendar = this.calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"calendar");
        CalendarsKt.setMonth(calendar, $this$nameOfMonth);
        Calendar calendar2 = this.calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        return this.dateFormatter.month(calendar2);
    }

    public MonthAdapter(@ColorInt int selectionColor2, @NotNull Typeface normalFont2, @NotNull Typeface mediumFont2, @NotNull DateFormatter dateFormatter, @NotNull Function1<? super Integer, Unit> onSelection) {
        Intrinsics.checkParameterIsNotNull((Object)normalFont2, (String)"normalFont");
        Intrinsics.checkParameterIsNotNull((Object)mediumFont2, (String)"mediumFont");
        Intrinsics.checkParameterIsNotNull((Object)dateFormatter, (String)"dateFormatter");
        Intrinsics.checkParameterIsNotNull(onSelection, (String)"onSelection");
        this.selectionColor = selectionColor2;
        this.normalFont = normalFont2;
        this.mediumFont = mediumFont2;
        this.dateFormatter = dateFormatter;
        this.onSelection = onSelection;
        this.calendar = Calendar.getInstance();
        this.setHasStableIds(true);
    }
}

