/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.date;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.CheckResult;
import androidx.annotation.IntRange;
import com.afollestad.date.R;
import com.afollestad.date.adapters.MonthAdapter;
import com.afollestad.date.adapters.MonthItemAdapter;
import com.afollestad.date.adapters.YearAdapter;
import com.afollestad.date.controllers.DatePickerController;
import com.afollestad.date.controllers.MinMaxController;
import com.afollestad.date.controllers.VibratorController;
import com.afollestad.date.data.DateFormatter;
import com.afollestad.date.data.MonthItem;
import com.afollestad.date.managers.DatePickerLayoutManager;
import com.afollestad.date.renderers.MonthItemRenderer;
import com.afollestad.date.util.AttrsKt;
import com.afollestad.date.view.DatePickerSavedState;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 H2\u00020\u0001:\u0001HB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\u0019\u001a\u00020\u001a2:\u0010\u001b\u001a6\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`\"J\u0006\u0010#\u001a\u00020\u001aJ\n\u0010$\u001a\u0004\u0018\u00010\u001dH\u0007J\b\u0010%\u001a\u0004\u0018\u00010\u001dJ\b\u0010&\u001a\u0004\u0018\u00010\u001dJ\b\u0010'\u001a\u00020\u001aH\u0014J+\u0010(\u001a\u00020\u001a2!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u001a0)H\u0007J\b\u0010*\u001a\u00020\u001aH\u0014J0\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/H\u0014J\u0018\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020/H\u0014J\u0012\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u000108H\u0014J\n\u00109\u001a\u0004\u0018\u000108H\u0014J\u0016\u0010:\u001a\u00020\u001a2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0002J\u0018\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\u001d2\b\b\u0002\u0010@\u001a\u00020-J7\u0010>\u001a\u00020\u001a2\n\b\u0003\u0010A\u001a\u0004\u0018\u00010/2\b\b\u0001\u0010B\u001a\u00020/2\n\b\u0003\u0010C\u001a\u0004\u0018\u00010/2\b\b\u0002\u0010@\u001a\u00020-\u00a2\u0006\u0002\u0010DJ\u000e\u0010E\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\u001dJ$\u0010E\u001a\u00020\u001a2\b\b\u0001\u0010A\u001a\u00020/2\b\b\u0001\u0010B\u001a\u00020/2\b\b\u0001\u0010F\u001a\u00020/J\u000e\u0010G\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\u001dJ$\u0010G\u001a\u00020\u001a2\b\b\u0001\u0010A\u001a\u00020/2\b\b\u0001\u0010B\u001a\u00020/2\b\b\u0001\u0010F\u001a\u00020/R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/afollestad/date/DatePicker;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "controller", "Lcom/afollestad/date/controllers/DatePickerController;", "getController$com_afollestad_date_picker", "()Lcom/afollestad/date/controllers/DatePickerController;", "layoutManager", "Lcom/afollestad/date/managers/DatePickerLayoutManager;", "minMaxController", "Lcom/afollestad/date/controllers/MinMaxController;", "getMinMaxController$com_afollestad_date_picker", "()Lcom/afollestad/date/controllers/MinMaxController;", "monthAdapter", "Lcom/afollestad/date/adapters/MonthAdapter;", "monthItemAdapter", "Lcom/afollestad/date/adapters/MonthItemAdapter;", "monthItemRenderer", "Lcom/afollestad/date/renderers/MonthItemRenderer;", "yearAdapter", "Lcom/afollestad/date/adapters/YearAdapter;", "addOnDateChanged", "", "block", "Lkotlin/Function2;", "Ljava/util/Calendar;", "Lkotlin/ParameterName;", "name", "previous", "date", "Lcom/afollestad/date/OnDateChanged;", "clearOnDateChanged", "getDate", "getMaxDate", "getMinDate", "onAttachedToWindow", "onDateChanged", "Lkotlin/Function1;", "onFinishInflate", "onLayout", "changed", "", "left", "", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "renderMonthItems", "days", "", "Lcom/afollestad/date/data/MonthItem;", "setDate", "calendar", "notifyListeners", "year", "month", "selectedDate", "(Ljava/lang/Integer;ILjava/lang/Integer;Z)V", "setMaxDate", "dayOfMonth", "setMinDate", "Companion", "com.afollestad.date-picker"})
public final class DatePicker
extends ViewGroup {
    @NotNull
    private final DatePickerController controller;
    @NotNull
    private final MinMaxController minMaxController;
    private final DatePickerLayoutManager layoutManager;
    private final MonthItemAdapter monthItemAdapter;
    private final YearAdapter yearAdapter;
    private final MonthAdapter monthAdapter;
    private final MonthItemRenderer monthItemRenderer;
    public static final long MONTH_MIN = 0L;
    public static final long MONTH_MAX = 11L;
    @java.lang.Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DatePickerController getController$com_afollestad_date_picker() {
        return this.controller;
    }

    @NotNull
    public final MinMaxController getMinMaxController$com_afollestad_date_picker() {
        return this.minMaxController;
    }

    public final void setDate(@NotNull Calendar calendar, boolean notifyListeners) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        this.controller.setFullDate(calendar, notifyListeners);
    }

    public static /* synthetic */ void setDate$default(DatePicker datePicker, Calendar calendar, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        datePicker.setDate(calendar, bl);
    }

    public final void setDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) @Nullable Integer year, @IntRange(from=0L, to=11L) int month, @IntRange(from=1L, to=31L) @Nullable Integer selectedDate, boolean notifyListeners) {
        this.controller.setFullDate(year, month, selectedDate, notifyListeners);
    }

    public static /* synthetic */ void setDate$default(DatePicker datePicker, Integer n, int n2, Integer n3, boolean bl, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        if ((n4 & 8) != 0) {
            bl = true;
        }
        datePicker.setDate(n, n2, n3, bl);
    }

    @CheckResult
    @Nullable
    public final Calendar getDate() {
        return this.controller.getFullDate();
    }

    @Nullable
    public final Calendar getMinDate() {
        return this.minMaxController.getMinDate();
    }

    public final void setMinDate(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        this.minMaxController.setMinDate(calendar);
    }

    public final void setMinDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) int year, @IntRange(from=0L, to=11L) int month, @IntRange(from=1L, to=31L) int dayOfMonth) {
        this.minMaxController.setMinDate(year, month, dayOfMonth);
    }

    @Nullable
    public final Calendar getMaxDate() {
        return this.minMaxController.getMaxDate();
    }

    public final void setMaxDate(@NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        this.minMaxController.setMaxDate(calendar);
    }

    public final void setMaxDate(@IntRange(from=1L, to=0x7FFFFFFFFFFFFFFFL) int year, @IntRange(from=0L, to=11L) int month, @IntRange(from=1L, to=31L) int dayOfMonth) {
        this.minMaxController.setMaxDate(year, month, dayOfMonth);
    }

    @Deprecated(message="Use addOnDateChanged instead.", replaceWith=@ReplaceWith(imports={}, expression="addOnDateChanged(block)"))
    public final void onDateChanged(@NotNull Function1<? super Calendar, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        this.controller.addDateChangedListener((Function2<? super Calendar, ? super Calendar, Unit>)((Function2)new Function2<Calendar, Calendar, Unit>(block){
            final /* synthetic */ Function1 $block;

            public final void invoke(@NotNull Calendar $noName_0, @NotNull Calendar newDate) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)newDate, (String)"newDate");
                this.$block.invoke((Object)newDate);
            }
            {
                this.$block = function1;
                super(2);
            }
        }));
    }

    public final void addOnDateChanged(@NotNull Function2<? super Calendar, ? super Calendar, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        this.controller.addDateChangedListener(block);
    }

    public final void clearOnDateChanged() {
        this.controller.clearDateChangedListeners();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.controller.maybeInit();
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        return (Parcelable)new DatePickerSavedState(this.getDate(), super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof DatePickerSavedState) {
            super.onRestoreInstanceState(((DatePickerSavedState)state).getSuperState());
            Calendar calendar = ((DatePickerSavedState)state).getSelectedDate();
            if (calendar != null) {
                Calendar calendar2 = calendar;
                boolean bl = false;
                boolean bl2 = false;
                Calendar it = calendar2;
                boolean bl3 = false;
                this.controller.setFullDate(it, false);
            }
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.layoutManager.onNavigate((Function0<Unit>)((Function0)new Function0<Unit>(this.controller){

            public final void invoke() {
                ((DatePickerController)this.receiver).previousMonth();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(DatePickerController.class);
            }

            public final String getName() {
                return "previousMonth";
            }

            public final String getSignature() {
                return "previousMonth()V";
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this.controller){

            public final void invoke() {
                ((DatePickerController)this.receiver).nextMonth();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(DatePickerController.class);
            }

            public final String getName() {
                return "nextMonth";
            }

            public final String getSignature() {
                return "nextMonth()V";
            }
        }));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        DatePickerLayoutManager.Size size = this.layoutManager.onMeasure(widthMeasureSpec, heightMeasureSpec);
        boolean bl = false;
        boolean bl2 = false;
        DatePickerLayoutManager.Size $dstr$width$height = size;
        boolean bl3 = false;
        int width = $dstr$width$height.component1();
        int height = $dstr$width$height.component2();
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutManager.onLayout(left, top, right);
    }

    private final void renderMonthItems(List<? extends MonthItem> days) {
        Integer n;
        Object element$iv2;
        block4: {
            Iterable $this$first$iv = days;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MonthItem it = (MonthItem)element$iv2;
                boolean bl = false;
                if (!(it instanceof MonthItem.DayOfMonth)) continue;
                break block4;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.afollestad.date.data.MonthItem.DayOfMonth");
        }
        MonthItem.DayOfMonth firstDayOfMonth = (MonthItem.DayOfMonth)t;
        this.yearAdapter.setSelectedYear(firstDayOfMonth.getMonth().getYear());
        Integer n2 = this.yearAdapter.getSelectedPosition();
        if (n2 != null) {
            n = n2;
            DatePickerLayoutManager datePickerLayoutManager = this.layoutManager;
            boolean bl = false;
            boolean bl2 = false;
            int p1 = ((Number)n).intValue();
            boolean bl3 = false;
            datePickerLayoutManager.scrollToYearPosition(p1);
        }
        this.monthAdapter.setSelectedMonth(firstDayOfMonth.getMonth().getMonth());
        Integer n3 = this.monthAdapter.getSelectedMonth();
        if (n3 != null) {
            n = n3;
            DatePickerLayoutManager datePickerLayoutManager = this.layoutManager;
            boolean bl = false;
            boolean bl4 = false;
            int p1 = ((Number)n).intValue();
            boolean bl5 = false;
            datePickerLayoutManager.scrollToMonthPosition(p1);
        }
        this.monthItemAdapter.setItems(days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatePicker(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.minMaxController = new MinMaxController();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.DatePicker);
        Typeface normalFont2 = null;
        Typeface mediumFont2 = null;
        try {
            TypedArray typedArray = ta;
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"ta");
            this.layoutManager = DatePickerLayoutManager.Companion.inflateInto(context, typedArray, this);
            this.controller = new DatePickerController(new VibratorController(context, ta), this.minMaxController, (Function2)new Function2<Calendar, Calendar, Unit>(this.layoutManager){

                public final void invoke(@NotNull Calendar p1, @NotNull Calendar p2) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                    ((DatePickerLayoutManager)this.receiver).setHeadersContent(p1, p2);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(DatePickerLayoutManager.class);
                }

                public final String getName() {
                    return "setHeadersContent";
                }

                public final String getSignature() {
                    return "setHeadersContent(Ljava/util/Calendar;Ljava/util/Calendar;)V";
                }
            }, (Function1)new Function1<List<? extends MonthItem>, Unit>(this){

                public final void invoke(@NotNull List<? extends MonthItem> p1) {
                    Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                    ((DatePicker)((Object)this.receiver)).renderMonthItems(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(DatePicker.class);
                }

                public final String getName() {
                    return "renderMonthItems";
                }

                public final String getSignature() {
                    return "renderMonthItems(Ljava/util/List;)V";
                }
            }, (Function1)new Function1<Boolean, Unit>(this.layoutManager){

                public final void invoke(boolean p1) {
                    ((DatePickerLayoutManager)this.receiver).showOrHideGoPrevious(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(DatePickerLayoutManager.class);
                }

                public final String getName() {
                    return "showOrHideGoPrevious";
                }

                public final String getSignature() {
                    return "showOrHideGoPrevious(Z)V";
                }
            }, (Function1)new Function1<Boolean, Unit>(this.layoutManager){

                public final void invoke(boolean p1) {
                    ((DatePickerLayoutManager)this.receiver).showOrHideGoNext(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(DatePickerLayoutManager.class);
                }

                public final String getName() {
                    return "showOrHideGoNext";
                }

                public final String getSignature() {
                    return "showOrHideGoNext(Z)V";
                }
            }, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    layoutManager.setMode(DatePickerLayoutManager.Mode.CALENDAR);
                }
            }, null, 128, null);
            mediumFont2 = AttrsKt.font(ta, context, R.styleable.DatePicker_date_picker_medium_font, (Function0<? extends Typeface>)((Function0)6.INSTANCE));
            normalFont2 = AttrsKt.font(ta, context, R.styleable.DatePicker_date_picker_normal_font, (Function0<? extends Typeface>)((Function0)7.INSTANCE));
            this.monthItemRenderer = new MonthItemRenderer(context, ta, normalFont2, this.minMaxController);
        }
        finally {
            ta.recycle();
        }
        this.monthItemAdapter = new MonthItemAdapter(this.monthItemRenderer, (Function1<? super MonthItem.DayOfMonth, Unit>)((Function1)new Function1<MonthItem.DayOfMonth, Unit>(){

            public final void invoke(@NotNull MonthItem.DayOfMonth it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getController$com_afollestad_date_picker().setDayOfMonth(it.getDate());
            }
        }));
        this.yearAdapter = new YearAdapter(normalFont2, mediumFont2, this.layoutManager.getSelectionColor(), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(){

            public final void invoke(int it) {
                this.getController$com_afollestad_date_picker().setYear(it);
            }
        }));
        Function1 function1 = (Function1)new Function1<Integer, Unit>(){

            public final void invoke(int it) {
                this.getController$com_afollestad_date_picker().setMonth(it);
            }
        };
        DateFormatter dateFormatter = new DateFormatter();
        int n = this.layoutManager.getSelectionColor();
        Typeface typeface = mediumFont2;
        Typeface typeface2 = normalFont2;
        this.monthAdapter = new MonthAdapter(n, typeface2, typeface, dateFormatter, (Function1<? super Integer, Unit>)function1);
        this.layoutManager.setAdapters(this.monthItemAdapter, this.yearAdapter, this.monthAdapter);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/afollestad/date/DatePicker$Companion;", "", "()V", "MONTH_MAX", "", "MONTH_MIN", "com.afollestad.date-picker"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

