/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.assent.rationale;

import android.app.Activity;
import androidx.annotation.CheckResult;
import androidx.annotation.StringRes;
import androidx.lifecycle.Lifecycle;
import com.afollestad.assent.AssentResult;
import com.afollestad.assent.AssentResultKt;
import com.afollestad.assent.Permission;
import com.afollestad.assent.internal.LifecycleKt;
import com.afollestad.assent.rationale.ConfirmCallback;
import com.afollestad.assent.rationale.RationaleHandler;
import com.afollestad.assent.rationale.RealShouldShowRationale;
import com.afollestad.assent.rationale.ShouldShowRationale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001Bl\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012Q\u0010\u0004\u001aM\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f\u0012\u0004\u0012\u00020\u000e0\u0005j\u0002`\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u00100\u001a\u00020\u000eH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0007H\u0002J\b\u00103\u001a\u00020\u000eH&J\u0016\u00104\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u001eJ\u0018\u00104\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u00072\b\b\u0001\u00105\u001a\u00020\bJJ\u00106\u001a\u00020\u000e2\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010(\u001a\u00020\b2%\u00108\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020\u000eH\u0002J \u0010.\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020<H&J\u0015\u0010=\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0001H\u0001\u00a2\u0006\u0002\b>Ri\u0010\u0015\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f2%\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R7\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070!2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070!8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u001b\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R+\u0010(\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\u001b\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,RY\u0010\u0004\u001aM\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000f\u0012\u0004\u0012\u00020\u000e0\u0005j\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/afollestad/assent/rationale/RationaleHandler;", "", "context", "Landroid/app/Activity;", "requester", "Lkotlin/Function4;", "", "Lcom/afollestad/assent/Permission;", "", "Lkotlin/Function1;", "Lcom/afollestad/assent/AssentResult;", "Lkotlin/ParameterName;", "name", "result", "", "Lcom/afollestad/assent/Callback;", "Lcom/afollestad/assent/rationale/Requester;", "shouldShowRationale", "Lcom/afollestad/assent/rationale/ShouldShowRationale;", "(Landroid/app/Activity;Lkotlin/jvm/functions/Function4;Lcom/afollestad/assent/rationale/ShouldShowRationale;)V", "<set-?>", "callback", "getCallback", "()Lkotlin/jvm/functions/Function1;", "setCallback", "(Lkotlin/jvm/functions/Function1;)V", "callback$delegate", "Lkotlin/properties/ReadWriteProperty;", "messages", "", "", "owner", "rationalePermissionsResult", "", "remainingRationalePermissions", "getRemainingRationalePermissions", "()Ljava/util/Set;", "setRemainingRationalePermissions", "(Ljava/util/Set;)V", "remainingRationalePermissions$delegate", "requestCode", "getRequestCode", "()I", "setRequestCode", "(I)V", "requestCode$delegate", "showRationale", "simplePermissionsResult", "finish", "getMessageFor", "permission", "onDestroy", "onPermission", "message", "requestPermissions", "permissions", "finalCallback", "([Lcom/afollestad/assent/Permission;ILkotlin/jvm/functions/Function1;)V", "requestRationalePermissions", "confirm", "Lcom/afollestad/assent/rationale/ConfirmCallback;", "withOwner", "withOwner$com_afollestad_assent", "com.afollestad.assent"})
public abstract class RationaleHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Map<Permission, CharSequence> messages;
    private final ReadWriteProperty requestCode$delegate;
    private final ReadWriteProperty callback$delegate;
    private final ReadWriteProperty remainingRationalePermissions$delegate;
    private ShouldShowRationale showRationale;
    private AssentResult simplePermissionsResult;
    private AssentResult rationalePermissionsResult;
    private Object owner;
    private final Activity context;
    private final Function4<Permission[], Integer, RationaleHandler, Function1<? super AssentResult, Unit>, Unit> requester;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RationaleHandler.class), "requestCode", "getRequestCode()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RationaleHandler.class), "callback", "getCallback()Lkotlin/jvm/functions/Function1;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RationaleHandler.class), "remainingRationalePermissions", "getRemainingRationalePermissions()Ljava/util/Set;"))};
    }

    private final int getRequestCode() {
        return ((Number)this.requestCode$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setRequestCode(int n) {
        this.requestCode$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    private final Function1<AssentResult, Unit> getCallback() {
        return (Function1)this.callback$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setCallback(Function1<? super AssentResult, Unit> function1) {
        this.callback$delegate.setValue((Object)this, $$delegatedProperties[1], function1);
    }

    private final Set<Permission> getRemainingRationalePermissions() {
        return (Set)this.remainingRationalePermissions$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setRemainingRationalePermissions(Set<Permission> set) {
        this.remainingRationalePermissions$delegate.setValue((Object)this, $$delegatedProperties[2], set);
    }

    @CheckResult
    @NotNull
    public final RationaleHandler withOwner$com_afollestad_assent(@NotNull Object owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.owner = owner;
        return this;
    }

    public final void onPermission(@NotNull Permission permission, @StringRes int message) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)permission), (String)"permission");
        CharSequence charSequence = this.context.getText(message);
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"context.getText(message)");
        this.onPermission(permission, charSequence);
    }

    public final void onPermission(@NotNull Permission permission, @NotNull CharSequence message) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)permission), (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.messages.put(permission, message);
    }

    /*
     * WARNING - void declaration
     */
    public final void requestPermissions(@NotNull Permission[] permissions, int requestCode, @NotNull Function1<? super AssentResult, Unit> finalCallback) {
        void $this$toTypedArray$iv;
        void $this$filterNotTo$iv$iv;
        int n;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull(finalCallback, (String)"finalCallback");
        this.setRequestCode(requestCode);
        this.setCallback(finalCallback);
        Permission[] permissionArray = permissions;
        Function4<Permission[], Integer, RationaleHandler, Function1<? super AssentResult, Unit>, Unit> function4 = this;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Permission[] destination$iv$iv = (Permission[])new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_13 = $this$filterTo$iv$iv;
        int n2 = ((void)var9_13).length;
        for (n = 0; n < n2; ++n) {
            void element$iv$iv;
            void it = element$iv$iv = var9_13[n];
            boolean bl = false;
            if (!this.showRationale.check((Permission)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Permission[] permissionArray2 = destination$iv$iv;
        function4.setRemainingRationalePermissions((Set<Permission>)CollectionsKt.toMutableSet((Iterable)((Iterable)permissionArray2)));
        Object $this$filterNot$iv = permissions;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        void var10_16 = $this$filterNotTo$iv$iv;
        n = ((void)var10_16).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var10_16[i];
            boolean bl = false;
            if (this.showRationale.check((Permission)it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List simplePermissions = (List)destination$iv$iv2;
        Timber.d((String)"Found %d permissions that DO require a rationale: %s", (Object[])new Object[]{this.getRemainingRationalePermissions().size(), CollectionsKt.joinToString$default((Iterable)this.getRemainingRationalePermissions(), null, null, null, (int)0, null, null, (int)63, null)});
        if (simplePermissions.isEmpty()) {
            Timber.d((String)"No simple permissions to request", (Object[])new Object[0]);
            this.requestRationalePermissions();
            return;
        }
        $this$filterNot$iv = simplePermissions;
        function4 = this.requester;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Permission[] permissionArray3 = thisCollection$iv.toArray(new Permission[0]);
        if (permissionArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        permissionArray2 = permissionArray3;
        function4.invoke((Object)permissionArray2, (Object)requestCode, null, (Object)new Function1<AssentResult, Unit>(this){
            final /* synthetic */ RationaleHandler this$0;

            public final void invoke(@NotNull AssentResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RationaleHandler.access$setSimplePermissionsResult$p(this.this$0, it);
                RationaleHandler.access$requestRationalePermissions(this.this$0);
            }
            {
                this.this$0 = rationaleHandler;
                super(1);
            }
        });
    }

    public abstract void showRationale(@NotNull Permission var1, @NotNull CharSequence var2, @NotNull ConfirmCallback var3);

    public abstract void onDestroy();

    private final void requestRationalePermissions() {
        Permission permission = (Permission)((Object)CollectionsKt.firstOrNull((Iterable)this.getRemainingRationalePermissions()));
        if (permission == null) {
            this.finish();
            return;
        }
        Permission nextInQueue = permission;
        Timber.d((String)"Showing rationale for permission %s", (Object[])new Object[]{nextInQueue});
        LifecycleKt.maybeObserveLifecycle(this.owner, new Lifecycle.Event[]{Lifecycle.Event.ON_DESTROY}, (Function1<? super Lifecycle.Event, Unit>)((Function1)new Function1<Lifecycle.Event, Unit>(this){
            final /* synthetic */ RationaleHandler this$0;

            public final void invoke(@NotNull Lifecycle.Event it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.onDestroy();
            }
            {
                this.this$0 = rationaleHandler;
                super(1);
            }
        }));
        this.showRationale(nextInQueue, this.getMessageFor(nextInQueue), new ConfirmCallback((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, nextInQueue){
            final /* synthetic */ RationaleHandler this$0;
            final /* synthetic */ Permission $nextInQueue;

            public final void invoke(boolean confirmed) {
                if (confirmed) {
                    Timber.d((String)"Got rationale confirm signal for permission %s", (Object[])new Object[]{this.$nextInQueue});
                    RationaleHandler.access$getRequester$p(this.this$0).invoke((Object)new Permission[]{this.$nextInQueue}, (Object)RationaleHandler.access$getRequestCode$p(this.this$0), null, (Object)new Function1<AssentResult, Unit>(this){
                        final /* synthetic */ requestRationalePermissions.2 this$0;

                        public final void invoke(@NotNull AssentResult it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            RationaleHandler rationaleHandler = this.this$0.this$0;
                            RationaleHandler.access$setRationalePermissionsResult$p(rationaleHandler, AssentResultKt.plus(RationaleHandler.access$getRationalePermissionsResult$p(rationaleHandler), it));
                            RationaleHandler.access$getRemainingRationalePermissions$p(this.this$0.this$0).remove((Object)((Object)this.this$0.$nextInQueue));
                            RationaleHandler.access$requestRationalePermissions(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                } else {
                    Timber.d((String)"Got rationale deny signal for permission %s", (Object[])new Object[]{this.$nextInQueue});
                    RationaleHandler rationaleHandler = this.this$0;
                    RationaleHandler.access$setRationalePermissionsResult$p(rationaleHandler, AssentResultKt.plus(RationaleHandler.access$getRationalePermissionsResult$p(rationaleHandler), new AssentResult(CollectionsKt.listOf((Object)((Object)this.$nextInQueue)), new int[]{-1})));
                    RationaleHandler.access$getRemainingRationalePermissions$p(this.this$0).remove((Object)((Object)this.$nextInQueue));
                    RationaleHandler.access$requestRationalePermissions(this.this$0);
                }
            }
            {
                this.this$0 = rationaleHandler;
                this.$nextInQueue = permission;
                super(1);
            }
        })));
    }

    private final void finish() {
        Timber.d((String)"finish()", (Object[])new Object[0]);
        AssentResult simpleResult = this.simplePermissionsResult;
        AssentResult rationaleResult = this.rationalePermissionsResult;
        if (simpleResult != null && rationaleResult != null) {
            this.getCallback().invoke((Object)AssentResultKt.plus(simpleResult, rationaleResult));
        } else if (simpleResult != null) {
            this.getCallback().invoke((Object)simpleResult);
        } else if (rationaleResult != null) {
            this.getCallback().invoke((Object)rationaleResult);
        }
    }

    private final CharSequence getMessageFor(Permission permission) {
        CharSequence charSequence = this.messages.get((Object)permission);
        if (charSequence == null) {
            throw (Throwable)new IllegalStateException("No message provided for " + (Object)((Object)permission));
        }
        return charSequence;
    }

    public RationaleHandler(@NotNull Activity context, @NotNull Function4<? super Permission[], ? super Integer, ? super RationaleHandler, ? super Function1<? super AssentResult, Unit>, Unit> requester, @Nullable ShouldShowRationale shouldShowRationale) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(requester, (String)"requester");
        this.context = context;
        this.requester = requester;
        RationaleHandler rationaleHandler = this;
        boolean bl = false;
        rationaleHandler.messages = map = (Map)new LinkedHashMap();
        this.requestCode$delegate = Delegates.INSTANCE.notNull();
        this.callback$delegate = Delegates.INSTANCE.notNull();
        this.remainingRationalePermissions$delegate = Delegates.INSTANCE.notNull();
        ShouldShowRationale shouldShowRationale2 = shouldShowRationale;
        if (shouldShowRationale2 == null) {
            shouldShowRationale2 = new RealShouldShowRationale(this.context);
        }
        this.showRationale = shouldShowRationale2;
        this.owner = this.context;
    }

    public /* synthetic */ RationaleHandler(Activity activity, Function4 function4, ShouldShowRationale shouldShowRationale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            shouldShowRationale = null;
        }
        this(activity, (Function4<? super Permission[], ? super Integer, ? super RationaleHandler, ? super Function1<? super AssentResult, Unit>, Unit>)function4, shouldShowRationale);
    }

    public static final /* synthetic */ AssentResult access$getSimplePermissionsResult$p(RationaleHandler $this) {
        return $this.simplePermissionsResult;
    }

    public static final /* synthetic */ void access$setSimplePermissionsResult$p(RationaleHandler $this, AssentResult assentResult) {
        $this.simplePermissionsResult = assentResult;
    }

    public static final /* synthetic */ void access$requestRationalePermissions(RationaleHandler $this) {
        $this.requestRationalePermissions();
    }

    public static final /* synthetic */ Function4 access$getRequester$p(RationaleHandler $this) {
        return $this.requester;
    }

    public static final /* synthetic */ int access$getRequestCode$p(RationaleHandler $this) {
        return $this.getRequestCode();
    }

    public static final /* synthetic */ void access$setRequestCode$p(RationaleHandler $this, int n) {
        $this.setRequestCode(n);
    }

    public static final /* synthetic */ AssentResult access$getRationalePermissionsResult$p(RationaleHandler $this) {
        return $this.rationalePermissionsResult;
    }

    public static final /* synthetic */ void access$setRationalePermissionsResult$p(RationaleHandler $this, AssentResult assentResult) {
        $this.rationalePermissionsResult = assentResult;
    }

    public static final /* synthetic */ Set access$getRemainingRationalePermissions$p(RationaleHandler $this) {
        return $this.getRemainingRationalePermissions();
    }

    public static final /* synthetic */ void access$setRemainingRationalePermissions$p(RationaleHandler $this, Set set) {
        $this.setRemainingRationalePermissions(set);
    }
}

