/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.assent;

import androidx.annotation.CheckResult;
import com.afollestad.assent.Permission;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J#\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0017\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0017\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/afollestad/assent/AssentResult;", "", "permissions", "", "Lcom/afollestad/assent/Permission;", "grantResults", "", "(Ljava/util/List;[I)V", "getGrantResults", "()[I", "getPermissions", "()Ljava/util/List;", "component1", "component2", "containsPermissions", "", "permission", "copy", "equals", "other", "hashCode", "", "isAllDenied", "", "([Lcom/afollestad/assent/Permission;)Z", "isAllGranted", "toString", "", "com.afollestad.assent"})
public final class AssentResult {
    @NotNull
    private final List<Permission> permissions;
    @NotNull
    private final int[] grantResults;

    @CheckResult
    public final boolean containsPermissions(@NotNull Permission permission) {
        int n;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)permission), (String)"permission");
            List<Permission> $this$containsPermission$iv = this.permissions;
            boolean $i$f$containsPermission = false;
            List<Permission> $this$indexOfFirst$iv$iv = $this$containsPermission$iv;
            boolean $i$f$indexOfFirst = false;
            int index$iv$iv = 0;
            Iterator<Permission> iterator = $this$indexOfFirst$iv$iv.iterator();
            while (iterator.hasNext()) {
                Permission item$iv$iv;
                Permission it$iv = item$iv$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it$iv.getValue(), (Object)permission.getValue())) {
                    n = index$iv$iv;
                    break block2;
                }
                ++index$iv$iv;
            }
            n = -1;
        }
        return n > -1;
    }

    @CheckResult
    public final boolean isAllGranted(@NotNull List<? extends Permission> permissions) {
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        for (Permission permission : permissions) {
            int n;
            block4: {
                List<Permission> $this$indexOfFirst$iv = this.permissions;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Permission> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Permission item$iv;
                    Permission it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getValue(), (Object)permission.getValue())) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            boolean $this$indexOfFirst$iv = index != -1;
            boolean bl = false;
            boolean bl2 = false;
            if (!$this$indexOfFirst$iv) {
                boolean bl3 = false;
                String string = "Permission " + permission.name() + " doesn't exist in this result set.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean granted = this.grantResults[index] == 0;
            if (granted) continue;
            return false;
        }
        return true;
    }

    @CheckResult
    public final boolean isAllGranted(Permission ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Permission[] permissionArray = permissions;
        boolean bl = false;
        if (permissionArray.length != 0) {
            // empty if block
        }
        return this.isAllGranted(ArraysKt.toList((Object[])permissions));
    }

    @CheckResult
    public final boolean isAllDenied(Permission ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        for (Permission perm : permissions) {
            boolean granted;
            int n;
            block4: {
                List<Permission> $this$indexOfFirst$iv = this.permissions;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Permission> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Permission item$iv;
                    Permission it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getValue(), (Object)perm.getValue())) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            boolean $this$indexOfFirst$iv = index != -1;
            boolean bl = false;
            boolean bl2 = false;
            if (!$this$indexOfFirst$iv) {
                boolean bl3 = false;
                String string = "Permission " + perm.name() + " doesn't exist in this result set.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean bl4 = granted = this.grantResults[index] == -1;
            if (granted) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.afollestad.assent.AssentResult");
        }
        AssentResult cfr_ignored_0 = (AssentResult)object2;
        if (Intrinsics.areEqual(this.permissions, ((AssentResult)other).permissions) ^ true) {
            return false;
        }
        int[] nArray = this.grantResults;
        int[] nArray2 = ((AssentResult)other).grantResults;
        boolean bl = false;
        return Arrays.equals(nArray, nArray2);
    }

    public int hashCode() {
        int result = ((Object)this.permissions).hashCode();
        int[] nArray = this.grantResults;
        int n = 31 * result;
        boolean bl = false;
        int n2 = Arrays.hashCode(nArray);
        result = n + n2;
        return result;
    }

    @NotNull
    public final List<Permission> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final int[] getGrantResults() {
        return this.grantResults;
    }

    public AssentResult(@NotNull List<? extends Permission> permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        this.permissions = permissions;
        this.grantResults = grantResults;
        boolean bl = this.permissions.size() == this.grantResults.length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Permissions and grant results sizes should match.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<Permission> component1() {
        return this.permissions;
    }

    @NotNull
    public final int[] component2() {
        return this.grantResults;
    }

    @NotNull
    public final AssentResult copy(@NotNull List<? extends Permission> permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        return new AssentResult(permissions, grantResults);
    }

    public static /* synthetic */ AssentResult copy$default(AssentResult assentResult, List list, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            list = assentResult.permissions;
        }
        if ((n & 2) != 0) {
            nArray = assentResult.grantResults;
        }
        return assentResult.copy(list, nArray);
    }

    @NotNull
    public String toString() {
        return "AssentResult(permissions=" + this.permissions + ", grantResults=" + Arrays.toString(this.grantResults) + ")";
    }
}

