/*
 * Decompiled with CFR 0.152.
 */
package com.aevi.util.json;

import com.aevi.util.json.JsonConverter;
import com.aevi.util.json.Jsonable;

public class JsonOption
implements Jsonable {
    private final Object value;
    private final String type;

    public JsonOption(Object value) {
        this.value = value;
        this.type = value.getClass().getName();
    }

    public JsonOption(Object value, String forcedType) {
        this.value = value;
        this.type = forcedType;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toJson() {
        return JsonConverter.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonOption that = (JsonOption)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.type != null ? this.type.equals(that.type) : that.type == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

