/*
 * Decompiled with CFR 0.152.
 */
package com.aevi.util.json;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.aevi.util.json.JsonOption;
import com.aevi.util.json.JsonPostProcessing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class JsonConverter {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonOption.class, (Object)new ExtrasDeserialiser()).registerTypeAdapter(Bitmap.class, (Object)new BitmapDeserialiser()).registerTypeAdapter(Bitmap.class, (Object)new BitmapSerialiser()).registerTypeAdapterFactory((TypeAdapterFactory)new PostProcessingHandler()).create();
    private static final Gson GSON_WITH_METHODS = new GsonBuilder().registerTypeAdapter(JsonOption.class, (Object)new ExtrasDeserialiser()).registerTypeAdapter(Bitmap.class, (Object)new BitmapDeserialiser()).registerTypeAdapter(Bitmap.class, (Object)new BitmapSerialiser()).registerTypeAdapterFactory((TypeAdapterFactory)new ExposedMethodProcessingHandler()).create();

    public static String serialize(Object object) {
        return GSON.toJson(object);
    }

    public static String serializeWithExposedMethods(Object object) {
        return GSON_WITH_METHODS.toJson(object);
    }

    public static JsonElement serializeToTree(Object object) {
        return GSON.toJsonTree(object);
    }

    public static JsonElement serializeToTreeWithExposedMethods(Object object) {
        return GSON_WITH_METHODS.toJsonTree(object);
    }

    public static <T> T deserialize(String json, Class<T> type) throws JsonParseException {
        return type.cast(GSON.fromJson(json, type));
    }

    private static String writeBitmap(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.WEBP, 70, (OutputStream)stream);
        return Base64.encodeToString((byte[])stream.toByteArray(), (int)0);
    }

    private static Bitmap readBitmap(String in) {
        byte[] pngBytes = Base64.decode((byte[])in.getBytes(), (int)0);
        return BitmapFactory.decodeByteArray((byte[])pngBytes, (int)0, (int)pngBytes.length);
    }

    private static class ExtrasDeserialiser
    implements JsonDeserializer<JsonOption> {
        private ExtrasDeserialiser() {
        }

        public JsonOption deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement entry = obj.get("value");
            String className = obj.get("type").getAsString();
            try {
                Class<?> clazz = Class.forName(className);
                return new JsonOption(context.deserialize(entry, clazz));
            }
            catch (ClassNotFoundException e) {
                return new JsonOption(entry, className);
            }
        }
    }

    private static class BitmapDeserialiser
    implements JsonDeserializer<Bitmap> {
        private BitmapDeserialiser() {
        }

        public Bitmap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return JsonConverter.readBitmap(json.getAsString());
        }
    }

    private static class BitmapSerialiser
    implements JsonSerializer<Bitmap> {
        private BitmapSerialiser() {
        }

        public JsonElement serialize(Bitmap src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(JsonConverter.writeBitmap(src));
        }
    }

    private static class PostProcessingHandler
    implements TypeAdapterFactory {
        private PostProcessingHandler() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T src) throws IOException {
                    delegate.write(out, src);
                }

                public T read(JsonReader in) throws IOException {
                    Object object = delegate.read(in);
                    if (object instanceof JsonPostProcessing) {
                        ((JsonPostProcessing)object).onJsonDeserialisationCompleted();
                    }
                    return object;
                }
            };
        }
    }

    private static class ExposedMethodProcessingHandler
    implements TypeAdapterFactory {
        private ExposedMethodProcessingHandler() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T src) throws IOException {
                    JsonElement element = delegate.toJsonTree(src);
                    if (element.isJsonObject()) {
                        JsonObject object = (JsonObject)element;
                        for (Method m : this.getAnnotatedMembers(src.getClass())) {
                            try {
                                m.setAccessible(true);
                                Object value = m.invoke(src, new Object[0]);
                                object.add(m.getAnnotation(ExposeMethod.class).value(), GSON_WITH_METHODS.toJsonTree(value));
                            }
                            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                                // empty catch block
                            }
                        }
                        GSON_WITH_METHODS.toJson((JsonElement)object, out);
                    } else {
                        delegate.write(out, src);
                    }
                }

                public T read(JsonReader in) throws IOException {
                    return delegate.read(in);
                }

                private Method[] getAnnotatedMembers(Class<?> jsonable) {
                    Method[] methods = jsonable.getMethods();
                    ArrayList<Method> annotated = new ArrayList<Method>();
                    for (Method m : methods) {
                        if (m.getAnnotation(ExposeMethod.class) == null) continue;
                        annotated.add(m);
                    }
                    return annotated.toArray(new Method[annotated.size()]);
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ExposeMethod {
        public String value();
    }
}

