/*
 * Decompiled with CFR 0.152.
 */
package com.st.maven.apt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import ru.r2cloud.apt.IOCallback;
import ru.r2cloud.apt.Transport;
import ru.r2cloud.apt.model.RemoteFile;

public class WagonTransport
implements Transport {
    private final Wagon wagon;
    private final Log log;

    public WagonTransport(Wagon wagon, Log log) {
        this.wagon = wagon;
        this.log = log;
    }

    public void save(String path, File file) throws IOException {
        try {
            this.wagon.put(file, path);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void save(String path, IOCallback callback) throws IOException {
        File tempFile = File.createTempFile("apt", String.valueOf(path.hashCode()));
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tempFile));){
            callback.save((OutputStream)fos);
        }
        this.save(path, tempFile);
        if (!tempFile.delete()) {
            this.log.warn((CharSequence)("unable to delete file: " + tempFile.getAbsolutePath()));
        }
    }

    public void load(String path, IOCallback callback) throws IOException, ru.r2cloud.apt.ResourceDoesNotExistException {
        File tempFile = File.createTempFile("apt", String.valueOf(path.hashCode()));
        try {
            this.wagon.get(path, tempFile);
        }
        catch (TransferFailedException e) {
            throw new IOException(e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new ru.r2cloud.apt.ResourceDoesNotExistException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new IOException(e);
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile));){
            callback.load((InputStream)is);
        }
        if (!tempFile.delete()) {
            this.log.warn((CharSequence)("unable to delete file: " + tempFile.getAbsolutePath()));
        }
    }

    public void saveGzipped(String path, IOCallback callback) throws IOException {
        File tempFile = File.createTempFile("apt", String.valueOf(path.hashCode()));
        try (BufferedOutputStream fos = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(tempFile)));){
            callback.save((OutputStream)fos);
        }
        this.save(path, tempFile);
        if (!tempFile.delete()) {
            this.log.warn((CharSequence)("unable to delete file: " + tempFile.getAbsolutePath()));
        }
    }

    public void loadGzipped(String path, IOCallback callback) throws IOException, ru.r2cloud.apt.ResourceDoesNotExistException {
        File tempFile = File.createTempFile("apt", String.valueOf(path.hashCode()));
        try {
            this.wagon.get(path, tempFile);
        }
        catch (TransferFailedException e) {
            throw new IOException(e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new ru.r2cloud.apt.ResourceDoesNotExistException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new IOException(e);
        }
        try (BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new FileInputStream(tempFile)));){
            callback.load((InputStream)is);
        }
        if (!tempFile.delete()) {
            this.log.warn((CharSequence)("unable to delete file: " + tempFile.getAbsolutePath()));
        }
    }

    public void delete(String path) {
        throw new UnsupportedOperationException();
    }

    public List<RemoteFile> listFiles(String path) {
        throw new UnsupportedOperationException();
    }
}

