/*
 * Decompiled with CFR 0.152.
 */
package com.st.maven.apt;

import com.st.maven.apt.WagonTransport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import ru.r2cloud.apt.AptRepositoryImpl;
import ru.r2cloud.apt.GpgSigner;
import ru.r2cloud.apt.GpgSignerImpl;
import ru.r2cloud.apt.Transport;
import ru.r2cloud.apt.model.DebFile;
import ru.r2cloud.apt.model.SignConfiguration;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=false)
public class AptDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${maven.deploy.skip}", readonly=true)
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private PlexusContainer container;
    @Parameter(defaultValue="${maven.apt.file}", readonly=true)
    private String file;
    @Parameter(defaultValue="${maven.apt.files}", readonly=true)
    private String files;
    @Parameter(readonly=true, required=true)
    private String codename;
    @Parameter(readonly=true, required=true)
    private String component;
    @Parameter(property="gpg.executable")
    private String executable;
    @Parameter(property="gpg.keyname")
    private String keyname;
    @Parameter(property="gpg.passphrase")
    private String passphrase;
    @Parameter
    private List<String> gpgArguments;
    @Parameter(property="gpg.passphraseServerId", defaultValue="gpg.passphrase")
    private String passphraseServerId;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Parameter(property="gpg.sign", readonly=true)
    private boolean sign;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repository;
        List<DebFile> debs;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            return;
        }
        try {
            debs = this.getDebFiles();
        }
        catch (Exception e1) {
            throw new MojoExecutionException("unable to read .deb files", e1);
        }
        if (debs.isEmpty()) {
            this.getLog().info((CharSequence)"\"deb\" artifacts not found. skipping");
            return;
        }
        GpgSignerImpl signer = null;
        if (this.sign) {
            SignConfiguration signConfig = new SignConfiguration();
            if (this.executable != null) {
                signConfig.setGpgCommand(this.executable);
            } else {
                String command = "gpg";
                if (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
                    command = command + ".exe";
                }
                signConfig.setGpgCommand(command);
            }
            signConfig.setKeyname(this.keyname);
            signConfig.setPassphrase(this.codename);
            this.loadGpgPassphrase();
            signConfig.setPassphrase(this.passphrase);
            signConfig.setGpgArguments(this.gpgArguments);
            signer = new GpgSignerImpl(signConfig);
        }
        if ((repository = this.project.getDistributionManagementArtifactRepository()) == null) {
            throw new MojoExecutionException("no repository found for distribution");
        }
        Wagon w = null;
        Repository repositoryForWagon = new Repository(repository.getId(), repository.getUrl());
        AuthenticationInfo info = null;
        if (repository.getAuthentication() != null) {
            info = new AuthenticationInfo();
            info.setUserName(repository.getAuthentication().getUsername());
            info.setPassword(repository.getAuthentication().getPassword());
        }
        try {
            w = (Wagon)this.container.lookup(Wagon.class, repository.getProtocol());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("unable to find wagon", (Exception)((Object)e));
        }
        if (w == null) {
            throw new MojoExecutionException("unable to find wagon for: " + repository.getProtocol());
        }
        try {
            w.connect(repositoryForWagon, info);
            AptRepositoryImpl aptRepo = new AptRepositoryImpl(this.codename, this.component, (GpgSigner)signer, (Transport)new WagonTransport(w, this.getLog()));
            aptRepo.saveFiles(debs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to save", e);
        }
    }

    private List<DebFile> getDebFiles() throws IOException, ArchiveException {
        List attachedArtefacts = this.project.getAttachedArtifacts();
        ArrayList<DebFile> deb = new ArrayList<DebFile>();
        for (Artifact cur : attachedArtefacts) {
            if (!cur.getType().equals("deb")) continue;
            deb.add(new DebFile(cur.getFile()));
        }
        if (this.file != null && this.file.trim().length() != 0) {
            File f = new File(this.file);
            if (!f.exists()) {
                throw new IOException("specified file not found: " + f.getAbsolutePath());
            }
            deb.add(new DebFile(f));
        }
        if (this.files != null) {
            DirectoryScanner scanner = new DirectoryScanner();
            File basedir = new File(".");
            scanner.setBasedir(basedir);
            scanner.setIncludes(new String[]{this.files});
            scanner.setCaseSensitive(true);
            scanner.scan();
            for (String curFile : scanner.getIncludedFiles()) {
                File f = new File(basedir, curFile);
                if (!f.isFile()) continue;
                deb.add(new DebFile(f));
            }
        }
        return deb;
    }

    private void loadGpgPassphrase() throws MojoFailureException {
        Server server;
        if (StringUtils.isEmpty((String)this.passphrase) && (server = this.settings.getServer(this.passphraseServerId)) != null && server.getPassphrase() != null) {
            try {
                this.passphrase = this.securityDispatcher.decrypt(server.getPassphrase());
            }
            catch (SecDispatcherException e) {
                throw new MojoFailureException("Unable to decrypt gpg passphrase", (Throwable)e);
            }
        }
    }
}

