/*
 * Decompiled with CFR 0.152.
 */
package com.st.maven.apt;

import com.st.maven.apt.FileInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

class Release {
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private String origin;
    private String label;
    private String codename;
    private String date;
    private String architectures;
    private String components;
    private Set<FileInfo> files = new HashSet<FileInfo>();
    private List<String> unknown = new ArrayList<String>();

    Release() {
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCodename() {
        return this.codename;
    }

    public void setCodename(String codename) {
        this.codename = codename;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(String architectures) {
        this.architectures = architectures;
    }

    public String getComponents() {
        return this.components;
    }

    public void setComponents(String components) {
        this.components = components;
    }

    public Set<FileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(Set<FileInfo> files) {
        this.files = files;
    }

    void load(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String curLine = null;
        String curGroup = null;
        HashMap<String, FileInfo> fileInfoByFilename = new HashMap<String, FileInfo>();
        while ((curLine = r.readLine()) != null) {
            String[] parts;
            String line = curLine.trim();
            if (line.length() == 0) continue;
            if (curLine.charAt(0) == ' ') {
                if (curGroup != null) {
                    parts = SPACE.split(line);
                    if (parts.length != 3) {
                        throw new IOException("unsupported format: " + line + " expected: <checksum> <file size> <file name>");
                    }
                    FileInfo info = (FileInfo)fileInfoByFilename.get(parts[2]);
                    if (info == null) {
                        info = new FileInfo();
                        info.setFilename(parts[2]);
                        info.setSize(parts[1]);
                        fileInfoByFilename.put(info.getFilename(), info);
                    }
                    if (curGroup.equals("MD5Sum")) {
                        info.setMd5(parts[0]);
                        continue;
                    }
                    if (curGroup.equals("SHA1")) {
                        info.setSha1(parts[0]);
                        continue;
                    }
                    if (curGroup.equals("SHA256")) {
                        info.setSha256(parts[0]);
                        continue;
                    }
                    throw new IOException("unsupported checksum: " + curGroup);
                }
                this.unknown.add(line);
                continue;
            }
            parts = Release.splitByColon(line);
            String name = parts[0];
            String value = parts[1].trim();
            if (name.equals("Origin")) {
                this.origin = value;
                continue;
            }
            if (name.equals("Label")) {
                this.label = value;
                continue;
            }
            if (name.equals("Codename")) {
                this.codename = value;
                continue;
            }
            if (name.equals("Date")) {
                this.date = value;
                continue;
            }
            if (name.equals("Architectures")) {
                this.architectures = value;
                continue;
            }
            if (name.equals("Components")) {
                this.components = value;
                continue;
            }
            if (name.equals("MD5Sum") || name.equals("SHA1") || name.equals("SHA256")) {
                curGroup = name;
                continue;
            }
            this.unknown.add(line);
        }
        this.files = new HashSet<FileInfo>(fileInfoByFilename.size());
        this.files.addAll(fileInfoByFilename.values());
    }

    private static String[] splitByColon(String line) {
        int index = line.indexOf(58);
        if (index == -1) {
            return new String[]{line};
        }
        String[] result = new String[]{line.substring(0, index), line.substring(index + 1)};
        return result;
    }

    void save(OutputStream os) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        w.append("Origin: ").append(this.origin).append("\n");
        if (this.label != null) {
            w.append("Label: ").append(this.label).append("\n");
        }
        w.append("Codename: ").append(this.codename).append("\n");
        w.append("Date: ").append(this.date).append("\n");
        w.append("Architectures: ").append(this.architectures).append("\n");
        w.append("Components: ").append(this.components).append("\n");
        if (!this.files.isEmpty()) {
            w.append("MD5Sum:\n");
            for (FileInfo cur : this.files) {
                w.append(" ").append(cur.getMd5()).append(" ").append(cur.getSize()).append(" ").append(cur.getFilename()).append("\n");
            }
            w.append("SHA1:\n");
            for (FileInfo cur : this.files) {
                w.append(" ").append(cur.getSha1()).append(" ").append(cur.getSize()).append(" ").append(cur.getFilename()).append("\n");
            }
            w.append("SHA256:\n");
            for (FileInfo cur : this.files) {
                w.append(" ").append(cur.getSha256()).append(" ").append(cur.getSize()).append(" ").append(cur.getFilename()).append("\n");
            }
        }
        w.flush();
    }
}

