/*
 * Decompiled with CFR 0.152.
 */
package com.st.maven.apt;

import com.st.maven.apt.Architecture;
import com.st.maven.apt.ControlFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

class Packages {
    private Architecture architecture;
    private final Map<String, ControlFile> contents = new HashMap<String, ControlFile>();

    Packages() {
    }

    void load(InputStream is) throws IOException {
        String curLine = null;
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder currentControl = new StringBuilder();
        while (true) {
            if ((curLine = r.readLine()) == null || curLine.trim().length() == 0) {
                String currentControlStr = currentControl.toString();
                currentControl = new StringBuilder();
                if (currentControlStr.trim().length() != 0) {
                    ControlFile curFile = new ControlFile();
                    curFile.load(currentControlStr);
                    this.contents.put(curFile.getPackageName(), curFile);
                }
                if (curLine != null) continue;
                break;
            }
            currentControl.append(curLine).append("\n");
        }
    }

    void save(OutputStream os) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        for (ControlFile cur : this.contents.values()) {
            w.append(cur.getContents()).append("\n");
        }
        w.flush();
    }

    void add(ControlFile file) {
        this.contents.put(file.getPackageName(), file);
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    Map<String, ControlFile> getContents() {
        return this.contents;
    }
}

