/*
 * Decompiled with CFR 0.152.
 */
package com.st.maven.apt;

import com.st.maven.apt.Architecture;
import com.st.maven.apt.ControlFile;
import com.st.maven.apt.FileInfo;
import com.st.maven.apt.Packages;
import com.st.maven.apt.Release;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.AbstractGpgSigner;
import org.apache.maven.plugin.gpg.GpgMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=false)
public class AptDeployMojo
extends GpgMojo {
    @Parameter(defaultValue="${maven.deploy.skip}", readonly=true)
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private PlexusContainer container;
    @Parameter(defaultValue="${maven.apt.file}", readonly=true)
    private String file;
    @Parameter(readonly=true, required=true)
    private String codename;
    @Parameter(readonly=true, required=true)
    private String component;
    @Parameter(property="gpg.sign", readonly=true)
    private boolean sign;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repository;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            return;
        }
        List<File> deb = this.getDebFiles();
        if (deb.isEmpty()) {
            this.getLog().info((CharSequence)"\"deb\" artifacts not found. skipping");
            return;
        }
        AbstractGpgSigner signer = null;
        if (this.sign) {
            signer = this.newSigner(this.project);
        }
        if ((repository = this.project.getDistributionManagementArtifactRepository()) == null) {
            throw new MojoExecutionException("no repository found for distribution");
        }
        Wagon w = null;
        Repository repositoryForWagon = new Repository(repository.getId(), repository.getUrl());
        AuthenticationInfo info = null;
        if (repository.getAuthentication() != null) {
            info = new AuthenticationInfo();
            info.setUserName(repository.getAuthentication().getUsername());
            info.setPassword(repository.getAuthentication().getPassword());
        }
        try {
            w = (Wagon)this.container.lookup(Wagon.class, repository.getProtocol());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("unable to find wagon", (Exception)((Object)e));
        }
        if (w == null) {
            throw new MojoExecutionException("unable to find wagon for: " + repository.getProtocol());
        }
        try {
            w.connect(repositoryForWagon, info);
            HashMap<Architecture, Packages> packagesPerArch = new HashMap<Architecture, Packages>();
            for (File f : deb) {
                ControlFile controlFile = this.readControl(f);
                if (controlFile == null) {
                    throw new MojoExecutionException("invalid .deb format. Missing control file: " + f.getAbsolutePath());
                }
                String string = "pool/" + this.component + "/" + controlFile.getPackageName().charAt(0) + "/" + controlFile.getPackageName() + "/" + controlFile.getPackageName() + "_" + controlFile.getVersion() + "_" + (Object)((Object)controlFile.getArch()) + ".deb";
                try {
                    FileInfo fileInfo = AptDeployMojo.getFileInfo(f);
                    controlFile.append("Filename: " + string);
                    controlFile.append("Size: " + fileInfo.getSize());
                    controlFile.append("MD5sum: " + fileInfo.getMd5());
                    controlFile.append("SHA1: " + fileInfo.getSha1());
                    controlFile.append("SHA256: " + fileInfo.getSha256());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("unable to calculate checksum for: " + f.getAbsolutePath(), e);
                }
                if (controlFile.getArch().isWildcard()) {
                    for (Architecture cur : Architecture.values()) {
                        if (cur.isWildcard()) continue;
                        this.addControlFile(w, cur, controlFile, packagesPerArch);
                    }
                } else {
                    this.addControlFile(w, controlFile.getArch(), controlFile, packagesPerArch);
                }
                this.getLog().info((CharSequence)("uploading: " + f.getAbsolutePath()));
                w.put(f, string);
            }
            Release release = this.loadRelease(w);
            HashMap<String, FileInfo> fileinfoByFilename = new HashMap<String, FileInfo>();
            for (FileInfo fileInfo : release.getFiles()) {
                fileinfoByFilename.put(fileInfo.getFilename(), fileInfo);
            }
            for (Packages packages : packagesPerArch.values()) {
                for (FileInfo resultInfo : this.uploadPackages(w, packages)) {
                    fileinfoByFilename.put(resultInfo.getFilename(), resultInfo);
                }
            }
            release.setFiles(new HashSet<FileInfo>(fileinfoByFilename.values()));
            File releaseFile = File.createTempFile("apt", "releaseFile");
            this.uploadRelease(w, releaseFile, release);
            if (signer != null) {
                File file = signer.generateSignatureForArtifact(releaseFile);
                this.getLog().info((CharSequence)"uploading: Release.gpg");
                w.put(file, this.getReleasePath() + ".gpg");
                signer.setArgs(Collections.singletonList("--clearsign"));
                File clearsigned = signer.generateSignatureForArtifact(releaseFile);
                this.getLog().info((CharSequence)"uploading: InRelease");
                w.put(clearsigned, "dists/" + this.codename + "/InRelease");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to process", e);
        }
        finally {
            try {
                w.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"unable to disconnect", (Throwable)e);
            }
        }
    }

    private void addControlFile(Wagon w, Architecture arch, ControlFile file, Map<Architecture, Packages> packagesPerArch) throws MojoExecutionException {
        Packages curPackages = packagesPerArch.get((Object)arch);
        if (curPackages == null) {
            curPackages = this.loadPackages(w, arch);
            packagesPerArch.put(arch, curPackages);
        }
        curPackages.add(file);
    }

    private List<FileInfo> uploadPackages(Wagon w, Packages packages) throws MojoExecutionException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file;
        OutputStream fos = null;
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        try {
            file = File.createTempFile("apt", packages.getArchitecture().name());
            fos = new FileOutputStream(file);
            packages.save(fos);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to write packages", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close cursor", (Throwable)e);
                }
            }
        }
        try {
            FileInfo fileInfo = AptDeployMojo.getFileInfo(file);
            fileInfo.setFilename(this.getPackagesBasePath(packages.getArchitecture()));
            result.add(fileInfo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to calculate checksum for: " + file.getAbsolutePath(), e);
        }
        String path = this.getPackagesPath(packages.getArchitecture());
        this.getLog().info((CharSequence)("uploading: " + path));
        w.put(file, path);
        try {
            file = File.createTempFile("apt", packages.getArchitecture().name());
            fos = new GZIPOutputStream(new FileOutputStream(file));
            packages.save(fos);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to write packages", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close cursor", (Throwable)e);
                }
            }
        }
        try {
            FileInfo fileInfo = AptDeployMojo.getFileInfo(file);
            fileInfo.setFilename(this.getPackagesBasePath(packages.getArchitecture()) + ".gz");
            result.add(fileInfo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to calculate checksum for: " + file.getAbsolutePath(), e);
        }
        this.getLog().info((CharSequence)("uploading: " + path + ".gz"));
        w.put(file, path + ".gz");
        return result;
    }

    private Packages loadPackages(Wagon w, Architecture architecture) throws MojoExecutionException {
        Packages packages = new Packages();
        packages.setArchitecture(architecture);
        InputStream fis = null;
        try {
            File tempFile = File.createTempFile("packages", architecture.name());
            w.get(this.getPackagesPath(architecture) + ".gz", tempFile);
            fis = new GZIPInputStream(new FileInputStream(tempFile));
            packages.load(fis);
        }
        catch (ResourceDoesNotExistException e) {
            this.getLog().info((CharSequence)((Object)((Object)packages.getArchitecture()) + "/Packages.gz do not exist. creating..."));
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to load " + this.getPackagesPath(architecture), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close cursor", (Throwable)e);
                }
            }
        }
        return packages;
    }

    private void uploadRelease(Wagon w, File releaseFile, Release release) throws MojoExecutionException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(releaseFile);
            release.save(fos);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to write releases", e);
        }
        finally {
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close cursor", (Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"uploading: Release");
        w.put(releaseFile, this.getReleasePath());
    }

    private Release loadRelease(Wagon w) throws MojoExecutionException {
        InputStream fis = null;
        Release release = new Release();
        try {
            File tempFile = File.createTempFile("release", "file");
            w.get(this.getReleasePath(), tempFile);
            fis = new FileInputStream(tempFile);
            release.load(fis);
        }
        catch (ResourceDoesNotExistException e) {
            this.getLog().info((CharSequence)"Release do not exist. creating...");
            release.setArchitectures("amd64");
            release.setCodename(this.codename);
            release.setComponents(this.component);
            release.setLabel(this.codename);
            release.setOrigin(this.codename);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to read Release from: " + this.getReleasePath(), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close cursor", (Throwable)e);
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        release.setDate(sdf.format(new Date()));
        return release;
    }

    private String getPackagesBasePath(Architecture architecture) {
        String packagesBaseFilename = this.component + "/binary-" + architecture.name() + "/Packages";
        return packagesBaseFilename;
    }

    private String getPackagesPath(Architecture architecture) {
        String packagesFilename = "dists/" + this.codename + "/" + this.getPackagesBasePath(architecture);
        return packagesFilename;
    }

    private String getReleasePath() {
        String releaseFilename = "dists/" + this.codename + "/Release";
        return releaseFilename;
    }

    private List<File> getDebFiles() throws MojoExecutionException {
        List attachedArtefacts = this.project.getAttachedArtifacts();
        ArrayList<File> deb = new ArrayList<File>();
        for (Artifact cur : attachedArtefacts) {
            if (!cur.getType().equals("deb")) continue;
            deb.add(cur.getFile());
        }
        if (this.file != null && this.file.trim().length() != 0) {
            File f = new File(this.file);
            if (!f.exists()) {
                throw new MojoExecutionException("specified file not found: " + f.getAbsolutePath());
            }
            deb.add(f);
        }
        return deb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileInfo getFileInfo(File f) throws Exception {
        FileInfo result = new FileInfo();
        result.setSize(String.valueOf(f.length()));
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(new FileInputStream(f));
            MessageDigest md5Alg = MessageDigest.getInstance("MD5");
            md5Alg.reset();
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.reset();
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.reset();
            byte[] buf = new byte[2048];
            int curByte = -1;
            while ((curByte = bis.read(buf)) != -1) {
                md5Alg.update(buf, 0, curByte);
                sha1.update(buf, 0, curByte);
                sha256.update(buf, 0, curByte);
            }
            result.setMd5(new String(Hex.encodeHex((byte[])md5Alg.digest())));
            result.setSha1(new String(Hex.encodeHex((byte[])sha1.digest())));
            result.setSha256(new String(Hex.encodeHex((byte[])sha256.digest())));
        }
        return result;
    }

    private ControlFile readControl(File deb) throws MojoExecutionException {
        ArchiveInputStream debStream = null;
        try {
            GZIPInputStream gzipInputStream;
            ArArchiveEntry entry;
            debStream = new ArchiveStreamFactory().createArchiveInputStream("ar", (InputStream)new FileInputStream(deb));
            while ((entry = (ArArchiveEntry)debStream.getNextEntry()) != null) {
                TarArchiveEntry control_entry;
                if (!entry.getName().equals("control.tar.gz")) continue;
                gzipInputStream = new GZIPInputStream((InputStream)debStream);
                ArchiveInputStream control_tgz = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)gzipInputStream);
                while ((control_entry = (TarArchiveEntry)control_tgz.getNextEntry()) != null) {
                    this.getLog().debug((CharSequence)("control entry: " + control_entry.getName()));
                    if (!control_entry.getName().equals("./control")) continue;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)control_tgz, (OutputStream)outputStream);
                    String content_string = outputStream.toString("UTF-8");
                    outputStream.close();
                    ControlFile controlFile = new ControlFile();
                    controlFile.load(content_string);
                    ControlFile controlFile2 = controlFile;
                    return controlFile2;
                }
            }
            gzipInputStream = null;
            return gzipInputStream;
        }
        catch (Exception e) {
            throw new MojoExecutionException("invalid .deb. unable to find control at: " + deb.getAbsolutePath(), e);
        }
        finally {
            if (debStream != null) {
                try {
                    debStream.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"unable to close .deb", (Throwable)e);
                }
            }
        }
    }
}

