/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.operation;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.operation.BitOverflowAction;
import com.aerospike.client.operation.BitPolicy;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;

public final class BitOperation {
    private static final int RESIZE = 0;
    private static final int INSERT = 1;
    private static final int REMOVE = 2;
    private static final int SET = 3;
    private static final int OR = 4;
    private static final int XOR = 5;
    private static final int AND = 6;
    private static final int NOT = 7;
    private static final int LSHIFT = 8;
    private static final int RSHIFT = 9;
    private static final int ADD = 10;
    private static final int SUBTRACT = 11;
    private static final int SET_INT = 12;
    private static final int GET = 50;
    private static final int COUNT = 51;
    private static final int LSCAN = 52;
    private static final int RSCAN = 53;
    private static final int GET_INT = 54;
    private static final int INT_FLAGS_SIGNED = 1;

    public static Operation resize(BitPolicy policy, String binName, int byteSize, int resizeFlags) {
        byte[] bytes = Pack.pack(0, byteSize, policy.flags, resizeFlags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insert(BitPolicy policy, String binName, int byteOffset, byte[] value) {
        byte[] bytes = Pack.pack(1, byteOffset, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation remove(BitPolicy policy, String binName, int byteOffset, int byteSize) {
        byte[] bytes = Pack.pack(2, byteOffset, byteSize, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation set(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        byte[] bytes = Pack.pack(3, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation or(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        byte[] bytes = Pack.pack(4, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation xor(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        byte[] bytes = Pack.pack(5, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation and(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        byte[] bytes = Pack.pack(6, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation not(BitPolicy policy, String binName, int bitOffset, int bitSize) {
        byte[] bytes = Pack.pack(7, bitOffset, bitSize, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation lshift(BitPolicy policy, String binName, int bitOffset, int bitSize, int shift) {
        byte[] bytes = Pack.pack(8, bitOffset, bitSize, shift, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation rshift(BitPolicy policy, String binName, int bitOffset, int bitSize, int shift) {
        byte[] bytes = Pack.pack(9, bitOffset, bitSize, shift, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation add(BitPolicy policy, String binName, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        byte[] bytes = BitOperation.packMath(10, policy, bitOffset, bitSize, value, signed, action);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation subtract(BitPolicy policy, String binName, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        byte[] bytes = BitOperation.packMath(11, policy, bitOffset, bitSize, value, signed, action);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation setInt(BitPolicy policy, String binName, int bitOffset, int bitSize, long value) {
        byte[] bytes = Pack.pack(12, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation get(String binName, int bitOffset, int bitSize) {
        byte[] bytes = Pack.pack(50, bitOffset, bitSize, new CTX[0]);
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(bytes));
    }

    public static Operation count(String binName, int bitOffset, int bitSize) {
        byte[] bytes = Pack.pack(51, bitOffset, bitSize, new CTX[0]);
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(bytes));
    }

    public static Operation lscan(String binName, int bitOffset, int bitSize, boolean value) {
        byte[] bytes = Pack.pack(52, bitOffset, bitSize, value, new CTX[0]);
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(bytes));
    }

    public static Operation rscan(String binName, int bitOffset, int bitSize, boolean value) {
        byte[] bytes = Pack.pack(53, bitOffset, bitSize, value, new CTX[0]);
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(bytes));
    }

    public static Operation getInt(String binName, int bitOffset, int bitSize, boolean signed) {
        byte[] bytes = BitOperation.packGetInt(bitOffset, bitSize, signed);
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(bytes));
    }

    private static byte[] packMath(int command, BitPolicy policy, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        Packer packer = new Packer();
        packer.packArrayBegin(6);
        packer.packInt(command);
        packer.packInt(bitOffset);
        packer.packInt(bitSize);
        packer.packLong(value);
        packer.packInt(policy.flags);
        int flags = action.flags;
        if (signed) {
            flags |= 1;
        }
        packer.packInt(flags);
        return packer.toByteArray();
    }

    private static byte[] packGetInt(int bitOffset, int bitSize, boolean signed) {
        Packer packer = new Packer();
        packer.packArrayBegin(signed ? 4 : 3);
        packer.packInt(54);
        packer.packInt(bitOffset);
        packer.packInt(bitSize);
        if (signed) {
            packer.packInt(1);
        }
        return packer.toByteArray();
    }
}

