/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;

public class AsyncRead
extends AsyncCommand {
    private final RecordListener listener;
    protected final Key key;
    private final String[] binNames;
    private final boolean isOperation;
    protected final Partition partition;
    protected Record record;

    public AsyncRead(Cluster cluster, RecordListener listener, Policy policy, Key key, String[] binNames) {
        super(policy, true);
        this.listener = listener;
        this.key = key;
        this.binNames = binNames;
        this.isOperation = false;
        this.partition = Partition.read(cluster, policy, key);
    }

    public AsyncRead(RecordListener listener, Policy policy, Key key, Partition partition, boolean isOperation) {
        super(policy, true);
        this.listener = listener;
        this.key = key;
        this.binNames = null;
        this.isOperation = isOperation;
        this.partition = partition;
    }

    @Override
    Node getNode(Cluster cluster) {
        return this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    @Override
    protected final boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[this.dataOffset + 5] & 0xFF;
        int generation = Buffer.bytesToInt(this.dataBuffer, this.dataOffset + 6);
        int expiration = Buffer.bytesToInt(this.dataBuffer, this.dataOffset + 10);
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset + 18);
        int opCount = Buffer.bytesToShort(this.dataBuffer, this.dataOffset + 20);
        this.dataOffset += 22;
        if (resultCode == 0) {
            if (opCount == 0) {
                this.record = new Record(null, generation, expiration);
                return true;
            }
            this.skipKey(fieldCount);
            this.record = this.parseRecord(opCount, generation, expiration, this.isOperation);
            return true;
        }
        if (resultCode == 2) {
            this.handleNotFound(resultCode);
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return true;
        }
        if (resultCode == 100) {
            this.skipKey(fieldCount);
            this.record = this.parseRecord(opCount, generation, expiration, this.isOperation);
            this.handleUdfError(resultCode);
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryRead(timeout);
        return true;
    }

    protected void handleNotFound(int resultCode) {
    }

    private final void handleUdfError(int resultCode) {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            message = list[0] + ':' + list[1] + ' ' + list[3];
        }
        catch (Throwable e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

