/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.command.Command;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchOperateListListener;
import com.aerospike.client.listener.BatchRecordArrayListener;
import com.aerospike.client.listener.BatchRecordSequenceListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.util.Util;
import java.util.List;

public final class AsyncBatch {
    private static void onRecord(BatchRecordSequenceListener listener, BatchRecord record, int index2) {
        try {
            listener.onRecord(record, index2);
        }
        catch (Throwable e) {
            Log.error("Unexpected exception from onRecord(): " + Util.getErrorMessage(e));
        }
    }

    static abstract class AsyncBatchCommand
    extends AsyncMultiCommand {
        final AsyncBatchExecutor parent;
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        int sequenceAP;
        int sequenceSC;

        public AsyncBatchCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, boolean isOperation) {
            super(batch.node, batchPolicy, isOperation);
            this.parent = parent;
            this.batch = batch;
            this.batchPolicy = batchPolicy;
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.parent.done || this.policy.replica != Replica.SEQUENCE && this.policy.replica != Replica.PREFER_RACK) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.policy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Runnable other, long deadline) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 0 || batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            AsyncBatchCommand[] cmds = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                AsyncBatchCommand cmd = this.createCommand(batchNode);
                cmd.sequenceAP = this.sequenceAP;
                cmd.sequenceSC = this.sequenceSC;
                cmds[count++] = cmd;
            }
            this.parent.executeBatchRetry(cmds, this, other, deadline);
            return true;
        }

        @Override
        protected void onSuccess() {
            this.parent.childSuccess();
        }

        @Override
        protected void onFailure(AerospikeException e) {
            this.setInDoubt(e.getInDoubt());
            this.parent.childFailure(e);
        }

        protected void setInDoubt(boolean inDoubt) {
        }

        abstract AsyncBatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    private static final class UDFSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final boolean[] sent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;

        public UDFSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, boolean[] sent, BatchRecordSequenceListener listener, BatchAttr attr) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.sent = sent;
            this.listener = listener;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            this.skipKey(this.fieldCount);
            Key keyOrig = this.keys[this.batchIndex];
            BatchRecord record = this.resultCode == 0 ? new BatchRecord(keyOrig, this.parseRecord(), this.attr.hasWrite) : (this.resultCode == 100 ? ((m = (r = this.parseRecord()).getString("FAILURE")) != null ? new BatchRecord(keyOrig, r, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite)) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite));
            this.sent[this.batchIndex] = true;
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            for (int index2 : this.batch.offsets) {
                if (this.sent[index2]) continue;
                Key key = this.keys[index2];
                BatchRecord record = new BatchRecord(key, null, -15, this.attr.hasWrite && inDoubt, this.attr.hasWrite);
                this.sent[index2] = true;
                AsyncBatch.onRecord(this.listener, record, index2);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new UDFSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.sent, this.listener, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sent, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class UDFSequenceExecutor
    extends AsyncBatchExecutor {
        private final BatchRecordSequenceListener listener;
        private final boolean[] sent;

        public UDFSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchRecordSequenceListener listener, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchAttr attr) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.sent = new boolean[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, attr.hasWrite, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new UDFSequenceCommand(this, batchNode, policy, keys, packageName, functionName, argBytes, this.sent, listener, attr);
            }
            this.execute(tasks);
        }

        @Override
        public void batchKeyError(Key key, int index2, AerospikeException ae, boolean inDoubt, boolean hasWrite) {
            BatchRecord record = new BatchRecord(key, null, ae.getResultCode(), inDoubt, hasWrite);
            this.sent[index2] = true;
            AsyncBatch.onRecord(this.listener, record, index2);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    public static final class UDFArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String packageName;
        private final String functionName;
        private final byte[] argBytes;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public UDFArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchRecord[] records, BatchAttr attr) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.packageName = packageName;
            this.functionName = functionName;
            this.argBytes = argBytes;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchUDF(this.batchPolicy, this.keys, this.batch, this.packageName, this.functionName, this.argBytes, this.attr);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter);
                this.parent.setRowError();
                return;
            }
            record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
            this.parent.setRowError();
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = inDoubt;
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new UDFArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.packageName, this.functionName, this.argBytes, this.records, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class UDFArrayExecutor
    extends AsyncBatchExecutor {
        private final BatchRecordArrayListener listener;
        private final BatchRecord[] recordArray;

        public UDFArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchRecordArrayListener listener, Key[] keys, String packageName, String functionName, byte[] argBytes, BatchAttr attr) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.recordArray = new BatchRecord[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                this.recordArray[i] = new BatchRecord(keys[i], attr.hasWrite);
            }
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, this.recordArray, attr.hasWrite, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new UDFArrayCommand(this, batchNode, policy, keys, packageName, functionName, argBytes, this.recordArray, attr);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.recordArray, this.getStatus());
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(this.recordArray, ae);
        }
    }

    private static final class OperateRecordSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final boolean[] sent;
        private final BatchRecordSequenceListener listener;
        private final BatchAttr attr;

        public OperateRecordSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, boolean[] sent, BatchRecordSequenceListener listener, BatchAttr attr) {
            super(parent, batch, batchPolicy, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.sent = sent;
            this.listener = listener;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            Key keyOrig = this.keys[this.batchIndex];
            BatchRecord record = this.resultCode == 0 ? new BatchRecord(keyOrig, this.parseRecord(), this.attr.hasWrite) : new BatchRecord(keyOrig, null, this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter), this.attr.hasWrite);
            this.sent[this.batchIndex] = true;
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            for (int index2 : this.batch.offsets) {
                if (this.sent[index2]) continue;
                Key key = this.keys[index2];
                BatchRecord record = new BatchRecord(key, null, -15, this.attr.hasWrite && inDoubt, this.attr.hasWrite);
                this.sent[index2] = true;
                AsyncBatch.onRecord(this.listener, record, index2);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateRecordSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.ops, this.sent, this.listener, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sent, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class OperateRecordSequenceExecutor
    extends AsyncBatchExecutor {
        private final BatchRecordSequenceListener listener;
        private final boolean[] sent;

        public OperateRecordSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchRecordSequenceListener listener, Key[] keys, Operation[] ops, BatchAttr attr) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.sent = new boolean[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, attr.hasWrite, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new OperateRecordSequenceCommand(this, batchNode, policy, keys, ops, this.sent, listener, attr);
            }
            this.execute(tasks);
        }

        @Override
        public void batchKeyError(Key key, int index2, AerospikeException ae, boolean inDoubt, boolean hasWrite) {
            BatchRecord record = new BatchRecord(key, null, ae.getResultCode(), inDoubt, hasWrite);
            this.sent[index2] = true;
            AsyncBatch.onRecord(this.listener, record, index2);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class OperateRecordArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final Operation[] ops;
        private final BatchRecord[] records;
        private final BatchAttr attr;

        public OperateRecordArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, Operation[] ops, BatchRecord[] records, BatchAttr attr) {
            super(parent, batch, batchPolicy, ops != null);
            this.keys = keys;
            this.ops = ops;
            this.records = records;
            this.attr = attr;
        }

        @Override
        protected boolean isWrite() {
            return this.attr.hasWrite;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, this.ops, this.attr);
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records[this.batchIndex];
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(this.attr.hasWrite, this.commandSentCounter));
                this.parent.setRowError();
            }
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt || !this.attr.hasWrite) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records[index2];
                if (record.resultCode != -15) continue;
                record.inDoubt = inDoubt;
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateRecordArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.ops, this.records, this.attr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.attr.hasWrite, (BatchNodeList.IBatchStatus)this.parent);
        }
    }

    public static final class OperateRecordArrayExecutor
    extends AsyncBatchExecutor {
        private final BatchRecordArrayListener listener;
        private final BatchRecord[] records;

        public OperateRecordArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchRecordArrayListener listener, Key[] keys, Operation[] ops, BatchAttr attr) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = new BatchRecord[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                this.records[i] = new BatchRecord(keys[i], attr.hasWrite);
            }
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, this.records, attr.hasWrite, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new OperateRecordArrayCommand(this, batchNode, policy, keys, ops, this.records, attr);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records, this.getStatus());
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(this.records, ae);
        }
    }

    private static final class OperateSequenceCommand
    extends AsyncBatchCommand {
        private final BatchRecordSequenceListener listener;
        private final List<BatchRecord> records;

        public OperateSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, BatchRecordSequenceListener listener, List<BatchRecord> records) {
            super(parent, batch, batchPolicy, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else if (this.resultCode == 100) {
                Record r = this.parseRecord();
                String m = r.getString("FAILURE");
                if (m != null) {
                    record.record = r;
                    record.resultCode = this.resultCode;
                    record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                } else {
                    record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
                }
            } else {
                record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            }
            AsyncBatch.onRecord(this.listener, record, this.batchIndex);
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateSequenceCommand(this.parent, batchNode, this.batchPolicy, this.listener, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class OperateSequenceExecutor
    extends AsyncBatchExecutor {
        private final BatchRecordSequenceListener listener;

        public OperateSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchRecordSequenceListener listener, List<BatchRecord> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, records, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new OperateSequenceCommand(this, batchNode, policy, listener, records);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class OperateListCommand
    extends AsyncBatchCommand {
        private final List<BatchRecord> records;

        public OperateListCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, List<BatchRecord> records) {
            super(parent, batch, batchPolicy, true);
            this.records = records;
        }

        @Override
        protected boolean isWrite() {
            return true;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchOperate(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected void parseRow() {
            Record r;
            String m;
            this.skipKey(this.fieldCount);
            BatchRecord record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
                return;
            }
            if (this.resultCode == 100 && (m = (r = this.parseRecord()).getString("FAILURE")) != null) {
                record.record = r;
                record.resultCode = this.resultCode;
                record.inDoubt = Command.batchInDoubt(record.hasWrite, this.commandSentCounter);
                this.parent.setRowError();
                return;
            }
            record.setError(this.resultCode, Command.batchInDoubt(record.hasWrite, this.commandSentCounter));
            this.parent.setRowError();
        }

        @Override
        protected void setInDoubt(boolean inDoubt) {
            if (!inDoubt) {
                return;
            }
            for (int index2 : this.batch.offsets) {
                BatchRecord record = this.records.get(index2);
                if (record.resultCode != -15) continue;
                record.inDoubt = record.hasWrite;
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new OperateListCommand(this.parent, batchNode, this.batchPolicy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class OperateListExecutor
    extends AsyncBatchExecutor {
        private final BatchOperateListListener listener;
        private final List<BatchRecord> records;

        public OperateListExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchOperateListListener listener, List<BatchRecord> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = records;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, records, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new OperateListCommand((AsyncBatchExecutor)this, batchNode, policy, records);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records, this.getStatus());
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ExistsSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final ExistsSequenceListener listener;

        public ExistsSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, ExistsSequenceListener listener) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.batchPolicy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key keyOrig = this.keys[this.batchIndex];
            this.listener.onExists(keyOrig, this.resultCode == 0);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.listener);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class ExistsSequenceExecutor
    extends AsyncBatchExecutor {
        private final ExistsSequenceListener listener;

        public ExistsSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, Key[] keys, ExistsSequenceListener listener) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, false, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ExistsSequenceCommand(this, batchNode, policy, keys, listener);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ExistsArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, boolean[] existsArray) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr(this.batchPolicy, 33);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, null, null, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.existsArray);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class ExistsArrayExecutor
    extends AsyncBatchExecutor {
        private final ExistsArrayListener listener;
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, Key[] keys, ExistsArrayListener listener) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            this.keys = keys;
            this.existsArray = new boolean[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, false, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ExistsArrayCommand(this, batchNode, policy, keys, this.existsArray);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.existsArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(new AerospikeException.BatchExists(this.existsArray, (Throwable)ae));
        }
    }

    private static final class GetSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final RecordSequenceListener listener;
        private final int readAttr;

        public GetSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, RecordSequenceListener listener, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.listener = listener;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr((Policy)this.batchPolicy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            Key keyOrig = this.keys[this.batchIndex];
            if (this.resultCode == 0) {
                Record record = this.parseRecord();
                this.listener.onRecord(keyOrig, record);
            } else {
                this.listener.onRecord(keyOrig, null);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.listener, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class GetSequenceExecutor
    extends AsyncBatchExecutor {
        private final RecordSequenceListener listener;

        public GetSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, RecordSequenceListener listener, Key[] keys, String[] binNames, Operation[] ops, int readAttr, boolean isOperation) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, false, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new GetSequenceCommand(this, batchNode, policy, keys, binNames, ops, listener, readAttr, isOperation);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class GetArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, Record[] records, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                BatchAttr attr = new BatchAttr((Policy)this.batchPolicy, this.readAttr, this.ops);
                this.setBatchOperate(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, attr);
            } else {
                this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.records, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false, this.parent);
        }
    }

    public static final class GetArrayExecutor
    extends AsyncBatchExecutor {
        private final RecordArrayListener listener;
        private final Key[] keys;
        private final Record[] recordArray;

        public GetArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, RecordArrayListener listener, Key[] keys, String[] binNames, Operation[] ops, int readAttr, boolean isOperation) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            this.keys = keys;
            this.recordArray = new Record[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys, null, false, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new GetArrayCommand(this, batchNode, policy, keys, binNames, ops, this.recordArray, readAttr, isOperation);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.recordArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(new AerospikeException.BatchRecords(this.recordArray, (Throwable)ae));
        }
    }

    private static final class ReadSequenceCommand
    extends AsyncBatchCommand {
        private final BatchSequenceListener listener;
        private final List<BatchRead> records;

        public ReadSequenceCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, BatchSequenceListener listener, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, this.records, this.batch);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRead record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
            }
            this.listener.onRecord(record);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadSequenceCommand(this.parent, batchNode, this.batchPolicy, this.listener, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class ReadSequenceExecutor
    extends AsyncBatchExecutor {
        private final BatchSequenceListener listener;

        public ReadSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchSequenceListener listener, List<BatchRead> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, records, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ReadSequenceCommand(this, batchNode, policy, listener, records);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ReadListCommand
    extends AsyncBatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(AsyncBatchExecutor parent, BatchNode batch, BatchPolicy batchPolicy, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            if (this.batch.node.hasBatchAny()) {
                this.setBatchOperate(this.batchPolicy, this.records, this.batch);
            } else {
                this.setBatchRead(this.batchPolicy, this.records, this.batch);
            }
        }

        @Override
        protected void parseRow() {
            this.skipKey(this.fieldCount);
            BatchRead record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.setRecord(this.parseRecord());
            } else {
                record.setError(this.resultCode, false);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.parent, batchNode, this.batchPolicy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, this.parent);
        }
    }

    public static final class ReadListExecutor
    extends AsyncBatchExecutor {
        private final BatchListListener listener;
        private final List<BatchRead> records;

        public ReadListExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchListListener listener, List<BatchRead> records) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.records = records;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, records, this);
            AsyncBatchCommand[] tasks = new AsyncBatchCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ReadListCommand((AsyncBatchExecutor)this, batchNode, policy, records);
            }
            this.execute(tasks);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }
}

