/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaData;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;

public final class LuaList
extends LuaUserdata
implements LuaData {
    private final LuaInstance instance;
    private final List<LuaValue> list;

    public LuaList(LuaInstance instance, List<LuaValue> list) {
        super(list);
        this.instance = instance;
        this.list = list;
        this.setmetatable(instance.getPackage("List"));
    }

    public LuaInteger size() {
        return LuaInteger.valueOf((int)this.list.size());
    }

    public LuaString toLuaString() {
        return LuaString.valueOf((String)this.list.toString());
    }

    public LuaValue get(LuaValue index2) {
        return this.list.get(index2.toint() - 1);
    }

    public void set(LuaValue index2, LuaValue value) {
        int i = index2.toint();
        this.ensureSize(i);
        this.list.set(i - 1, value);
    }

    public Iterator<LuaValue> iterator() {
        return this.list.iterator();
    }

    public void insert(LuaValue index2, LuaValue value) {
        int i = index2.toint();
        this.ensureSize(i);
        this.list.add(i - 1, value);
    }

    public void append(LuaValue value) {
        this.list.add(value);
    }

    public void prepend(LuaValue value) {
        this.list.add(0, value);
    }

    public LuaList take(LuaValue items) {
        int max = items.toint();
        if (max > this.list.size()) {
            max = this.list.size();
        }
        return this.subList(0, max);
    }

    public void remove(LuaValue index2) {
        this.list.remove(index2.toint() - 1);
    }

    public LuaList drop(LuaValue count) {
        int c = count.toint();
        if (c >= this.list.size()) {
            return new LuaList(this.instance, new ArrayList<LuaValue>(0));
        }
        return this.subList(c, this.list.size());
    }

    public void trim(LuaValue count) {
        int min = count.toint() - 1;
        for (int i = this.list.size() - 1; i >= min; --i) {
            this.list.remove(i);
        }
    }

    public LuaList clone() {
        return new LuaList(this.instance, new ArrayList<LuaValue>(this.list));
    }

    public void concat(LuaList list2) {
        this.list.addAll(list2.list);
    }

    public LuaList merge(LuaList list2) {
        ArrayList<LuaValue> target = new ArrayList<LuaValue>(this.list);
        target.addAll(list2.list);
        return new LuaList(this.instance, target);
    }

    @Override
    public Object luaToObject() {
        ArrayList<Object> target = new ArrayList<Object>(this.list.size());
        for (LuaValue luaValue : this.list) {
            Object obj = LuaUtil.luaToObject(luaValue);
            target.add(obj);
        }
        return target;
    }

    private void ensureSize(int size) {
        if (size > this.list.size()) {
            for (int i = this.list.size(); i < size; ++i) {
                this.list.add(LuaValue.NIL);
            }
        }
    }

    private LuaList subList(int begin, int end) {
        return new LuaList(this.instance, new ArrayList<LuaValue>(this.list.subList(begin, end)));
    }
}

