/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.io.IOException;
import java.util.List;

public final class Batch {

    private static abstract class BatchCommand
    extends MultiCommand {
        final Executor parent;
        final BatchNode batch;
        final BatchPolicy policy;
        int sequenceAP;
        int sequenceSC;

        public BatchCommand(Executor parent, BatchNode batch, BatchPolicy policy) {
            super(batch.node, false);
            this.parent = parent;
            this.batch = batch;
            this.policy = policy;
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.policy.replica != Replica.SEQUENCE && this.policy.replica != Replica.PREFER_RACK || this.parent != null && this.parent.isDone()) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.policy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
            List<BatchNode> batchNodes = this.generateBatchNodes(cluster);
            if (batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            for (BatchNode batchNode : batchNodes) {
                BatchCommand command = this.createCommand(batchNode);
                command.sequenceAP = this.sequenceAP;
                command.sequenceSC = this.sequenceSC;
                command.execute(cluster, this.policy, true, socketTimeout, totalTimeout, deadline, iteration, commandSentCounter);
            }
            return true;
        }

        abstract BatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes(Cluster var1);
    }

    public static final class ExistsArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(Executor parent, BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray) {
            super(parent, batch, policy);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.parent, batchNode, this.policy, this.keys, this.existsArray);
        }

        @Override
        protected List<BatchNode> generateBatchNodes(Cluster cluster) {
            return BatchNode.generateList(cluster, this.policy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class GetArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(Executor parent, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(parent, batch, policy);
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.parent, batchNode, this.policy, this.keys, this.binNames, this.records, this.readAttr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes(Cluster cluster) {
            return BatchNode.generateList(cluster, this.policy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class ReadListCommand
    extends BatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(Executor parent, BatchNode batch, BatchPolicy policy, List<BatchRead> records) {
            super(parent, batch, policy);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.policy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) throws IOException {
            if (this.resultCode == 0) {
                BatchRead record = this.records.get(this.batchIndex);
                record.record = this.parseRecord();
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.parent, batchNode, this.policy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes(Cluster cluster) {
            return BatchNode.generateList(cluster, this.policy, this.records, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }
}

