/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class NodeValidator {
    String name;
    List<Host> aliases;
    Host primaryHost;
    InetSocketAddress primaryAddress;
    Connection primaryConn;
    byte[] sessionToken;
    long sessionExpiration;
    int features;

    public Node seedNode(Cluster cluster, Host host) throws Exception {
        InetAddress[] addresses = NodeValidator.getAddresses(host);
        Exception exception = null;
        for (InetAddress address : addresses) {
            try {
                this.validateAddress(cluster, address, host.tlsName, host.port, true);
                if (this.aliases == null) {
                    this.setAliases(address, host.tlsName, host.port);
                }
                return cluster.createNode(this);
            }
            catch (Exception e) {
                if (Log.debugEnabled()) {
                    Log.debug("Address " + address + ' ' + host.port + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    public void validateNode(Cluster cluster, Host host) throws Exception {
        InetAddress[] addresses = NodeValidator.getAddresses(host);
        Exception exception = null;
        for (InetAddress address : addresses) {
            try {
                this.validateAddress(cluster, address, host.tlsName, host.port, false);
                this.setAliases(address, host.tlsName, host.port);
                return;
            }
            catch (Exception e) {
                if (Log.debugEnabled()) {
                    Log.debug("Address " + address + ' ' + host.port + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    private static InetAddress[] getAddresses(Host host) {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(host.name);
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
        if (addresses.length == 0) {
            throw new AerospikeException.Connection("Failed to find addresses for " + host);
        }
        return addresses;
    }

    private void validateAddress(Cluster cluster, InetAddress address, String tlsName, int port, boolean detectLoadBalancer) throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        Connection conn = cluster.tlsPolicy != null ? new Connection(cluster.tlsPolicy, tlsName, socketAddress, cluster.connectionTimeout, cluster.maxSocketIdleNanos, null) : new Connection(socketAddress, cluster.connectionTimeout, cluster.maxSocketIdleNanos, null);
        try {
            boolean hasClusterName;
            if (cluster.user != null) {
                AdminCommand.LoginCommand admin = new AdminCommand.LoginCommand(cluster, conn);
                this.sessionToken = admin.sessionToken;
                this.sessionExpiration = admin.sessionExpiration;
                if (cluster.tlsPolicy != null && cluster.tlsPolicy.forLoginOnly) {
                    SwitchClear sc = new SwitchClear(cluster, conn, this.sessionToken);
                    conn.close();
                    address = sc.clearAddress;
                    socketAddress = sc.clearSocketAddress;
                    conn = sc.clearConn;
                    detectLoadBalancer = false;
                }
            }
            ArrayList<String> commands = new ArrayList<String>(5);
            commands.add("node");
            commands.add("partition-generation");
            commands.add("features");
            boolean bl = hasClusterName = cluster.clusterName != null && cluster.clusterName.length() > 0;
            if (hasClusterName) {
                commands.add("cluster-name");
            }
            String addressCommand = null;
            if (detectLoadBalancer) {
                if (address.isLoopbackAddress()) {
                    detectLoadBalancer = false;
                } else {
                    addressCommand = cluster.tlsPolicy != null ? (cluster.useServicesAlternate ? "service-tls-alt" : "service-tls-std") : (cluster.useServicesAlternate ? "service-clear-alt" : "service-clear-std");
                    commands.add(addressCommand);
                }
            }
            HashMap<String, String> map = Info.request(conn, commands);
            this.primaryHost = new Host(address.getHostAddress(), tlsName, port);
            this.primaryAddress = socketAddress;
            this.primaryConn = conn;
            this.validateNode(map);
            this.validatePartitionGeneration(map);
            this.setFeatures(map);
            if (hasClusterName) {
                this.validateClusterName(cluster, map);
            }
            if (addressCommand != null) {
                this.setAddress(cluster, map, addressCommand, tlsName);
            }
        }
        catch (Exception e) {
            conn.close();
            throw e;
        }
    }

    private void validateNode(HashMap<String, String> map) {
        this.name = map.get("node");
        if (this.name == null) {
            throw new AerospikeException.InvalidNode("Node name is null");
        }
    }

    private void validatePartitionGeneration(HashMap<String, String> map) {
        int gen;
        String genString = map.get("partition-generation");
        try {
            gen = Integer.parseInt(genString);
        }
        catch (Exception ex) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + " returned invalid partition-generation: " + genString);
        }
        if (gen == -1) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + " is not yet fully initialized");
        }
    }

    private void setFeatures(HashMap<String, String> map) {
        try {
            String featuresString = map.get("features");
            int begin = 0;
            int end = 0;
            while (end < featuresString.length()) {
                int len;
                end = featuresString.indexOf(59, begin);
                if (end < 0) {
                    end = featuresString.length();
                }
                if (featuresString.regionMatches(begin, "geo", 0, len = end - begin)) {
                    this.features |= 1;
                } else if (featuresString.regionMatches(begin, "replicas", 0, len)) {
                    this.features |= 0x20;
                } else if (featuresString.regionMatches(begin, "peers", 0, len)) {
                    this.features |= 0x10;
                } else if (featuresString.regionMatches(begin, "cluster-stable", 0, len)) {
                    this.features |= 0x40;
                } else if (featuresString.regionMatches(begin, "lut-now", 0, len)) {
                    this.features |= 0x80;
                } else if (featuresString.regionMatches(begin, "truncate-namespace", 0, len)) {
                    this.features |= 2;
                } else if (featuresString.regionMatches(begin, "blob-bits", 0, len)) {
                    this.features |= 4;
                } else if (featuresString.regionMatches(begin, "sindex-exists", 0, len)) {
                    this.features |= 8;
                }
                begin = end + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateClusterName(Cluster cluster, HashMap<String, String> map) {
        String id = map.get("cluster-name");
        if (id == null || !cluster.clusterName.equals(id)) {
            throw new AerospikeException.InvalidNode("Node " + this.name + ' ' + this.primaryHost + ' ' + " expected cluster name '" + cluster.clusterName + "' received '" + id + "'");
        }
    }

    private void setAddress(Cluster cluster, HashMap<String, String> map, String addressCommand, String tlsName) {
        String alt;
        Host h;
        String result = map.get(addressCommand);
        if (result == null || result.length() == 0) {
            return;
        }
        List<Host> hosts = Host.parseServiceHosts(result);
        Iterator<Host> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            Host host;
            h = host = iterator.next();
            if (cluster.ipMap != null && (alt = cluster.ipMap.get(h.name)) != null) {
                h = new Host(alt, h.port);
            }
            if (!h.equals(this.primaryHost)) continue;
            return;
        }
        for (Host host : hosts) {
            try {
                InetAddress[] addresses;
                h = host;
                if (cluster.ipMap != null && (alt = cluster.ipMap.get(h.name)) != null) {
                    h = new Host(alt, h.port);
                }
                for (InetAddress address : addresses = InetAddress.getAllByName(h.name)) {
                    try {
                        InetSocketAddress socketAddress = new InetSocketAddress(address, h.port);
                        Connection conn = cluster.tlsPolicy != null ? new Connection(cluster.tlsPolicy, tlsName, socketAddress, cluster.connectionTimeout, cluster.maxSocketIdleNanos, null) : new Connection(socketAddress, cluster.connectionTimeout, cluster.maxSocketIdleNanos, null);
                        try {
                            AdminCommand admin;
                            if (cluster.user != null && !(admin = new AdminCommand(ThreadLocalData.getBuffer())).authenticate(cluster, conn, this.sessionToken)) {
                                throw new AerospikeException("Authentication failed");
                            }
                            this.setAliases(address, tlsName, h.port);
                            this.primaryHost = new Host(address.getHostAddress(), tlsName, h.port);
                            this.primaryAddress = socketAddress;
                            this.primaryConn.close();
                            this.primaryConn = conn;
                            return;
                        }
                        catch (Exception e) {
                            conn.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        if (Log.infoEnabled()) {
            Log.info("Invalid address " + result + ". access-address is probably not configured on server.");
        }
    }

    private void setAliases(InetAddress address, String tlsName, int port) {
        this.aliases = new ArrayList<Host>(3);
        this.aliases.add(new Host(address.getHostAddress(), tlsName, port));
    }

    private static final class SwitchClear {
        private InetAddress clearAddress;
        private InetSocketAddress clearSocketAddress;
        private Connection clearConn;

        private SwitchClear(Cluster cluster, Connection conn, byte[] sessionToken) throws Exception {
            String command = cluster.useServicesAlternate ? "service-clear-alt" : "service-clear-std";
            String result = Info.request(conn, command);
            List<Host> hosts = Host.parseServiceHosts(result);
            for (Host host : hosts) {
                try {
                    InetAddress[] addresses;
                    String alternativeHost;
                    Host clearHost = host;
                    if (cluster.ipMap != null && (alternativeHost = cluster.ipMap.get(clearHost.name)) != null) {
                        clearHost = new Host(alternativeHost, clearHost.port);
                    }
                    for (InetAddress ia : addresses = InetAddress.getAllByName(clearHost.name)) {
                        try {
                            this.clearAddress = ia;
                            this.clearSocketAddress = new InetSocketAddress(this.clearAddress, clearHost.port);
                            this.clearConn = new Connection(this.clearSocketAddress, cluster.connectionTimeout, cluster.maxSocketIdleNanos, null);
                            try {
                                AdminCommand admin = new AdminCommand(ThreadLocalData.getBuffer());
                                if (!admin.authenticate(cluster, this.clearConn, sessionToken)) {
                                    throw new AerospikeException("Authentication failed");
                                }
                                return;
                            }
                            catch (Exception e) {
                                this.clearConn.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            throw new AerospikeException("Invalid non-TLS address: " + result);
        }
    }
}

