/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncScan;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.util.RandomShift;

public final class AsyncScanExecutor
extends AsyncMultiExecutor {
    private final RecordSequenceListener listener;

    public AsyncScanExecutor(EventLoop eventLoop, Cluster cluster, ScanPolicy policy, RecordSequenceListener listener, String namespace, String setName, String[] binNames) throws AerospikeException {
        super(eventLoop, cluster);
        this.listener = listener;
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(-8, "Scan failed because cluster is empty.");
        }
        long taskId = RandomShift.instance().nextLong();
        AsyncMultiCommand[] tasks = new AsyncScan[nodes.length];
        int count = 0;
        boolean hasClusterStable = true;
        for (Node node : nodes) {
            if (!node.hasClusterStable()) {
                hasClusterStable = false;
            }
            tasks[count++] = new AsyncScan(this, node, policy, listener, namespace, setName, binNames, taskId);
        }
        if (policy.failOnClusterChange && hasClusterStable) {
            this.executeValidate(tasks, policy.maxConcurrentNodes, namespace);
        } else {
            this.execute(tasks, policy.maxConcurrentNodes);
        }
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess();
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

