/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.parameters.ConfigParameters;
import com.adyen.threeds2.util.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public final class AdyenConfigParameters {
    public static final Parameter DIRECTORY_SERVER_ID = new Parameter("threeds2.directoryServer", "id");
    public static final Parameter DIRECTORY_SERVER_PUBLIC_KEY = new Parameter("threeds2.directoryServer", "publicKey");
    public static final Parameter DIRECTORY_SERVER_ROOT_CERTIFICATES = new Parameter("threeds2.directoryServer", "rootCertificates");
    public static final Parameter SECURITY_APP_SIGNATURE = new Parameter("security", "appSignature");
    public static final Parameter SECURITY_TRUSTED_APP_STORES = new Parameter("security", "trustedAppStores");
    public static final Parameter SECURITY_MALICIOUS_APPS = new Parameter("security", "maliciousApps");
    public static final Parameter DEVICE_PARAMETER_BLOCK_LIST = new Parameter(null, "deviceParameterBlockList");
    private static final String COLLECTION_DELIMITER = ";";

    public static Collection<String> getParamValues(ConfigParameters configParameters, Parameter parameter) throws InvalidInputException {
        String string = AdyenConfigParameters.getParamValue(configParameters, parameter);
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(COLLECTION_DELIMITER);
        return Arrays.asList(stringArray);
    }

    public static String getParamValue(ConfigParameters configParameters, Parameter parameter) throws InvalidInputException {
        Preconditions.requireNonNull("configParameters", configParameters);
        Preconditions.requireNonNull("parameter", parameter);
        String string = parameter.getGroup();
        String string2 = parameter.getParamName();
        return configParameters.getParamValue(string, string2);
    }

    static void addParam(ConfigParameters configParameters, Parameter parameter, Collection<String> paramValues) throws InvalidInputException {
        Preconditions.requireNonNull("paramValues", paramValues);
        AdyenConfigParameters.addParam(configParameters, parameter, TextUtils.join((CharSequence)COLLECTION_DELIMITER, paramValues));
    }

    static void addParam(ConfigParameters configParameters, Parameter parameter, String paramValue) throws InvalidInputException {
        Preconditions.requireNonNull("configParameters", configParameters);
        Preconditions.requireNonNull("parameter", parameter);
        Preconditions.requireNonEmpty("paramValue", paramValue);
        configParameters.addParam(parameter.getGroup(), parameter.getParamName(), paramValue);
    }

    private AdyenConfigParameters() {
        throw new IllegalStateException("No instances.");
    }

    public static final class Parameter {
        private final String mGroup;
        private final String mParamName;

        Parameter(String group, String paramName) {
            this.mGroup = group;
            this.mParamName = paramName;
        }

        final String getGroup() {
            return this.mGroup;
        }

        final String getParamName() {
            return this.mParamName;
        }
    }

    public static final class Builder {
        private final String mDirectoryServerId;
        private final String mDirectoryServerPublicKey;
        private final String mDirectoryServerRootCertificates;
        private String mAppSignature;
        private Set<String> mTrustedAppStores;
        private Set<String> mMaliciousApps;
        private Set<String> mDeviceParameterBlockList;

        public Builder(@NonNull String directoryServerId, @NonNull String directoryServerPublicKey, @NonNull String directoryServerRootCertificates) {
            this.mDirectoryServerId = directoryServerId;
            this.mDirectoryServerPublicKey = directoryServerPublicKey;
            this.mDirectoryServerRootCertificates = directoryServerRootCertificates;
        }

        public final Builder appSignature(String appSignature) {
            this.mAppSignature = appSignature;
            return this;
        }

        public final Builder trustedAppStores(Set<String> trustedAppStores) {
            this.mTrustedAppStores = trustedAppStores;
            return this;
        }

        public final Builder maliciousApps(Set<String> maliciousApps) {
            this.mMaliciousApps = maliciousApps;
            return this;
        }

        public final Builder deviceParameterBlockList(Set<String> deviceParameterBlockList) {
            this.mDeviceParameterBlockList = deviceParameterBlockList;
            return this;
        }

        public final ConfigParameters build() throws InvalidInputException {
            Preconditions.requireNonEmpty("directoryServerId", this.mDirectoryServerId);
            Preconditions.requireNonEmpty("directoryServerPublicKey", this.mDirectoryServerPublicKey);
            Preconditions.requireNonEmpty("directoryServerRootCertificates", this.mDirectoryServerRootCertificates);
            ConfigParameters configParameters = new ConfigParameters();
            AdyenConfigParameters.addParam(configParameters, DIRECTORY_SERVER_ID, this.mDirectoryServerId);
            AdyenConfigParameters.addParam(configParameters, DIRECTORY_SERVER_PUBLIC_KEY, this.mDirectoryServerPublicKey);
            AdyenConfigParameters.addParam(configParameters, DIRECTORY_SERVER_ROOT_CERTIFICATES, this.mDirectoryServerRootCertificates);
            if (this.mAppSignature != null) {
                AdyenConfigParameters.addParam(configParameters, SECURITY_APP_SIGNATURE, this.mAppSignature);
            }
            if (this.mTrustedAppStores != null) {
                AdyenConfigParameters.addParam(configParameters, SECURITY_TRUSTED_APP_STORES, this.mTrustedAppStores);
            }
            if (this.mMaliciousApps != null) {
                AdyenConfigParameters.addParam(configParameters, SECURITY_MALICIOUS_APPS, this.mMaliciousApps);
            }
            if (this.mDeviceParameterBlockList != null) {
                AdyenConfigParameters.addParam(configParameters, DEVICE_PARAMETER_BLOCK_LIST, this.mDeviceParameterBlockList);
            }
            return configParameters;
        }
    }
}

