/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.parameters;

import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

public final class ConfigParameters {
    private final Map<String, Map<String, String>> mParameters = new HashMap<String, Map<String, String>>();

    public final void addParam(String group, String paramName, String paramValue) throws InvalidInputException {
        Preconditions.requireNonNull("paramName", paramName);
        Map<String, String> map = this.getParametersForGroup(group, true);
        map.put(paramName, paramValue);
    }

    public final String getParamValue(String group, String paramName) throws InvalidInputException {
        Preconditions.requireNonNull("paramName", paramName);
        Map<String, String> map = this.getParametersForGroup(group, false);
        return map != null ? map.get(paramName) : null;
    }

    public final String removeParam(String group, String paramName) throws InvalidInputException {
        Preconditions.requireNonNull("paramName", paramName);
        Map<String, String> map = this.getParametersForGroup(group, false);
        return map != null ? map.remove(paramName) : null;
    }

    public final Map<String, String> getGroup(String group) {
        return this.getParametersForGroup(group, false);
    }

    private Map<String, String> getParametersForGroup(String group, boolean createIfNeeded) {
        Map<String, String> map = this.mParameters.get(group);
        if (createIfNeeded && map == null) {
            map = new HashMap<String, String>();
            this.mParameters.put(group, map);
        }
        return map;
    }
}

