/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.customization;

import android.os.Parcel;
import android.os.Parcelable;
import com.adyen.threeds2.customization.ButtonCustomization;
import com.adyen.threeds2.customization.Customization;
import com.adyen.threeds2.customization.ExpandableInfoCustomization;
import com.adyen.threeds2.customization.LabelCustomization;
import com.adyen.threeds2.customization.ScreenCustomization;
import com.adyen.threeds2.customization.SelectionItemCustomization;
import com.adyen.threeds2.customization.TextBoxCustomization;
import com.adyen.threeds2.customization.ToolbarCustomization;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kotlin.Deprecated;

public final class UiCustomization
implements Parcelable {
    public static final Parcelable.Creator<UiCustomization> CREATOR = new Parcelable.Creator<UiCustomization>(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new UiCustomization(parcel);
        }
    };
    private final HashMap<ButtonType, ButtonCustomization> mButtonTypeCustomizationMap;
    private final HashMap<Class<? extends Customization>, Customization> mCustomizationMap;

    public UiCustomization() {
        this.mButtonTypeCustomizationMap = new HashMap();
        this.mCustomizationMap = new HashMap();
    }

    UiCustomization(Parcel in) {
        this.mButtonTypeCustomizationMap = (HashMap)in.readSerializable();
        this.mCustomizationMap = (HashMap)in.readSerializable();
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable(this.mButtonTypeCustomizationMap);
        dest.writeSerializable(this.mCustomizationMap);
    }

    public final ButtonCustomization getButtonCustomization(ButtonType buttonType) throws InvalidInputException {
        Preconditions.requireNonNull("buttonType", (Object)buttonType);
        return this.getOrCreateButtonCustomization(buttonType);
    }

    public final void setButtonCustomization(ButtonCustomization buttonCustomization, ButtonType buttonType) throws InvalidInputException {
        Preconditions.requireNonNull("buttonType", (Object)buttonType);
        this.mButtonTypeCustomizationMap.put(buttonType, buttonCustomization);
    }

    public final ScreenCustomization getScreenCustomization() {
        return this.getOrCreateCustomization(ScreenCustomization.class);
    }

    public final void setScreenCustomization(ScreenCustomization screenCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("screenCustomization", screenCustomization);
        this.mCustomizationMap.put(ScreenCustomization.class, screenCustomization);
    }

    public final ToolbarCustomization getToolbarCustomization() {
        return this.getOrCreateCustomization(ToolbarCustomization.class);
    }

    public final void setToolbarCustomization(ToolbarCustomization toolbarCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("toolbarCustomization", toolbarCustomization);
        this.mCustomizationMap.put(ToolbarCustomization.class, toolbarCustomization);
    }

    public final LabelCustomization getLabelCustomization() {
        return this.getOrCreateCustomization(LabelCustomization.class);
    }

    public final void setLabelCustomization(LabelCustomization labelCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("labelCustomization", labelCustomization);
        this.mCustomizationMap.put(LabelCustomization.class, labelCustomization);
    }

    public final TextBoxCustomization getTextBoxCustomization() {
        return this.getOrCreateCustomization(TextBoxCustomization.class);
    }

    public final void setTextBoxCustomization(TextBoxCustomization textBoxCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("textBoxCustomization", textBoxCustomization);
        this.mCustomizationMap.put(TextBoxCustomization.class, textBoxCustomization);
    }

    public final SelectionItemCustomization getSelectionItemCustomization() {
        return this.getOrCreateCustomization(SelectionItemCustomization.class);
    }

    public final void setSelectionItemCustomization(SelectionItemCustomization selectionItemCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("selectionItemCustomization", selectionItemCustomization);
        this.mCustomizationMap.put(SelectionItemCustomization.class, selectionItemCustomization);
    }

    public final ExpandableInfoCustomization getExpandableInfoCustomization() {
        return this.getOrCreateCustomization(ExpandableInfoCustomization.class);
    }

    public final void setExpandableInfoCustomization(ExpandableInfoCustomization expandableInfoCustomization) throws InvalidInputException {
        Preconditions.requireNonNull("expandableInfoCustomization", expandableInfoCustomization);
        this.mCustomizationMap.put(ExpandableInfoCustomization.class, expandableInfoCustomization);
    }

    public final void setToolbarTitle(String title) {
        Preconditions.requireNonEmpty("title", title);
        ToolbarCustomization toolbarCustomization = this.getOrCreateCustomization(ToolbarCustomization.class);
        toolbarCustomization.setHeaderText(title);
    }

    @Deprecated(message="Deprecated in Android. Has no effect starting from Android 15.")
    public final void setStatusBarColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.getOrCreateCustomization(ScreenCustomization.class);
        screenCustomization.setStatusBarColor(hexColorCode);
    }

    public final void setScreenBackgroundColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.getOrCreateCustomization(ScreenCustomization.class);
        screenCustomization.setBackgroundColor(hexColorCode);
    }

    public final void setTextColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ScreenCustomization screenCustomization = this.getOrCreateCustomization(ScreenCustomization.class);
        screenCustomization.setTextColor(hexColorCode);
        ToolbarCustomization toolbarCustomization = this.getOrCreateCustomization(ToolbarCustomization.class);
        toolbarCustomization.setTextColor(hexColorCode);
        ButtonCustomization buttonCustomization = this.getOrCreateButtonCustomization(ButtonType.CANCEL);
        buttonCustomization.setTextColor(hexColorCode);
        LabelCustomization labelCustomization = this.getOrCreateCustomization(LabelCustomization.class);
        labelCustomization.setTextColor(hexColorCode);
        labelCustomization.setHeadingTextColor(hexColorCode);
        labelCustomization.setInputLabelTextColor(hexColorCode);
        TextBoxCustomization textBoxCustomization = this.getOrCreateCustomization(TextBoxCustomization.class);
        textBoxCustomization.setTextColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.getOrCreateCustomization(SelectionItemCustomization.class);
        selectionItemCustomization.setTextColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.getOrCreateCustomization(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setTextColor(hexColorCode);
        expandableInfoCustomization.setHeadingTextColor(hexColorCode);
        expandableInfoCustomization.setExpandStateIndicatorColor(hexColorCode);
    }

    public final void setBorderColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        TextBoxCustomization textBoxCustomization = this.getOrCreateCustomization(TextBoxCustomization.class);
        textBoxCustomization.setBorderColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.getOrCreateCustomization(SelectionItemCustomization.class);
        selectionItemCustomization.setBorderColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.getOrCreateCustomization(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setBorderColor(hexColorCode);
    }

    public final void setTintColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        ToolbarCustomization toolbarCustomization = this.getOrCreateCustomization(ToolbarCustomization.class);
        toolbarCustomization.setBackgroundColor(hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.getOrCreateCustomization(SelectionItemCustomization.class);
        selectionItemCustomization.setSelectionIndicatorTintColor(hexColorCode);
        block4: for (ButtonType buttonType : ButtonType.values()) {
            ButtonCustomization buttonCustomization = this.getOrCreateButtonCustomization(buttonType);
            switch (buttonType) {
                case CANCEL: {
                    continue block4;
                }
                case RESEND: {
                    buttonCustomization.setTextColor(hexColorCode);
                    continue block4;
                }
                default: {
                    buttonCustomization.setBackgroundColor(hexColorCode);
                }
            }
        }
    }

    public final void setHighlightedBackgroundColor(String hexColorCode) throws InvalidInputException {
        Preconditions.requireNonEmpty("hexColorCode", hexColorCode);
        SelectionItemCustomization selectionItemCustomization = this.getOrCreateCustomization(SelectionItemCustomization.class);
        selectionItemCustomization.setHighlightedBackgroundColor(hexColorCode);
        ExpandableInfoCustomization expandableInfoCustomization = this.getOrCreateCustomization(ExpandableInfoCustomization.class);
        expandableInfoCustomization.setHighlightedBackgroundColor(hexColorCode);
        List<ButtonType> list = Arrays.asList(ButtonType.CANCEL, ButtonType.RESEND);
        for (ButtonType buttonType : list) {
            ButtonCustomization buttonCustomization = this.getOrCreateButtonCustomization(buttonType);
            buttonCustomization.setBackgroundColor(hexColorCode);
        }
    }

    private ButtonCustomization getOrCreateButtonCustomization(ButtonType buttonType) {
        ButtonCustomization buttonCustomization = this.mButtonTypeCustomizationMap.get((Object)buttonType);
        if (buttonCustomization == null) {
            buttonCustomization = new ButtonCustomization();
            this.mButtonTypeCustomizationMap.put(buttonType, buttonCustomization);
        }
        return buttonCustomization;
    }

    private <T extends Customization> T getOrCreateCustomization(Class<T> clazz) {
        Customization customization = this.mCustomizationMap.get(clazz);
        if (customization == null) {
            try {
                Customization customization2 = (Customization)clazz.newInstance();
                this.mCustomizationMap.put(clazz, customization2);
                return (T)customization2;
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Could not instantiate " + clazz.getSimpleName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Could not access constructor of " + clazz.getSimpleName(), illegalAccessException);
            }
        }
        return (T)customization;
    }

    public static enum ButtonType {
        VERIFY,
        CONTINUE,
        NEXT,
        CANCEL,
        RESEND,
        OPEN_OOB_APP;

    }
}

