/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.threeds2.customization;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.Typeface;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.util.Preconditions;
import java.io.Serializable;

public class Customization
implements Serializable {
    static final int INITIAL_VALUE = -1;
    private String mTextColorCode;
    private String mTextFontName;
    private int mTextFontSize = -1;

    public static Integer parseHexColorCode(String hexColorCode) {
        if (hexColorCode != null && !hexColorCode.isEmpty() && hexColorCode.charAt(0) == '#') {
            try {
                return Color.parseColor((String)hexColorCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Typeface parseTypeface(Context context, String fontName) {
        if (fontName == null) {
            return null;
        }
        Typeface typeface = null;
        try {
            typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        try {
            typeface = Typeface.createFromFile((String)fontName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        try {
            typeface = Typeface.create((String)fontName, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeface != null) {
            return typeface;
        }
        return null;
    }

    Customization() {
    }

    public String getTextColor() {
        return this.mTextColorCode;
    }

    public void setTextColor(String hexColorCode) throws InvalidInputException {
        this.mTextColorCode = this.requireHexColorCode(hexColorCode);
    }

    public String getTextFontName() {
        return this.mTextFontName;
    }

    public void setTextFontName(String fontName) throws InvalidInputException {
        this.mTextFontName = this.requireNonEmpty("fontName", fontName);
    }

    public int getTextFontSize() {
        return this.mTextFontSize;
    }

    public void setTextFontSize(int fontSize) throws InvalidInputException {
        this.mTextFontSize = this.requireNonNegative("fontSize", fontSize);
    }

    Integer requireNonNegative(String name, int value) throws InvalidInputException {
        Preconditions.requireNonNegative(name, value);
        return value;
    }

    String requireNonEmpty(String name, String value) throws InvalidInputException {
        Preconditions.requireNonEmpty(name, value);
        return value;
    }

    String requireHexColorCode(String hexColorCode) throws InvalidInputException {
        Integer n = Customization.parseHexColorCode(hexColorCode);
        Preconditions.requireNonNull("hexColorCode", n);
        return hexColorCode;
    }
}

