/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.voucher.internal.ui.view;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.StringRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.components.core.internal.util.AmountExtensionsKt;
import com.adyen.checkout.components.core.internal.util.ContextExtensionsKt;
import com.adyen.checkout.components.core.internal.util.CurrencyUtils;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.LogoSize;
import com.adyen.checkout.ui.core.internal.ui.view.RoundCornerImageView;
import com.adyen.checkout.ui.core.internal.util.CustomTabsLauncher;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.adyen.checkout.voucher.R;
import com.adyen.checkout.voucher.databinding.FullVoucherViewBinding;
import com.adyen.checkout.voucher.internal.ui.VoucherDelegate;
import com.adyen.checkout.voucher.internal.ui.model.VoucherInformationField;
import com.adyen.checkout.voucher.internal.ui.model.VoucherOutputData;
import com.adyen.checkout.voucher.internal.ui.model.VoucherStoreAction;
import com.adyen.checkout.voucher.internal.ui.model.VoucherUIEvent;
import com.adyen.checkout.voucher.internal.ui.view.VoucherInformationFieldsAdapter;
import com.google.android.material.button.MaterialButton;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J \u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0012\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0016H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\u0012\u0010,\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0012\u0010/\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u00100\u001a\u00020\u00142\u000e\u00101\u001a\n\u0012\u0004\u0012\u000203\u0018\u000102H\u0002J\u0019\u00104\u001a\u00020\u00142\n\b\u0001\u00105\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u00106J\u0012\u00107\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u00010;H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/adyen/checkout/voucher/internal/ui/view/FullVoucherView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/voucher/databinding/FullVoucherViewBinding;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "delegate", "Lcom/adyen/checkout/voucher/internal/ui/VoucherDelegate;", "informationFieldsAdapter", "Lcom/adyen/checkout/voucher/internal/ui/view/VoucherInformationFieldsAdapter;", "localizedContext", "copyCode", "", "codeReference", "", "getView", "Landroid/view/View;", "handleEventFlow", "event", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherUIEvent;", "hideButtons", "highlightValidationErrors", "initLocalizedStrings", "initView", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "loadLogo", "paymentMethodType", "observeDelegate", "onDownloadPdfClicked", "onReadInstructionsClicked", "url", "onSaveAsImageClicked", "outputDataChanged", "outputData", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherOutputData;", "showButtons", "updateAmount", "amount", "Lcom/adyen/checkout/components/core/Amount;", "updateCodeReference", "updateInformationFields", "informationFields", "", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherInformationField;", "updateIntroductionText", "introductionTextResource", "(Ljava/lang/Integer;)V", "updateReadInstructionTextView", "instructionUrl", "updateStoreAction", "storeAction", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherStoreAction;", "Companion", "voucher_release"})
@SourceDebugExtension(value={"SMAP\nFullVoucherView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullVoucherView.kt\ncom/adyen/checkout/voucher/internal/ui/view/FullVoucherView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 4 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,259:1\n1#2:260\n16#3,17:261\n16#3,17:294\n16#3,17:311\n256#4,2:278\n256#4,2:280\n256#4,2:282\n256#4,2:284\n256#4,2:286\n256#4,2:288\n37#4:290\n53#4:291\n256#4,2:292\n256#4,2:328\n256#4,2:330\n*S KotlinDebug\n*F\n+ 1 FullVoucherView.kt\ncom/adyen/checkout/voucher/internal/ui/view/FullVoucherView\n*L\n121#1:261,17\n208#1:294,17\n210#1:311,17\n153#1:278,2\n156#1:280,2\n164#1:282,2\n165#1:284,2\n169#1:286,2\n170#1:288,2\n188#1:290\n188#1:291\n195#1:292,2\n215#1:328,2\n220#1:330,2\n*E\n"})
public final class FullVoucherView
extends ConstraintLayout
implements ComponentView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FullVoucherViewBinding binding;
    private Context localizedContext;
    private VoucherDelegate delegate;
    @Nullable
    private VoucherInformationFieldsAdapter informationFieldsAdapter;
    @Nullable
    private CoroutineScope coroutineScope;
    @NotNull
    private static final String COPY_LABEL = "Voucher code reference";

    @JvmOverloads
    public FullVoucherView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        FullVoucherViewBinding fullVoucherViewBinding = FullVoucherViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)fullVoucherViewBinding, (String)"inflate(...)");
        this.binding = fullVoucherViewBinding;
        int padding = (int)this.getResources().getDimension(R.dimen.standard_margin);
        this.setPadding(padding, padding, padding, padding);
    }

    public /* synthetic */ FullVoucherView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof VoucherDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.delegate = (VoucherDelegate)delegate;
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.observeDelegate((VoucherDelegate)delegate, coroutineScope);
        this.coroutineScope = coroutineScope;
        this.binding.buttonCopyCode.setOnClickListener(arg_0 -> FullVoucherView.initView$lambda$1(this, delegate, arg_0));
        this.binding.buttonDownloadPdf.setOnClickListener(arg_0 -> FullVoucherView.initView$lambda$2(this, arg_0));
        this.binding.buttonSaveImage.setOnClickListener(arg_0 -> FullVoucherView.initView$lambda$3(this, arg_0));
    }

    private final void initLocalizedStrings(Context localizedContext) {
        FullVoucherViewBinding $this$initLocalizedStrings_u24lambda_u244 = this.binding;
        boolean bl = false;
        TextView textView = $this$initLocalizedStrings_u24lambda_u244.textViewPaymentReference;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewPaymentReference");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)textView, (int)R.style.AdyenCheckout_Voucher_PaymentReference, (Context)localizedContext, (boolean)false, (int)4, null);
        MaterialButton materialButton = $this$initLocalizedStrings_u24lambda_u244.buttonCopyCode;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonCopyCode");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)materialButton), (int)R.style.AdyenCheckout_Voucher_Button_CopyCode, (Context)localizedContext, (boolean)false, (int)4, null);
        MaterialButton materialButton2 = $this$initLocalizedStrings_u24lambda_u244.buttonDownloadPdf;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton2, (String)"buttonDownloadPdf");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)materialButton2), (int)R.style.AdyenCheckout_Voucher_Button_DownloadPdf, (Context)localizedContext, (boolean)false, (int)4, null);
        MaterialButton materialButton3 = $this$initLocalizedStrings_u24lambda_u244.buttonSaveImage;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton3, (String)"buttonSaveImage");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)materialButton3), (int)R.style.AdyenCheckout_Voucher_Button_SaveImage, (Context)localizedContext, (boolean)false, (int)4, null);
    }

    private final void observeDelegate(VoucherDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<VoucherOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullVoucherView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        VoucherOutputData it = (VoucherOutputData)this.L$0;
                        FullVoucherView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull VoucherOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach(delegate.getEventFlow(), (Function2)((Function2)new Function2<VoucherUIEvent, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullVoucherView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        VoucherUIEvent it = (VoucherUIEvent)this.L$0;
                        FullVoucherView.access$handleEventFlow(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull VoucherUIEvent p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void outputDataChanged(VoucherOutputData outputData) {
        FullVoucherView fullVoucherView = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "outputDataChanged";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        this.loadLogo(outputData.getPaymentMethodType());
        this.updateIntroductionText(outputData.getIntroductionTextResource());
        this.updateAmount(outputData.getTotalAmount());
        this.updateCodeReference(outputData.getReference());
        this.updateStoreAction(outputData.getStoreAction());
        this.updateInformationFields(outputData.getInformationFields());
        this.updateReadInstructionTextView(outputData.getInstructionUrl());
    }

    private final void loadLogo(String paymentMethodType) {
        CharSequence charSequence = paymentMethodType;
        if (!(charSequence == null || charSequence.length() == 0)) {
            RoundCornerImageView roundCornerImageView = this.binding.imageViewLogo;
            Intrinsics.checkNotNullExpressionValue((Object)roundCornerImageView, (String)"imageViewLogo");
            ImageView imageView = (ImageView)roundCornerImageView;
            VoucherDelegate voucherDelegate = this.delegate;
            if (voucherDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                voucherDelegate = null;
            }
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)voucherDelegate.getComponentParams().getEnvironment(), (String)paymentMethodType, null, (LogoSize)LogoSize.MEDIUM, null, (int)0, (int)0, (int)116, null);
        }
    }

    private final void updateIntroductionText(@StringRes Integer introductionTextResource) {
        if (introductionTextResource == null) {
            return;
        }
        TextView textView = this.binding.textViewIntroduction;
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        textView.setText((CharSequence)context.getString(introductionTextResource.intValue()));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAmount(Amount amount) {
        FullVoucherViewBinding $this$updateAmount_u24lambda_u246 = this.binding;
        boolean bl = false;
        if (amount != null && !AmountExtensionsKt.isEmpty((Amount)amount)) {
            void $this$isVisible$iv;
            VoucherDelegate voucherDelegate = this.delegate;
            if (voucherDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                voucherDelegate = null;
            }
            String formattedAmount = CurrencyUtils.INSTANCE.formatAmount(amount, voucherDelegate.getComponentParams().getShopperLocale());
            TextView textView = $this$updateAmount_u24lambda_u246.textViewAmount;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewAmount");
            View view = (View)textView;
            boolean value$iv = true;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            $this$updateAmount_u24lambda_u246.textViewAmount.setText((CharSequence)formattedAmount);
        } else {
            void $this$isVisible$iv;
            TextView textView = $this$updateAmount_u24lambda_u246.textViewAmount;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewAmount");
            View formattedAmount = (View)textView;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
    }

    private final void updateCodeReference(String codeReference) {
        FullVoucherViewBinding $this$updateCodeReference_u24lambda_u247 = this.binding;
        boolean bl = false;
        $this$updateCodeReference_u24lambda_u247.textViewReferenceCode.setText((CharSequence)codeReference);
        CharSequence charSequence = codeReference;
        boolean isVisible = !(charSequence == null || charSequence.length() == 0);
        TextView textView = $this$updateCodeReference_u24lambda_u247.textViewReferenceCode;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewReferenceCode");
        View $this$isVisible$iv = (View)textView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(isVisible ? 0 : 8);
        MaterialButton materialButton = $this$updateCodeReference_u24lambda_u247.buttonCopyCode;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonCopyCode");
        $this$isVisible$iv = (View)materialButton;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(isVisible ? 0 : 8);
    }

    private final void updateStoreAction(VoucherStoreAction storeAction) {
        View $this$isVisible$iv;
        FullVoucherViewBinding $this$updateStoreAction_u24lambda_u248 = this.binding;
        boolean bl = false;
        MaterialButton materialButton = $this$updateStoreAction_u24lambda_u248.buttonDownloadPdf;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonDownloadPdf");
        View view = (View)materialButton;
        boolean value$iv = storeAction instanceof VoucherStoreAction.DownloadPdf;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        MaterialButton materialButton2 = $this$updateStoreAction_u24lambda_u248.buttonSaveImage;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton2, (String)"buttonSaveImage");
        $this$isVisible$iv = (View)materialButton2;
        value$iv = storeAction instanceof VoucherStoreAction.SaveAsImage;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }

    private final void updateInformationFields(List<VoucherInformationField> informationFields) {
        block3: {
            Collection collection = informationFields;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            if (this.informationFieldsAdapter == null) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                Context context2 = this.localizedContext;
                if (context2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context2 = null;
                }
                this.informationFieldsAdapter = new VoucherInformationFieldsAdapter(context, context2);
                this.binding.recyclerViewInformationFields.setAdapter((RecyclerView.Adapter)this.informationFieldsAdapter);
            }
            VoucherInformationFieldsAdapter voucherInformationFieldsAdapter = this.informationFieldsAdapter;
            if (voucherInformationFieldsAdapter == null) break block3;
            voucherInformationFieldsAdapter.submitList(informationFields);
        }
    }

    private final void onDownloadPdfClicked() {
        VoucherDelegate voucherDelegate = this.delegate;
        if (voucherDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            voucherDelegate = null;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        voucherDelegate.downloadVoucher(context);
    }

    private final void onSaveAsImageClicked() {
        this.hideButtons();
        View $this$doOnNextLayout$iv = (View)this;
        boolean $i$f$doOnNextLayout = false;
        $this$doOnNextLayout$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
            final /* synthetic */ FullVoucherView this$0;
            {
                this.this$0 = fullVoucherView;
            }

            public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                View it = view;
                boolean bl = false;
                VoucherDelegate voucherDelegate = FullVoucherView.access$getDelegate$p(this.this$0);
                if (voucherDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    voucherDelegate = null;
                }
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                voucherDelegate.saveVoucherAsImage(context, (View)this.this$0);
                FullVoucherView.access$showButtons(this.this$0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateReadInstructionTextView(String instructionUrl) {
        block1: {
            void $this$isVisible$iv;
            TextView textView = this.binding.textViewReadInstructions;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewReadInstructions");
            View view = (View)textView;
            boolean value$iv = instructionUrl != null;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            String string2 = instructionUrl;
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            TextView textView2 = this.binding.textViewReadInstructions;
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string3 = context.getString(R.string.checkout_voucher_read_instructions);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            textView2.setText(ViewExtensionsKt.formatFullStringWithHyperLink((String)string3));
            this.binding.textViewReadInstructions.setOnClickListener(arg_0 -> FullVoucherView.updateReadInstructionTextView$lambda$11$lambda$10(this, instructionUrl, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onReadInstructionsClicked(String url) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
        boolean isLaunched = CustomTabsLauncher.INSTANCE.launchCustomTab(context, uri);
        if (isLaunched) {
            FullVoucherView fullVoucherView = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "Successfully opened instructions in custom tab";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
        } else {
            FullVoucherView $this$adyenLog_u24default$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = ((Object)((Object)$this$adyenLog_u24default$iv)).getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string5 = "Couldn't open instructions in custom tab";
                adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hideButtons() {
        void $this$isVisible$iv;
        FullVoucherViewBinding $this$hideButtons_u24lambda_u2414 = this.binding;
        boolean bl = false;
        MaterialButton materialButton = $this$hideButtons_u24lambda_u2414.buttonCopyCode;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonCopyCode");
        View view = (View)materialButton;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.updateStoreAction(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void showButtons() {
        void $this$isVisible$iv;
        FullVoucherViewBinding $this$showButtons_u24lambda_u2415 = this.binding;
        boolean bl = false;
        MaterialButton materialButton = $this$showButtons_u24lambda_u2415.buttonCopyCode;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonCopyCode");
        View view = (View)materialButton;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        VoucherDelegate voucherDelegate = this.delegate;
        if (voucherDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            voucherDelegate = null;
        }
        this.updateStoreAction(((VoucherOutputData)voucherDelegate.getOutputData()).getStoreAction());
    }

    private final void copyCode(String codeReference) {
        if (codeReference == null) {
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = this.localizedContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context2 = null;
        }
        ContextExtensionsKt.copyTextToClipboard((Context)context, (String)COPY_LABEL, (String)codeReference, (String)context2.getString(R.string.checkout_voucher_copied_toast));
    }

    private final void handleEventFlow(VoucherUIEvent event) {
        VoucherUIEvent voucherUIEvent = event;
        if (Intrinsics.areEqual((Object)voucherUIEvent, (Object)VoucherUIEvent.Success.INSTANCE)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context2 = this.localizedContext;
            if (context2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context2 = null;
            }
            String string2 = context2.getString(R.string.checkout_voucher_image_saved);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string2, (int)0, (int)2, null);
        } else if (Intrinsics.areEqual((Object)voucherUIEvent, (Object)VoucherUIEvent.PermissionDenied.INSTANCE)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context3 = this.localizedContext;
            if (context3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context3 = null;
            }
            String string3 = context3.getString(R.string.checkout_voucher_permission_denied);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string3, (int)0, (int)2, null);
        } else if (voucherUIEvent instanceof VoucherUIEvent.Failure) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context4 = this.localizedContext;
            if (context4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context4 = null;
            }
            String string4 = context4.getString(R.string.checkout_voucher_image_failed);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string4, (int)0, (int)2, null);
        }
    }

    public void highlightValidationErrors() {
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    @JvmOverloads
    public FullVoucherView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public FullVoucherView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initView$lambda$1(FullVoucherView this$0, ComponentDelegate $delegate, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        this$0.copyCode(((VoucherOutputData)((VoucherDelegate)$delegate).getOutputData()).getReference());
    }

    private static final void initView$lambda$2(FullVoucherView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onDownloadPdfClicked();
    }

    private static final void initView$lambda$3(FullVoucherView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onSaveAsImageClicked();
    }

    private static final void updateReadInstructionTextView$lambda$11$lambda$10(FullVoucherView this$0, String $instructionUrl, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onReadInstructionsClicked($instructionUrl);
    }

    public static final /* synthetic */ void access$outputDataChanged(FullVoucherView $this, VoucherOutputData outputData) {
        $this.outputDataChanged(outputData);
    }

    public static final /* synthetic */ void access$handleEventFlow(FullVoucherView $this, VoucherUIEvent event) {
        $this.handleEventFlow(event);
    }

    public static final /* synthetic */ VoucherDelegate access$getDelegate$p(FullVoucherView $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ void access$showButtons(FullVoucherView $this) {
        $this.showButtons();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/voucher/internal/ui/view/FullVoucherView$Companion;", "", "()V", "COPY_LABEL", "", "voucher_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

