/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.voucher.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.VoucherAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.PermissionRequestData;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.ui.model.GenericComponentParams;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.internal.util.DateUtils;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.PermissionHandlerCallback;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.ui.PermissionHandler;
import com.adyen.checkout.ui.core.internal.exception.PermissionRequestException;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.util.ImageSaver;
import com.adyen.checkout.ui.core.internal.util.PdfOpener;
import com.adyen.checkout.voucher.internal.ui.VoucherDelegate;
import com.adyen.checkout.voucher.internal.ui.model.VoucherInformationField;
import com.adyen.checkout.voucher.internal.ui.model.VoucherOutputData;
import com.adyen.checkout.voucher.internal.ui.model.VoucherPaymentMethodConfig;
import com.adyen.checkout.voucher.internal.ui.model.VoucherPaymentMethodConfigKt;
import com.adyen.checkout.voucher.internal.ui.model.VoucherStoreAction;
import com.adyen.checkout.voucher.internal.ui.model.VoucherUIEvent;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 ]2\u00020\u00012\u00020\u0002:\u0001]B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020\u0014H\u0002J\u0018\u0010?\u001a\u00020>2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020-H\u0002J\u0018\u0010G\u001a\u00020>2\u0006\u0010\u0019\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020>2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010L\u001a\u00020>2\u0006\u0010\"\u001a\u00020\u0011H\u0016J,\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020O2\u0006\u0010\"\u001a\u00020\u00112\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020>0QH\u0016J\b\u0010S\u001a\u00020>H\u0016J\b\u0010T\u001a\u00020>H\u0016J \u0010U\u001a\u00020>2\u0006\u0010C\u001a\u00020D2\u0006\u0010V\u001a\u00020W2\u0006\u0010P\u001a\u00020XH\u0016J\b\u0010Y\u001a\u00020>H\u0002J\u0018\u0010Z\u001a\u00020>2\u0006\u0010C\u001a\u00020D2\u0006\u0010[\u001a\u00020\\H\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020-0)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00140)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010+R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\b\u0012\u0004\u0012\u0002060)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010+R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001c\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010+\u00a8\u0006^"}, d2={"Lcom/adyen/checkout/voucher/internal/ui/DefaultVoucherDelegate;", "Lcom/adyen/checkout/voucher/internal/ui/VoucherDelegate;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "pdfOpener", "Lcom/adyen/checkout/ui/core/internal/util/PdfOpener;", "imageSaver", "Lcom/adyen/checkout/ui/core/internal/util/ImageSaver;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;Lcom/adyen/checkout/ui/core/internal/util/PdfOpener;Lcom/adyen/checkout/ui/core/internal/util/ImageSaver;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "_outputDataFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherOutputData;", "_viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "<set-?>", "Lcom/adyen/checkout/components/core/action/VoucherAction;", "action", "getAction", "()Lcom/adyen/checkout/components/core/action/VoucherAction;", "setAction", "(Lcom/adyen/checkout/components/core/action/VoucherAction;)V", "action$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "eventChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherUIEvent;", "eventFlow", "Lkotlinx/coroutines/flow/Flow;", "getEventFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "outputData", "getOutputData", "()Lcom/adyen/checkout/voucher/internal/ui/model/VoucherOutputData;", "outputDataFlow", "getOutputDataFlow", "permissionChannel", "Lcom/adyen/checkout/components/core/internal/PermissionRequestData;", "permissionFlow", "getPermissionFlow", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "viewFlow", "getViewFlow", "clearState", "", "createOutputData", "config", "Lcom/adyen/checkout/voucher/internal/ui/model/VoucherPaymentMethodConfig;", "downloadVoucher", "context", "Landroid/content/Context;", "emitError", "e", "handleAction", "Lcom/adyen/checkout/components/core/action/Action;", "activity", "Landroid/app/Activity;", "initState", "initialize", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "onCleared", "removeObserver", "requestPermission", "requiredPermission", "", "Lcom/adyen/checkout/core/PermissionHandlerCallback;", "restoreState", "saveVoucherAsImage", "view", "Landroid/view/View;", "Companion", "voucher_release"})
@SourceDebugExtension(value={"SMAP\nDefaultVoucherDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVoucherDelegate.kt\ncom/adyen/checkout/voucher/internal/ui/DefaultVoucherDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,239:1\n16#2,17:240\n*S KotlinDebug\n*F\n+ 1 DefaultVoucherDelegate.kt\ncom/adyen/checkout/voucher/internal/ui/DefaultVoucherDelegate\n*L\n89#1:240,17\n*E\n"})
public final class DefaultVoucherDelegate
implements VoucherDelegate,
SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final GenericComponentParams componentParams;
    @NotNull
    private final PdfOpener pdfOpener;
    @NotNull
    private final ImageSaver imageSaver;
    @Nullable
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final MutableStateFlow<VoucherOutputData> _outputDataFlow;
    @NotNull
    private final Flow<VoucherOutputData> outputDataFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Channel<PermissionRequestData> permissionChannel;
    @NotNull
    private final Flow<PermissionRequestData> permissionFlow;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Channel<VoucherUIEvent> eventChannel;
    @NotNull
    private final Flow<VoucherUIEvent> eventFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @NotNull
    private final SavedStateHandleProperty action$delegate;
    @NotNull
    private static final String IMAGE_NAME_FORMAT = "%s-%s.png";
    @NotNull
    public static final String ACTION_KEY = "ACTION_KEY";

    public DefaultVoucherDelegate(@NotNull ActionObserverRepository observerRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull GenericComponentParams componentParams, @NotNull PdfOpener pdfOpener, @NotNull ImageSaver imageSaver, @Nullable AnalyticsManager analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)pdfOpener, (String)"pdfOpener");
        Intrinsics.checkNotNullParameter((Object)imageSaver, (String)"imageSaver");
        this.observerRepository = observerRepository;
        this.savedStateHandle = savedStateHandle;
        this.componentParams = componentParams;
        this.pdfOpener = pdfOpener;
        this.imageSaver = imageSaver;
        this.analyticsManager = analyticsManager;
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.permissionChannel = ChannelExtensionsKt.bufferedChannel();
        this.permissionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.permissionChannel));
        this._viewFlow = StateFlowKt.MutableStateFlow(null);
        this.viewFlow = (Flow)this._viewFlow;
        this.eventChannel = ChannelExtensionsKt.bufferedChannel();
        this.eventFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.eventChannel));
        this.action$delegate = new SavedStateHandleProperty(ACTION_KEY);
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    @NotNull
    public GenericComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public Flow<VoucherOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<PermissionRequestData> getPermissionFlow() {
        return this.permissionFlow;
    }

    @NotNull
    public VoucherOutputData getOutputData() {
        return (VoucherOutputData)this._outputDataFlow.getValue();
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @Override
    @NotNull
    public Flow<VoucherUIEvent> getEventFlow() {
        return this.eventFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return coroutineScope;
    }

    private final VoucherAction getAction() {
        return (VoucherAction)this.action$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setAction(VoucherAction voucherAction) {
        this.action$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)voucherAction);
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this._coroutineScope = coroutineScope;
        this.restoreState();
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreState() {
        DefaultVoucherDelegate defaultVoucherDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "Restoring state";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        VoucherAction action = this.getAction();
        if (action != null) {
            this.initState(action);
        }
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(null, this.getExceptionFlow(), this.getPermissionFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!(action instanceof VoucherAction)) {
            this.emitError((CheckoutException)new ComponentException("Unsupported action", null, 2, null));
            return;
        }
        this.setAction((VoucherAction)action);
        String string2 = action.getPaymentMethodType();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = action.getType()) == null) {
            string = "";
        }
        AnalyticsEvent.Log event = GenericEvents.action$default((GenericEvents)GenericEvents.INSTANCE, (String)string2, (String)string, null, (int)4, null);
        AnalyticsManager analyticsManager = this.analyticsManager;
        if (analyticsManager != null) {
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
        this.initState((VoucherAction)action);
    }

    private final void initState(VoucherAction action) {
        VoucherPaymentMethodConfig config = VoucherPaymentMethodConfig.Companion.getByPaymentMethodType(action.getPaymentMethodType());
        if (config == null) {
            this.emitError((CheckoutException)new ComponentException("Payment method " + action.getPaymentMethodType() + " not supported for this action", null, 2, null));
            return;
        }
        this._viewFlow.tryEmit((Object)config.getViewType());
        this.createOutputData(action, config);
    }

    private final void createOutputData(VoucherAction action, VoucherPaymentMethodConfig config) {
        VoucherStoreAction voucherStoreAction;
        String downloadUrl;
        String string2 = action.getDownloadUrl();
        if (string2 == null) {
            string2 = action.getUrl();
        }
        String string3 = downloadUrl = string2;
        if (string3 != null) {
            String url = string3;
            boolean bl = false;
            voucherStoreAction = new VoucherStoreAction.DownloadPdf(url);
        } else {
            voucherStoreAction = VoucherStoreAction.SaveAsImage.INSTANCE;
        }
        VoucherStoreAction storeAction = voucherStoreAction;
        List<VoucherInformationField> informationFields = VoucherPaymentMethodConfigKt.getInformationFields(config, action, this.getComponentParams().getShopperLocale());
        VoucherOutputData outputData = new VoucherOutputData(true, action.getPaymentMethodType(), config.getIntroductionTextResource(), action.getReference(), action.getTotalAmount(), storeAction, action.getInstructionsUrl(), informationFields);
        this._outputDataFlow.tryEmit((Object)outputData);
    }

    private final VoucherOutputData createOutputData() {
        return new VoucherOutputData(false, null, null, null, null, null, null, null);
    }

    @Override
    public void downloadVoucher(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoucherStoreAction voucherStoreAction = this.getOutputData().getStoreAction();
        Object object = voucherStoreAction instanceof VoucherStoreAction.DownloadPdf ? (VoucherStoreAction.DownloadPdf)voucherStoreAction : null;
        if (object == null || (object = ((VoucherStoreAction.DownloadPdf)object).getDownloadUrl()) == null) {
            object = "";
        }
        Object downloadUrl = object;
        try {
            this.pdfOpener.open(context, (String)downloadUrl);
        }
        catch (IllegalStateException e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            this.emitError((CheckoutException)new ComponentException(string2, e.getCause()));
        }
    }

    @Override
    public void saveVoucherAsImage(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = this.getOutputData().getPaymentMethodType();
        if (string2 == null) {
            string2 = "";
        }
        String paymentMethodType = string2;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        String timestamp = DateUtils.formatDateToString$default((DateUtils)DateUtils.INSTANCE, (Calendar)calendar, null, (int)2, null);
        String string3 = IMAGE_NAME_FORMAT;
        Object[] objectArray = new Object[]{paymentMethodType, timestamp};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String imageName = string4;
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, context, view, imageName, null){
            int label;
            final /* synthetic */ DefaultVoucherDelegate this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ View $view;
            final /* synthetic */ String $imageName;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$view = $view;
                this.$imageName = $imageName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ImageSaver.saveImageFromView-bMdYcbs$default((ImageSaver)DefaultVoucherDelegate.access$getImageSaver$p(this.this$0), (Context)this.$context, (PermissionHandler)this.this$0, (View)this.$view, null, (String)this.$imageName, null, (Continuation)((Continuation)this), (int)40, null);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl13:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.this$0;
                        var4_5 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 == null) {
                            (Unit)var2_3;
                            $i$a$-fold-DefaultVoucherDelegate$saveVoucherAsImage$1$1 = false;
                            DefaultVoucherDelegate.access$getEventChannel$p(var3_4).trySend-JP2dKIU((Object)VoucherUIEvent.Success.INSTANCE);
                        } else {
                            throwable = v1;
                            $i$a$-fold-DefaultVoucherDelegate$saveVoucherAsImage$1$2 = false;
                            if (throwable instanceof PermissionRequestException) {
                                DefaultVoucherDelegate.access$getEventChannel$p(var4_5).trySend-JP2dKIU((Object)VoucherUIEvent.PermissionDenied.INSTANCE);
                            } else {
                                DefaultVoucherDelegate.access$getEventChannel$p(var4_5).trySend-JP2dKIU((Object)new VoucherUIEvent.Failure(throwable));
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void requestPermission(@NotNull Context context, @NotNull String requiredPermission, @NotNull PermissionHandlerCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)requiredPermission, (String)"requiredPermission");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PermissionRequestData requestData = new PermissionRequestData(requiredPermission, callback);
        this.permissionChannel.trySend-JP2dKIU((Object)requestData);
    }

    private final void emitError(CheckoutException e) {
        this.exceptionChannel.trySend-JP2dKIU((Object)e);
        this.clearState();
    }

    private final void clearState() {
        this.setAction(null);
    }

    public void onCleared() {
        this.removeObserver();
        this._coroutineScope = null;
    }

    public void onError(@NotNull CheckoutException e) {
        VoucherDelegate.DefaultImpls.onError(this, e);
    }

    public static final /* synthetic */ ImageSaver access$getImageSaver$p(DefaultVoucherDelegate $this) {
        return $this.imageSaver;
    }

    public static final /* synthetic */ Channel access$getEventChannel$p(DefaultVoucherDelegate $this) {
        return $this.eventChannel;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DefaultVoucherDelegate.class, "action", "getAction()Lcom/adyen/checkout/components/core/action/VoucherAction;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/voucher/internal/ui/DefaultVoucherDelegate$Companion;", "", "()V", "ACTION_KEY", "", "getACTION_KEY$voucher_release$annotations", "IMAGE_NAME_FORMAT", "voucher_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_KEY$voucher_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

