/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.ui.core.R;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0019\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/SocialSecurityNumberUtils;", "", "()V", "CNPJ_DIGIT_LIMIT", "", "CNPJ_MASK_GROUPING", "", "CNPJ_MASK_SEPARATORS", "", "getCNPJ_MASK_SEPARATORS", "()Ljava/util/List;", "CNPJ_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CNPJ_REGEX", "", "CPF_DIGIT_LIMIT", "CPF_MASK_GROUPING", "CPF_MASK_SEPARATORS", "CPF_PATTERN", "CPF_REGEX", "formatInput", "inputString", "validateSocialSecurityNumber", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "socialSecurityNumber", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nSocialSecurityNumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocialSecurityNumberUtils.kt\ncom/adyen/checkout/ui/core/internal/util/SocialSecurityNumberUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n434#2:75\n507#2,5:76\n434#2:81\n507#2,5:82\n434#2:87\n507#2,5:88\n1872#3,3:93\n*S KotlinDebug\n*F\n+ 1 SocialSecurityNumberUtils.kt\ncom/adyen/checkout/ui/core/internal/util/SocialSecurityNumberUtils\n*L\n34#1:75\n34#1:76,5\n40#1:81\n40#1:82,5\n44#1:87\n44#1:88,5\n64#1:93,3\n*E\n"})
public final class SocialSecurityNumberUtils {
    @NotNull
    public static final SocialSecurityNumberUtils INSTANCE = new SocialSecurityNumberUtils();
    private static final int CPF_DIGIT_LIMIT = 11;
    @NotNull
    private static final String CPF_REGEX = "\\d{3}\\.\\d{3}\\.\\d{3}-\\d{2}";
    private static final Pattern CPF_PATTERN = Pattern.compile("\\d{3}\\.\\d{3}\\.\\d{3}-\\d{2}");
    @NotNull
    private static final List<Integer> CPF_MASK_GROUPING;
    @NotNull
    private static final List<Character> CPF_MASK_SEPARATORS;
    public static final int CNPJ_DIGIT_LIMIT = 14;
    @NotNull
    private static final String CNPJ_REGEX = "\\d{2}\\.\\d{3}\\.\\d{3}/\\d{4}-\\d{2}";
    private static final Pattern CNPJ_PATTERN;
    @NotNull
    private static final List<Integer> CNPJ_MASK_GROUPING;
    @NotNull
    private static final List<Character> CNPJ_MASK_SEPARATORS;

    private SocialSecurityNumberUtils() {
    }

    @NotNull
    public final List<Character> getCNPJ_MASK_SEPARATORS() {
        return CNPJ_MASK_SEPARATORS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FieldState<String> validateSocialSecurityNumber(@NotNull String socialSecurityNumber) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)socialSecurityNumber, (String)"socialSecurityNumber");
        String $this$filter$iv = socialSecurityNumber;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv2.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        int digitLength = string2.length();
        Validation validation = digitLength == 11 && CPF_PATTERN.matcher(socialSecurityNumber).matches() ? (Validation)Validation.Valid.INSTANCE : (digitLength == 14 && CNPJ_PATTERN.matcher(socialSecurityNumber).matches() ? (Validation)Validation.Valid.INSTANCE : (Validation)new Validation.Invalid(R.string.checkout_social_security_number_not_valid, false, 2, null));
        String $this$filter$iv2 = socialSecurityNumber;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Appendable destination$iv$iv2 = new StringBuilder();
        boolean $i$f$filterTo2 = false;
        int n2 = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv2.append(element$iv$iv);
        }
        String string3 = ((StringBuilder)destination$iv$iv2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Validation validation2 = validation;
        String string4 = string3;
        return new FieldState((Object)string4, validation2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatInput(@NotNull String inputString) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        String $this$filter$iv = inputString;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String trimmedInput = string2;
        List result = new ArrayList();
        StringBuilder resultBuilder = new StringBuilder();
        charSequence = trimmedInput.length() <= 11 ? TuplesKt.to(CPF_MASK_GROUPING, CPF_MASK_SEPARATORS) : TuplesKt.to(CNPJ_MASK_GROUPING, CNPJ_MASK_SEPARATORS);
        List grouping = (List)charSequence.component1();
        List separators = (List)charSequence.component2();
        n = grouping.size();
        for (int index = 0; index < n; ++index) {
            if (trimmedInput.length() >= ((Number)grouping.get(index)).intValue()) {
                result.add(StringsKt.take((String)trimmedInput, (int)((Number)grouping.get(index)).intValue()));
                Intrinsics.checkNotNullExpressionValue((Object)trimmedInput.substring(((Number)grouping.get(index)).intValue()), (String)"substring(...)");
                continue;
            }
            if (!(((CharSequence)trimmedInput).length() > 0)) continue;
            result.add(trimmedInput);
            break;
        }
        Iterable $this$forEachIndexed$iv = result;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void resultPart;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string3 = (String)item$iv;
            int index = n2;
            boolean bl = false;
            resultBuilder.append((String)resultPart);
            if (index == CollectionsKt.getLastIndex((List)result)) continue;
            resultBuilder.append(((Character)separators.get(index)).charValue());
        }
        String string4 = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    static {
        Object[] objectArray = new Integer[]{3, 3, 3, 2};
        CPF_MASK_GROUPING = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('-')};
        CPF_MASK_SEPARATORS = CollectionsKt.listOf((Object[])objectArray);
        CNPJ_PATTERN = Pattern.compile(CNPJ_REGEX);
        objectArray = new Integer[]{2, 3, 3, 4, 2};
        CNPJ_MASK_GROUPING = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('-')};
        CNPJ_MASK_SEPARATORS = CollectionsKt.listOf((Object[])objectArray);
    }
}

