/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.ui.core.internal.util.CustomTabsLauncher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/PdfOpener;", "", "()V", "open", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "", "url", "", "openInBrowser", "openInCustomTab", "openInExternalApp", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nPdfOpener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfOpener.kt\ncom/adyen/checkout/ui/core/internal/util/PdfOpener\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,90:1\n16#2,17:91\n16#2,17:108\n21#2,12:125\n16#2,17:137\n16#2,17:154\n16#2,17:171\n21#2,12:188\n*S KotlinDebug\n*F\n+ 1 PdfOpener.kt\ncom/adyen/checkout/ui/core/internal/util/PdfOpener\n*L\n29#1:91,17\n54#1:108,17\n57#1:125,12\n66#1:137,17\n68#1:154,17\n82#1:171,17\n85#1:188,12\n*E\n"})
public final class PdfOpener {
    /*
     * WARNING - void declaration
     */
    public final void open(@NotNull Context context, @NotNull String url) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNull((Object)uri);
        if (this.open(context, uri)) {
            return;
        }
        if (this.openInBrowser(context, uri)) {
            return;
        }
        PdfOpener pdfOpener = this;
        AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "Couldn't open pdf with url: " + uri;
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        throw new IllegalStateException(("Couldn't open pdf with url: " + uri).toString());
    }

    private final boolean open(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 30 ? (this.openInExternalApp(context, uri) ? true : this.openInCustomTab(context, uri)) : this.openInCustomTab(context, uri);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean openInExternalApp(Context context, Uri uri) {
        boolean bl;
        Object object;
        Intent $this$openInExternalApp_u24lambda_u241 = object = new Intent();
        boolean bl2 = false;
        $this$openInExternalApp_u24lambda_u241.setAction("android.intent.action.VIEW");
        $this$openInExternalApp_u24lambda_u241.setDataAndType(uri, "application/pdf");
        Intent nativeAppIntent = object;
        try {
            context.startActivity(nativeAppIntent);
            object = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl3 = false;
                String string3 = "Successfully opened pdf in external app";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            PdfOpener throwable$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl4 = false;
                String string5 = "Couldn't open pdf in external app";
                adyenLogger.log(adyenLogLevel, string4, string5, (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean openInCustomTab(Context context, Uri uri) {
        boolean isLaunched = CustomTabsLauncher.INSTANCE.launchCustomTab(context, uri);
        if (isLaunched) {
            PdfOpener pdfOpener = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "Successfully opened pdf in custom tab";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
        } else {
            PdfOpener $this$adyenLog_u24default$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string5 = "Couldn't open pdf in custom tab";
                adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv);
            }
        }
        return isLaunched;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean openInBrowser(Context context, Uri uri) {
        boolean bl;
        try {
            Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").addFlags(0x10000000).setData(uri);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
            Intent browserActivityIntent = intent;
            context.startActivity(browserActivityIntent);
            PdfOpener pdfOpener = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string3 = "Successfully opened pdf in browser";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            PdfOpener level$iv = this;
            AdyenLogLevel level$iv2 = AdyenLogLevel.DEBUG;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv2;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl3 = false;
                String string5 = "Couldn't open pdf in browser";
                adyenLogger.log(adyenLogLevel, string4, string5, (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }
}

