/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import androidx.annotation.AttrRes;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import com.adyen.checkout.ui.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/CustomTabsLauncher;", "", "()V", "getDefaultColorSchemeParams", "Landroidx/browser/customtabs/CustomTabColorSchemeParams;", "context", "Landroid/content/Context;", "launchCustomTab", "", "uri", "Landroid/net/Uri;", "getColorOrNull", "", "attribute", "(Landroid/content/Context;I)Ljava/lang/Integer;", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCustomTabsLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomTabsLauncher.kt\ncom/adyen/checkout/ui/core/internal/util/CustomTabsLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class CustomTabsLauncher {
    @NotNull
    public static final CustomTabsLauncher INSTANCE = new CustomTabsLauncher();

    private CustomTabsLauncher() {
    }

    public final boolean launchCustomTab(@NotNull Context context, @NotNull Uri uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            new CustomTabsIntent.Builder().setShowTitle(true).setDefaultColorSchemeParams(this.getDefaultColorSchemeParams(context)).build().launchUrl(context, uri);
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final CustomTabColorSchemeParams getDefaultColorSchemeParams(Context context) {
        int it;
        CustomTabColorSchemeParams.Builder builder;
        Integer toolbarColor = this.getColorOrNull(context, R.attr.adyenCustomTabsToolbarColor);
        Integer secondaryToolbarColor = this.getColorOrNull(context, R.attr.adyenCustomTabsSecondaryToolbarColor);
        Integer navigationBarColor = this.getColorOrNull(context, R.attr.adyenCustomTabsNavigationBarColor);
        Integer navigationBarDividerColor = this.getColorOrNull(context, R.attr.adyenCustomTabsNavigationBarDividerColor);
        CustomTabColorSchemeParams.Builder $this$getDefaultColorSchemeParams_u24lambda_u244 = builder = new CustomTabColorSchemeParams.Builder();
        boolean bl = false;
        Integer n = toolbarColor;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getDefaultColorSchemeParams_u24lambda_u244.setToolbarColor(it);
        }
        Integer n2 = secondaryToolbarColor;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl3 = false;
            $this$getDefaultColorSchemeParams_u24lambda_u244.setSecondaryToolbarColor(it);
        }
        Integer n3 = navigationBarColor;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl4 = false;
            $this$getDefaultColorSchemeParams_u24lambda_u244.setNavigationBarColor(it);
        }
        Integer n4 = navigationBarDividerColor;
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl5 = false;
            $this$getDefaultColorSchemeParams_u24lambda_u244.setNavigationBarDividerColor(it);
        }
        CustomTabColorSchemeParams customTabColorSchemeParams = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"build(...)");
        return customTabColorSchemeParams;
    }

    private final Integer getColorOrNull(Context $this$getColorOrNull, @AttrRes int attribute) {
        Object object = new int[]{attribute};
        TypedArray typedArray = $this$getColorOrNull.obtainStyledAttributes(R.style.AdyenCheckout_CustomTabs, object);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        object = typedArray2.getColor(0, -1);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object color = (int[])(it != -1 ? object : null);
        typedArray2.recycle();
        return color;
    }
}

