/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.internal.ui.model.AddressInputModel;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.AddressFormUIState;
import com.adyen.checkout.ui.core.internal.ui.AddressSpecification;
import com.adyen.checkout.ui.core.internal.ui.model.AddressListItem;
import com.adyen.checkout.ui.core.internal.ui.model.AddressOutputData;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J:\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\fJ4\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J4\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/AddressValidationUtils;", "", "()V", "makeValidEmptyAddressOutput", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressOutputData;", "addressInputModel", "Lcom/adyen/checkout/components/core/internal/ui/model/AddressInputModel;", "validateAddressField", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "", "input", "shouldValidate", "", "validateAddressInput", "addressFormUIState", "Lcom/adyen/checkout/ui/core/internal/ui/AddressFormUIState;", "countryOptions", "", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressListItem;", "stateOptions", "isOptional", "validatePostalCode", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AddressValidationUtils {
    @NotNull
    public static final AddressValidationUtils INSTANCE = new AddressValidationUtils();

    private AddressValidationUtils() {
    }

    @NotNull
    public final AddressOutputData validateAddressInput(@NotNull AddressInputModel addressInputModel, @NotNull AddressFormUIState addressFormUIState, @NotNull List<AddressListItem> countryOptions, @NotNull List<AddressListItem> stateOptions, boolean isOptional) {
        AddressOutputData addressOutputData;
        Intrinsics.checkNotNullParameter((Object)addressInputModel, (String)"addressInputModel");
        Intrinsics.checkNotNullParameter((Object)((Object)addressFormUIState), (String)"addressFormUIState");
        Intrinsics.checkNotNullParameter(countryOptions, (String)"countryOptions");
        Intrinsics.checkNotNullParameter(stateOptions, (String)"stateOptions");
        switch (WhenMappings.$EnumSwitchMapping$0[addressFormUIState.ordinal()]) {
            case 1: 
            case 2: {
                addressOutputData = this.validateAddressInput(addressInputModel, isOptional, countryOptions, stateOptions);
                break;
            }
            case 3: {
                addressOutputData = this.validatePostalCode(addressInputModel, isOptional, countryOptions, stateOptions);
                break;
            }
            default: {
                addressOutputData = this.makeValidEmptyAddressOutput(addressInputModel);
            }
        }
        return addressOutputData;
    }

    private final AddressOutputData validatePostalCode(AddressInputModel addressInputModel, boolean isOptional, List<AddressListItem> countryOptions, List<AddressListItem> stateOptions) {
        AddressInputModel $this$validatePostalCode_u24lambda_u240 = addressInputModel;
        boolean bl = false;
        return new AddressOutputData(INSTANCE.validateAddressField($this$validatePostalCode_u24lambda_u240.getPostalCode(), !isOptional), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getStreet(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getStateOrProvince(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getHouseNumberOrName(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getApartmentSuite(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getCity(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$validatePostalCode_u24lambda_u240.getCountry(), (Validation)Validation.Valid.INSTANCE), isOptional, countryOptions, stateOptions);
    }

    private final AddressOutputData validateAddressInput(AddressInputModel addressInputModel, boolean isOptional, List<AddressListItem> countryOptions, List<AddressListItem> stateOptions) {
        AddressSpecification spec = AddressSpecification.Companion.fromString(addressInputModel.getCountry());
        AddressInputModel $this$validateAddressInput_u24lambda_u241 = addressInputModel;
        boolean bl = false;
        return new AddressOutputData(INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getPostalCode(), spec.getPostalCode$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getStreet(), spec.getStreet$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getStateOrProvince(), spec.getStateProvince$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getHouseNumberOrName(), spec.getHouseNumber$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getApartmentSuite(), spec.getApartmentSuite$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getCity(), spec.getCity$ui_core_release().isRequired() && !isOptional), INSTANCE.validateAddressField($this$validateAddressInput_u24lambda_u241.getCountry(), spec.getCountry$ui_core_release().isRequired() && !isOptional), isOptional, countryOptions, stateOptions);
    }

    @NotNull
    public final AddressOutputData makeValidEmptyAddressOutput(@NotNull AddressInputModel addressInputModel) {
        Intrinsics.checkNotNullParameter((Object)addressInputModel, (String)"addressInputModel");
        AddressInputModel $this$makeValidEmptyAddressOutput_u24lambda_u242 = addressInputModel;
        boolean bl = false;
        return new AddressOutputData((FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getPostalCode(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getStreet(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getStateOrProvince(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getHouseNumberOrName(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getApartmentSuite(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getCity(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$makeValidEmptyAddressOutput_u24lambda_u242.getCountry(), (Validation)Validation.Valid.INSTANCE), true, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private final FieldState<String> validateAddressField(String input, boolean shouldValidate) {
        return ((CharSequence)input).length() > 0 || !shouldValidate ? new FieldState((Object)input, (Validation)Validation.Valid.INSTANCE) : new FieldState((Object)input, (Validation)new Validation.Invalid(R.string.checkout_address_form_field_not_valid, false, 2, null));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressFormUIState.values().length];
            try {
                nArray[AddressFormUIState.FULL_ADDRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressFormUIState.LOOKUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressFormUIState.POSTAL_CODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

