/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui.view;

import android.content.Context;
import android.text.Editable;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import com.adyen.checkout.ui.core.internal.util.SocialSecurityNumberUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/SocialSecurityNumberInput;", "Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "afterTextChanged", "", "editable", "Landroid/text/Editable;", "setSocialSecurityNumber", "socialSecurityNumber", "", "Companion", "ui-core_release"})
public final class SocialSecurityNumberInput
extends AdyenTextInputEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SUPPORTED_CHARS = "0123456789./-";

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SocialSecurityNumberInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.enforceMaxInputLength(14 + SocialSecurityNumberUtils.INSTANCE.getCNPJ_MASK_SEPARATORS().size());
        this.setInputType(2);
        this.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)SUPPORTED_CHARS));
    }

    public /* synthetic */ SocialSecurityNumberInput(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setSocialSecurityNumber(@NotNull String socialSecurityNumber) {
        Intrinsics.checkNotNullParameter((Object)socialSecurityNumber, (String)"socialSecurityNumber");
        this.setText(SocialSecurityNumberUtils.INSTANCE.formatInput(socialSecurityNumber));
    }

    @Override
    protected void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        String original = editable.toString();
        String formatted = SocialSecurityNumberUtils.INSTANCE.formatInput(original);
        if (!Intrinsics.areEqual((Object)formatted, (Object)original)) {
            editable.replace(0, original.length(), (CharSequence)formatted);
        }
        super.afterTextChanged(editable);
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SocialSecurityNumberInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SocialSecurityNumberInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/SocialSecurityNumberInput$Companion;", "", "()V", "SUPPORTED_CHARS", "", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

