/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.ui.core.databinding.LogoViewHolderBinding;
import com.adyen.checkout.ui.core.databinding.TextViewHolderBinding;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.model.LogoTextItem;
import com.adyen.checkout.ui.core.internal.ui.view.RoundCornerImageView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/LogoTextAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/adyen/checkout/ui/core/internal/ui/model/LogoTextItem;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "localizedContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getItemViewType", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "LogoTextItemDiffCallback", "LogoViewHolder", "TextViewHolder", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LogoTextAdapter
extends ListAdapter<LogoTextItem, RecyclerView.ViewHolder> {
    @NotNull
    private final Context localizedContext;

    public LogoTextAdapter(@NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        super((DiffUtil.ItemCallback)LogoTextItemDiffCallback.INSTANCE);
        this.localizedContext = localizedContext;
    }

    public int getItemViewType(int position) {
        return ((LogoTextItem)this.getCurrentList().get(position)).getViewType().getType();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        int n = viewType;
        if (n == LogoTextItem.LogoTextItemViewType.Logo.getType()) {
            LogoViewHolderBinding logoViewHolderBinding = LogoViewHolderBinding.inflate(inflater, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)logoViewHolderBinding, (String)"inflate(...)");
            viewHolder = new LogoViewHolder(logoViewHolderBinding);
        } else if (n == LogoTextItem.LogoTextItemViewType.Text.getType()) {
            TextViewHolderBinding textViewHolderBinding = TextViewHolderBinding.inflate(inflater, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)textViewHolderBinding, (String)"inflate(...)");
            viewHolder = new TextViewHolder(textViewHolderBinding, this.localizedContext);
        } else {
            throw new CheckoutException("Unexpected viewType on onCreateViewHolder - " + viewType, null, 2, null);
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LogoTextItem item = (LogoTextItem)this.getCurrentList().get(position);
        RecyclerView.ViewHolder viewHolder = holder;
        if (viewHolder instanceof LogoViewHolder) {
            LogoViewHolder logoViewHolder = (LogoViewHolder)holder;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.adyen.checkout.ui.core.internal.ui.model.LogoTextItem.LogoItem");
            logoViewHolder.bind((LogoTextItem.LogoItem)item);
        } else if (viewHolder instanceof TextViewHolder) {
            TextViewHolder textViewHolder = (TextViewHolder)holder;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.adyen.checkout.ui.core.internal.ui.model.LogoTextItem.TextItem");
            textViewHolder.bind((LogoTextItem.TextItem)item);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/LogoTextAdapter$LogoTextItemDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lcom/adyen/checkout/ui/core/internal/ui/model/LogoTextItem;", "()V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "ui-core_release"})
    public static final class LogoTextItemDiffCallback
    extends DiffUtil.ItemCallback<LogoTextItem> {
        @NotNull
        public static final LogoTextItemDiffCallback INSTANCE = new LogoTextItemDiffCallback();

        private LogoTextItemDiffCallback() {
        }

        public boolean areItemsTheSame(@NotNull LogoTextItem oldItem, @NotNull LogoTextItem newItem) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            LogoTextItem logoTextItem = oldItem;
            if (logoTextItem instanceof LogoTextItem.LogoItem) {
                LogoTextItem.LogoItem logoItem = newItem instanceof LogoTextItem.LogoItem ? (LogoTextItem.LogoItem)newItem : null;
                bl = Intrinsics.areEqual((Object)((LogoTextItem.LogoItem)oldItem).getLogoPath(), (Object)(logoItem != null ? logoItem.getLogoPath() : null));
            } else if (logoTextItem instanceof LogoTextItem.TextItem) {
                LogoTextItem.TextItem textItem;
                LogoTextItem.TextItem textItem2 = textItem = newItem instanceof LogoTextItem.TextItem ? (LogoTextItem.TextItem)newItem : null;
                bl = textItem != null ? ((LogoTextItem.TextItem)oldItem).getTextResId() == textItem.getTextResId() : false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        public boolean areContentsTheSame(@NotNull LogoTextItem oldItem, @NotNull LogoTextItem newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            return Intrinsics.areEqual((Object)oldItem, (Object)newItem);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/LogoTextAdapter$LogoViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/adyen/checkout/ui/core/databinding/LogoViewHolderBinding;", "(Lcom/adyen/checkout/ui/core/databinding/LogoViewHolderBinding;)V", "bind", "", "item", "Lcom/adyen/checkout/ui/core/internal/ui/model/LogoTextItem$LogoItem;", "ui-core_release"})
    public static final class LogoViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final LogoViewHolderBinding binding;

        public LogoViewHolder(@NotNull LogoViewHolderBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }

        public final void bind(@NotNull LogoTextItem.LogoItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            RoundCornerImageView roundCornerImageView = this.binding.imageViewBrandLogo;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)roundCornerImageView), (String)"imageViewBrandLogo");
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)roundCornerImageView, item.getEnvironment(), item.getLogoPath(), null, null, null, 0, 0, 124, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/LogoTextAdapter$TextViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/adyen/checkout/ui/core/databinding/TextViewHolderBinding;", "localizedContext", "Landroid/content/Context;", "(Lcom/adyen/checkout/ui/core/databinding/TextViewHolderBinding;Landroid/content/Context;)V", "bind", "", "item", "Lcom/adyen/checkout/ui/core/internal/ui/model/LogoTextItem$TextItem;", "ui-core_release"})
    public static final class TextViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextViewHolderBinding binding;
        @NotNull
        private final Context localizedContext;

        public TextViewHolder(@NotNull TextViewHolderBinding binding, @NotNull Context localizedContext) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
            super((View)binding.getRoot());
            this.binding = binding;
            this.localizedContext = localizedContext;
        }

        public final void bind(@NotNull LogoTextItem.TextItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.binding.textView.setText((CharSequence)this.localizedContext.getString(item.getTextResId()));
        }
    }
}

