/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui.view;

import android.content.Context;
import android.text.Editable;
import android.util.AttributeSet;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.internal.ui.model.ExpiryDateExtKt;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.core.ui.model.ExpiryDate;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/ExpiryDateInput;", "Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "expiryDate", "Lcom/adyen/checkout/core/ui/model/ExpiryDate;", "date", "getDate", "()Lcom/adyen/checkout/core/ui/model/ExpiryDate;", "setDate", "(Lcom/adyen/checkout/core/ui/model/ExpiryDate;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "afterTextChanged", "", "editable", "Landroid/text/Editable;", "fixCalendarYear", "calendar", "Ljava/util/Calendar;", "isStringInt", "", "s", "", "Companion", "ui-core_release"})
@SourceDebugExtension(value={"SMAP\nExpiryDateInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpiryDateInput.kt\ncom/adyen/checkout/ui/core/internal/ui/view/ExpiryDateInput\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,120:1\n16#2,17:121\n21#2,12:138\n16#2,17:150\n*S KotlinDebug\n*F\n+ 1 ExpiryDateInput.kt\ncom/adyen/checkout/ui/core/internal/ui/view/ExpiryDateInput\n*L\n64#1:121,17\n73#1:138,12\n79#1:150,17\n*E\n"})
public final class ExpiryDateInput
extends AdyenTextInputEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    public static final String SEPARATOR = "/";
    @NotNull
    private static final String DATE_FORMAT = "MM/yy";
    private static final int MAX_LENGTH = 5;
    private static final int MAX_SECOND_DIGIT_MONTH = 1;

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ExpiryDateInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ROOT);
        this.enforceMaxInputLength(5);
        this.dateFormat.setLenient(false);
    }

    public /* synthetic */ ExpiryDateInput(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    public void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        String initial = editable.toString();
        CharSequence charSequence = initial;
        Regex regex = new Regex("\\D");
        String string2 = "";
        Object processed = regex.replace(charSequence, string2);
        charSequence = (CharSequence)processed;
        regex = new Regex("(\\d{2})(?=\\d)");
        string2 = "$1/";
        processed = regex.replace(charSequence, string2);
        if (((String)processed).length() == 1 && this.isStringInt((String)processed) && Integer.parseInt((String)processed) > 1) {
            processed = "0" + (String)processed;
        }
        if (!Intrinsics.areEqual((Object)initial, (Object)processed)) {
            editable.replace(0, initial.length(), (CharSequence)processed);
        }
        super.afterTextChanged(editable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExpiryDate getDate() {
        Object object;
        AdyenLogger adyenLogger;
        AdyenLogLevel adyenLogLevel;
        String string2;
        String normalizedExpiryDate = StringUtil.normalize((String)this.getRawValue(), (char[])new char[0]);
        ExpiryDateInput expiryDateInput = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Object throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            adyenLogLevel = level$iv;
            adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            object = "getDate - " + normalizedExpiryDate;
            adyenLogger.log(adyenLogLevel, string2, (String)object, (Throwable)throwable$iv);
        }
        try {
            Date date = this.dateFormat.parse(normalizedExpiryDate);
            if (date == null) {
                throwable$iv = "Required value was null.";
                throw new IllegalArgumentException(throwable$iv.toString());
            }
            Date parsedDate = date;
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(parsedDate);
            Intrinsics.checkNotNull((Object)calendar);
            this.fixCalendarYear(calendar);
            expiryDateInput = new ExpiryDate(calendar.get(2) + 1, calendar.get(1));
        }
        catch (ParseException e) {
            throwable$iv = this;
            AdyenLogLevel level$iv2 = AdyenLogLevel.DEBUG;
            boolean $i$f$adyenLog2 = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                adyenLogLevel = level$iv2;
                adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                object = "getDate - value does not match expected pattern. ";
                adyenLogger.log(adyenLogLevel, string2, (String)object, (Throwable)e);
            }
            expiryDateInput = ((CharSequence)this.getRawValue()).length() == 0 ? ExpiryDateExtKt.EMPTY_DATE : ExpiryDateExtKt.INVALID_DATE;
        }
        return expiryDateInput;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDate(@NotNull ExpiryDate expiryDate) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        if (expiryDate != ExpiryDateExtKt.EMPTY_DATE) {
            ExpiryDateInput expiryDateInput = this;
            AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "setDate - " + expiryDate.getExpiryYear() + " " + expiryDate.getExpiryMonth();
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.clear();
            calendar.set(expiryDate.getExpiryYear(), expiryDate.getExpiryMonth() - 1, 1);
            this.setText(this.dateFormat.format(calendar.getTime()));
        } else {
            this.setText("");
        }
    }

    private final void fixCalendarYear(Calendar calendar) {
        int yearsInCentury = 100;
        Calendar currentCalendar = GregorianCalendar.getInstance();
        int currentCentury = currentCalendar.get(1) / yearsInCentury;
        int calendarCentury = calendar.get(1) / yearsInCentury;
        if (calendarCentury < currentCentury) {
            calendar.add(1, yearsInCentury);
        }
    }

    private final boolean isStringInt(String s) {
        boolean bl;
        try {
            Integer.parseInt(s);
            bl = true;
        }
        catch (NumberFormatException ex) {
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ExpiryDateInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ExpiryDateInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/ExpiryDateInput$Companion;", "", "()V", "DATE_FORMAT", "", "MAX_LENGTH", "", "MAX_SECOND_DIGIT_MONTH", "SEPARATOR", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

