/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIEvent;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 )*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001)B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u0013\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020!H\u0002J\u000e\u0010\u000e\u001a\u00020!2\u0006\u0010\f\u001a\u00020\u000bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;", "ComponentStateT", "Lcom/adyen/checkout/components/core/PaymentComponentState;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroidx/lifecycle/SavedStateHandle;)V", "_uiStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIState;", "<set-?>", "", "isInteractionBlocked", "()Ljava/lang/Boolean;", "setInteractionBlocked", "(Ljava/lang/Boolean;)V", "isInteractionBlocked$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "submitChannel", "Lkotlinx/coroutines/channels/Channel;", "submitFlow", "Lkotlinx/coroutines/flow/Flow;", "getSubmitFlow", "()Lkotlinx/coroutines/flow/Flow;", "uiEventChannel", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIEvent;", "uiEventFlow", "getUiEventFlow", "uiStateFlow", "getUiStateFlow", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "componentStateFlow", "onSubmit", "state", "(Lcom/adyen/checkout/components/core/PaymentComponentState;)V", "resetUIState", "Companion", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SubmitHandler<ComponentStateT extends PaymentComponentState<?>>
implements SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final SavedStateHandleProperty isInteractionBlocked$delegate;
    @NotNull
    private final Channel<ComponentStateT> submitChannel;
    @NotNull
    private final Flow<ComponentStateT> submitFlow;
    @NotNull
    private final MutableStateFlow<PaymentComponentUIState> _uiStateFlow;
    @NotNull
    private final Flow<PaymentComponentUIState> uiStateFlow;
    @NotNull
    private final Channel<PaymentComponentUIEvent> uiEventChannel;
    @NotNull
    private final Flow<PaymentComponentUIEvent> uiEventFlow;
    @NotNull
    public static final String IS_INTERACTION_BLOCKED = "IS_INTERACTION_BLOCKED";

    public SubmitHandler(@NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.savedStateHandle = savedStateHandle;
        this.isInteractionBlocked$delegate = new SavedStateHandleProperty(IS_INTERACTION_BLOCKED);
        this.submitChannel = ChannelExtensionsKt.bufferedChannel();
        this.submitFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submitChannel));
        this._uiStateFlow = StateFlowKt.MutableStateFlow((Object)PaymentComponentUIState.Idle.INSTANCE);
        this.uiStateFlow = (Flow)this._uiStateFlow;
        this.uiEventChannel = ChannelExtensionsKt.bufferedChannel();
        this.uiEventFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.uiEventChannel));
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    private final Boolean isInteractionBlocked() {
        return (Boolean)this.isInteractionBlocked$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setInteractionBlocked(Boolean bl) {
        this.isInteractionBlocked$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)bl);
    }

    @NotNull
    public final Flow<ComponentStateT> getSubmitFlow() {
        return this.submitFlow;
    }

    @NotNull
    public final Flow<PaymentComponentUIState> getUiStateFlow() {
        return this.uiStateFlow;
    }

    @NotNull
    public final Flow<PaymentComponentUIEvent> getUiEventFlow() {
        return this.uiEventFlow;
    }

    public final void initialize(@NotNull CoroutineScope coroutineScope, @NotNull Flow<? extends ComponentStateT> componentStateFlow) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(componentStateFlow, (String)"componentStateFlow");
        Boolean bl = this.isInteractionBlocked();
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            this.setInteractionBlocked(it);
        }
        FlowKt.launchIn((Flow)FlowKt.onEach(componentStateFlow, (Function2)new Function2<ComponentStateT, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SubmitHandler<ComponentStateT> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentComponentState state = (PaymentComponentState)this.L$0;
                        PaymentComponentUIState uiState = (PaymentComponentUIState)SubmitHandler.access$get_uiStateFlow$p(this.this$0).getValue();
                        if (Intrinsics.areEqual((Object)uiState, (Object)PaymentComponentUIState.PendingSubmit.INSTANCE)) {
                            if (state.isValid()) {
                                SubmitHandler.access$getSubmitChannel$p(this.this$0).trySend-JP2dKIU((Object)state);
                            }
                            SubmitHandler.access$resetUIState(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ComponentStateT p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (CoroutineScope)coroutineScope);
    }

    public final void onSubmit(@NotNull ComponentStateT state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (!state.isInputValid()) {
            this.uiEventChannel.trySend-JP2dKIU((Object)PaymentComponentUIEvent.InvalidUI.INSTANCE);
        } else if (state.isValid()) {
            this.submitChannel.trySend-JP2dKIU(state);
        } else if (!state.isReady()) {
            this._uiStateFlow.tryEmit((Object)PaymentComponentUIState.PendingSubmit.INSTANCE);
        } else {
            this.resetUIState();
        }
    }

    public final void setInteractionBlocked(boolean isInteractionBlocked) {
        this.setInteractionBlocked((Boolean)isInteractionBlocked);
        this.resetUIState();
    }

    private final void resetUIState() {
        PaymentComponentUIState paymentComponentUIState;
        Boolean bl = this.isInteractionBlocked();
        if (bl == null) {
            paymentComponentUIState = PaymentComponentUIState.Idle.INSTANCE;
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            paymentComponentUIState = PaymentComponentUIState.Blocked.INSTANCE;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            paymentComponentUIState = PaymentComponentUIState.Idle.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PaymentComponentUIState uiState = paymentComponentUIState;
        this._uiStateFlow.tryEmit((Object)uiState);
    }

    public static final /* synthetic */ MutableStateFlow access$get_uiStateFlow$p(SubmitHandler $this) {
        return $this._uiStateFlow;
    }

    public static final /* synthetic */ Channel access$getSubmitChannel$p(SubmitHandler $this) {
        return $this.submitChannel;
    }

    public static final /* synthetic */ void access$resetUIState(SubmitHandler $this) {
        $this.resetUIState();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SubmitHandler.class, "isInteractionBlocked", "isInteractionBlocked()Ljava/lang/Boolean;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler$Companion;", "", "()V", "IS_INTERACTION_BLOCKED", "", "getIS_INTERACTION_BLOCKED$ui_core_release$annotations", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getIS_INTERACTION_BLOCKED$ui_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

