/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.adyen.checkout.components.core.AddressData;
import com.adyen.checkout.components.core.AddressDataKt;
import com.adyen.checkout.components.core.AddressLookupCallback;
import com.adyen.checkout.components.core.AddressLookupResult;
import com.adyen.checkout.components.core.LookupAddress;
import com.adyen.checkout.components.core.internal.ui.model.AddressInputModel;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.ui.core.internal.data.api.AddressRepository;
import com.adyen.checkout.ui.core.internal.data.model.AddressItem;
import com.adyen.checkout.ui.core.internal.ui.AddressDelegate;
import com.adyen.checkout.ui.core.internal.ui.AddressFormUIState;
import com.adyen.checkout.ui.core.internal.ui.AddressLookupDelegate;
import com.adyen.checkout.ui.core.internal.ui.model.AddressListItem;
import com.adyen.checkout.ui.core.internal.ui.model.AddressLookupEvent;
import com.adyen.checkout.ui.core.internal.ui.model.AddressLookupInputData;
import com.adyen.checkout.ui.core.internal.ui.model.AddressLookupState;
import com.adyen.checkout.ui.core.internal.ui.model.AddressOutputData;
import com.adyen.checkout.ui.core.internal.ui.model.AddressParams;
import com.adyen.checkout.ui.core.internal.ui.view.LookupOption;
import com.adyen.checkout.ui.core.internal.util.AddressFormUtils;
import com.adyen.checkout.ui.core.internal.util.AddressValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00104\u001a\u000205H\u0016J$\u00106\u001a\u00020\n2\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020908H\u0002J(\u0010;\u001a\u0002052\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u000209082\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u00020908H\u0002J\b\u0010<\u001a\u00020\u001fH\u0002J\b\u0010=\u001a\u00020\u001fH\u0002J\u0010\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020\u001fH\u0002J\b\u0010B\u001a\u00020\u001fH\u0002J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u0002052\u0006\u0010)\u001a\u00020*2\u0006\u0010J\u001a\u00020\"H\u0016J\u0010\u0010K\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u0018H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u0002052\u0006\u0010Q\u001a\u00020\u0012H\u0016J\b\u0010R\u001a\u000205H\u0016J\u0010\u0010S\u001a\u0002052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010T\u001a\u0002052\u0006\u0010U\u001a\u00020\u0012H\u0002J\u0010\u0010V\u001a\u0002052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010W\u001a\u0002052\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u000205H\u0016J\u0010\u0010[\u001a\u0002052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010\\\u001a\u0002052\u0006\u0010)\u001a\u00020*H\u0002J!\u0010]\u001a\u0002052\u0017\u0010^\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002050_\u00a2\u0006\u0002\b`H\u0016J\u0016\u0010a\u001a\u0002052\f\u0010b\u001a\b\u0012\u0004\u0012\u00020O08H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0014\u0010$\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\"\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001f0\t8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b/\u00100\u001a\u0004\b1\u00102R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\"0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/DefaultAddressLookupDelegate;", "Lcom/adyen/checkout/ui/core/internal/ui/AddressLookupDelegate;", "Lcom/adyen/checkout/ui/core/internal/ui/AddressDelegate;", "addressRepository", "Lcom/adyen/checkout/ui/core/internal/data/api/AddressRepository;", "shopperLocale", "Ljava/util/Locale;", "(Lcom/adyen/checkout/ui/core/internal/data/api/AddressRepository;Ljava/util/Locale;)V", "_addressOutputDataFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressOutputData;", "addressDelegate", "getAddressDelegate", "()Lcom/adyen/checkout/ui/core/internal/ui/AddressDelegate;", "addressLookupCallback", "Lcom/adyen/checkout/components/core/AddressLookupCallback;", "addressLookupErrorPopupChannel", "Lkotlinx/coroutines/channels/Channel;", "", "addressLookupErrorPopupFlow", "Lkotlinx/coroutines/flow/Flow;", "getAddressLookupErrorPopupFlow", "()Lkotlinx/coroutines/flow/Flow;", "addressLookupEventChannel", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupEvent;", "getAddressLookupEventChannel", "()Lkotlinx/coroutines/channels/Channel;", "addressLookupEventFlow", "addressLookupInputData", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupInputData;", "addressLookupStateFlow", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupState;", "getAddressLookupStateFlow", "addressLookupSubmitFlow", "Lcom/adyen/checkout/components/core/internal/ui/model/AddressInputModel;", "getAddressLookupSubmitFlow", "addressOutputData", "getAddressOutputData", "()Lcom/adyen/checkout/ui/core/internal/ui/model/AddressOutputData;", "addressOutputDataFlow", "getAddressOutputDataFlow", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentAddressLookupState", "getCurrentAddressLookupState", "()Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupState;", "mutableAddressLookupStateFlow", "getMutableAddressLookupStateFlow$ui_core_release$annotations", "()V", "getMutableAddressLookupStateFlow$ui_core_release", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "submitAddressChannel", "clear", "", "createOutputData", "countryOptions", "", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressListItem;", "stateOptions", "emitOutputData", "handleClearQueryEvent", "handleErrorEvent", "handleInitializeEvent", "event", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupEvent$Initialize;", "handleInvalidUIEvent", "handleManualEvent", "handleOptionSelectedEvent", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupEvent$OptionSelected;", "handleQueryEvent", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupEvent$Query;", "handleSearchResultEvent", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressLookupEvent$SearchResult;", "initialize", "addressInputModel", "makeAddressLookupState", "onAddressLookupCompletion", "", "lookupAddress", "Lcom/adyen/checkout/components/core/LookupAddress;", "onAddressQueryChanged", "query", "onManualEntryModeSelected", "requestCountryList", "requestStatesList", "countryCode", "setAddressLookupCallback", "setAddressLookupResult", "addressLookupResult", "Lcom/adyen/checkout/components/core/AddressLookupResult;", "submitAddress", "subscribeToCountryList", "subscribeToStateList", "updateAddressInputData", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "updateAddressLookupOptions", "options", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultAddressLookupDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAddressLookupDelegate.kt\ncom/adyen/checkout/ui/core/internal/ui/DefaultAddressLookupDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n16#2,17:356\n16#2,17:373\n1557#3:390\n1628#3,3:391\n1557#3:394\n1628#3,3:395\n1557#3:398\n1628#3,3:399\n*S KotlinDebug\n*F\n+ 1 DefaultAddressLookupDelegate.kt\ncom/adyen/checkout/ui/core/internal/ui/DefaultAddressLookupDelegate\n*L\n127#1:356,17\n151#1:373,17\n271#1:390\n271#1:391,3\n288#1:394\n288#1:395,3\n317#1:398\n317#1:399,3\n*E\n"})
public final class DefaultAddressLookupDelegate
implements AddressLookupDelegate,
AddressDelegate {
    @NotNull
    private final AddressRepository addressRepository;
    @NotNull
    private final Locale shopperLocale;
    @Nullable
    private CoroutineScope coroutineScope;
    @NotNull
    private final AddressDelegate addressDelegate;
    @Nullable
    private AddressLookupCallback addressLookupCallback;
    @NotNull
    private final AddressLookupInputData addressLookupInputData;
    @NotNull
    private final MutableStateFlow<AddressLookupState> mutableAddressLookupStateFlow;
    @NotNull
    private final Flow<AddressLookupState> addressLookupStateFlow;
    @NotNull
    private final Channel<AddressLookupEvent> addressLookupEventChannel;
    @NotNull
    private final Flow<AddressLookupEvent> addressLookupEventFlow;
    @NotNull
    private final MutableStateFlow<AddressOutputData> _addressOutputDataFlow;
    @NotNull
    private final Flow<AddressOutputData> addressOutputDataFlow;
    @NotNull
    private final Channel<AddressInputModel> submitAddressChannel;
    @NotNull
    private final Flow<AddressInputModel> addressLookupSubmitFlow;
    @NotNull
    private final Channel<String> addressLookupErrorPopupChannel;
    @NotNull
    private final Flow<String> addressLookupErrorPopupFlow;

    public DefaultAddressLookupDelegate(@NotNull AddressRepository addressRepository, @NotNull Locale shopperLocale) {
        Intrinsics.checkNotNullParameter((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        this.addressRepository = addressRepository;
        this.shopperLocale = shopperLocale;
        this.addressDelegate = this;
        this.addressLookupInputData = new AddressLookupInputData(null, null, 3, null);
        this.mutableAddressLookupStateFlow = StateFlowKt.MutableStateFlow((Object)AddressLookupState.Initial.INSTANCE);
        this.addressLookupStateFlow = (Flow)this.mutableAddressLookupStateFlow;
        this.addressLookupEventChannel = ChannelExtensionsKt.bufferedChannel();
        this.addressLookupEventFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.getAddressLookupEventChannel()));
        this._addressOutputDataFlow = StateFlowKt.MutableStateFlow((Object)AddressValidationUtils.INSTANCE.validateAddressInput(this.addressLookupInputData.getSelectedAddress(), AddressFormUIState.LOOKUP, CollectionsKt.emptyList(), CollectionsKt.emptyList(), false));
        this.addressOutputDataFlow = (Flow)this._addressOutputDataFlow;
        this.submitAddressChannel = ChannelExtensionsKt.bufferedChannel();
        this.addressLookupSubmitFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submitAddressChannel));
        this.addressLookupErrorPopupChannel = ChannelExtensionsKt.bufferedChannel();
        this.addressLookupErrorPopupFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.addressLookupErrorPopupChannel));
    }

    @Override
    @NotNull
    public AddressDelegate getAddressDelegate() {
        return this.addressDelegate;
    }

    @NotNull
    public final MutableStateFlow<AddressLookupState> getMutableAddressLookupStateFlow$ui_core_release() {
        return this.mutableAddressLookupStateFlow;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMutableAddressLookupStateFlow$ui_core_release$annotations() {
    }

    @Override
    @NotNull
    public Flow<AddressLookupState> getAddressLookupStateFlow() {
        return this.addressLookupStateFlow;
    }

    private final AddressLookupState getCurrentAddressLookupState() {
        return (AddressLookupState)this.mutableAddressLookupStateFlow.getValue();
    }

    @Override
    @NotNull
    public Channel<AddressLookupEvent> getAddressLookupEventChannel() {
        return this.addressLookupEventChannel;
    }

    @Override
    @NotNull
    public AddressOutputData getAddressOutputData() {
        return (AddressOutputData)this._addressOutputDataFlow.getValue();
    }

    @Override
    @NotNull
    public Flow<AddressOutputData> getAddressOutputDataFlow() {
        return this.addressOutputDataFlow;
    }

    @Override
    @NotNull
    public Flow<AddressInputModel> getAddressLookupSubmitFlow() {
        return this.addressLookupSubmitFlow;
    }

    @Override
    @NotNull
    public Flow<String> getAddressLookupErrorPopupFlow() {
        return this.addressLookupErrorPopupFlow;
    }

    @Override
    public void initialize(@NotNull CoroutineScope coroutineScope, @NotNull AddressInputModel addressInputModel) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)addressInputModel, (String)"addressInputModel");
        this.coroutineScope = coroutineScope;
        FlowKt.launchIn((Flow)FlowKt.onEach(this.addressLookupEventFlow, (Function2)((Function2)new Function2<AddressLookupEvent, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAddressLookupDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        addressLookupEvent = (AddressLookupEvent)this.L$0;
                        this.L$0 = addressLookupEvent;
                        this.label = 1;
                        v0 = this.this$0.getMutableAddressLookupStateFlow$ui_core_release().emit((Object)DefaultAddressLookupDelegate.access$makeAddressLookupState(this.this$0, addressLookupEvent), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        addressLookupEvent = (AddressLookupEvent)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (addressLookupEvent instanceof AddressLookupEvent.ErrorResult) {
                            DefaultAddressLookupDelegate.access$getAddressLookupErrorPopupChannel$p(this.this$0).trySend-JP2dKIU((Object)((AddressLookupEvent.ErrorResult)addressLookupEvent).getMessage());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull AddressLookupEvent p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
        this.subscribeToCountryList(coroutineScope);
        this.subscribeToStateList(coroutineScope);
        this.requestCountryList(coroutineScope);
        this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.Initialize(addressInputModel));
    }

    private final void subscribeToCountryList(CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach(this.addressRepository.getCountriesFlow(), (Function2)((Function2)new Function2<List<? extends AddressItem>, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAddressLookupDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List it = (List)this.L$0;
                        DefaultAddressLookupDelegate defaultAddressLookupDelegate = this.this$0;
                        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
                        Throwable throwable$iv = null;
                        boolean $i$f$adyenLog = false;
                        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                            String tag$iv;
                            void $this$adyenLog_u24default$iv;
                            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                            Intrinsics.checkNotNull((Object)fullClassName$iv);
                            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                            AdyenLogLevel adyenLogLevel = level$iv;
                            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                            boolean bl = false;
                            String string3 = "country flow";
                            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
                        }
                        List<AddressListItem> countryOptions = AddressFormUtils.INSTANCE.initializeCountryOptions(DefaultAddressLookupDelegate.access$getShopperLocale$p(this.this$0), new AddressParams.Lookup(), it);
                        DefaultAddressLookupDelegate.emitOutputData$default(this.this$0, AddressFormUtils.INSTANCE.markAddressListItemSelected(countryOptions, DefaultAddressLookupDelegate.access$getAddressLookupInputData$p(this.this$0).getSelectedAddress().getCountry()), null, 2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull List<AddressItem> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void requestCountryList(CoroutineScope coroutineScope) {
        DefaultAddressLookupDelegate defaultAddressLookupDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "requesting countries";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        this.addressRepository.getCountryList(this.shopperLocale, coroutineScope);
    }

    private final void subscribeToStateList(CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach(this.addressRepository.getStatesFlow(), (Function2)((Function2)new Function2<List<? extends AddressItem>, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAddressLookupDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List it = (List)this.L$0;
                        DefaultAddressLookupDelegate defaultAddressLookupDelegate = this.this$0;
                        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
                        Throwable throwable$iv = null;
                        boolean $i$f$adyenLog = false;
                        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                            String tag$iv;
                            void $this$adyenLog_u24default$iv;
                            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                            Intrinsics.checkNotNull((Object)fullClassName$iv);
                            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                            AdyenLogLevel adyenLogLevel = level$iv;
                            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                            boolean bl = false;
                            String string3 = "state flow " + it;
                            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
                        }
                        List<AddressListItem> stateOptions = AddressFormUtils.INSTANCE.initializeStateOptions(it);
                        DefaultAddressLookupDelegate.access$emitOutputData(this.this$0, AddressFormUtils.INSTANCE.markAddressListItemSelected(this.this$0.getAddressOutputData().getCountryOptions(), DefaultAddressLookupDelegate.access$getAddressLookupInputData$p(this.this$0).getSelectedAddress().getCountry()), AddressFormUtils.INSTANCE.markAddressListItemSelected(stateOptions, DefaultAddressLookupDelegate.access$getAddressLookupInputData$p(this.this$0).getSelectedAddress().getStateOrProvince()));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull List<AddressItem> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void requestStatesList(String countryCode) {
        Unit unit;
        DefaultAddressLookupDelegate defaultAddressLookupDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "requesting states for " + countryCode;
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope != null) {
            CoroutineScope it = coroutineScope;
            boolean bl = false;
            this.addressRepository.getStateList(this.shopperLocale, countryCode, it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new CheckoutException("Coroutine scope hasn't been initalized.", null, 2, null);
        }
    }

    @Override
    public void onAddressQueryChanged(@NotNull String query) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            if (((CharSequence)query).length() == 0) {
                this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)AddressLookupEvent.ClearQuery.INSTANCE);
            } else {
                this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.Query(query));
            }
            AddressLookupCallback addressLookupCallback = this.addressLookupCallback;
            if (addressLookupCallback == null) break block2;
            addressLookupCallback.onQueryChanged(query);
        }
    }

    @Override
    public boolean onAddressLookupCompletion(@NotNull LookupAddress lookupAddress) {
        Intrinsics.checkNotNullParameter((Object)lookupAddress, (String)"lookupAddress");
        AddressLookupCallback addressLookupCallback = this.addressLookupCallback;
        boolean isLoading = addressLookupCallback != null ? addressLookupCallback.onLookupCompletion(lookupAddress) : false;
        this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.OptionSelected(lookupAddress, isLoading));
        return isLoading;
    }

    @Override
    public void onManualEntryModeSelected() {
        this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)AddressLookupEvent.Manual.INSTANCE);
    }

    @Override
    public void submitAddress() {
        if (this.getAddressDelegate().getAddressOutputData().isValid()) {
            this.submitAddressChannel.trySend-JP2dKIU((Object)this.addressLookupInputData.getSelectedAddress());
        } else {
            this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)AddressLookupEvent.InvalidUI.INSTANCE);
        }
    }

    @Override
    public void updateAddressLookupOptions(@NotNull List<LookupAddress> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.SearchResult(options));
    }

    @Override
    public void setAddressLookupResult(@NotNull AddressLookupResult addressLookupResult) {
        Intrinsics.checkNotNullParameter((Object)addressLookupResult, (String)"addressLookupResult");
        AddressLookupResult addressLookupResult2 = addressLookupResult;
        if (addressLookupResult2 instanceof AddressLookupResult.Error) {
            this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.ErrorResult(((AddressLookupResult.Error)addressLookupResult).getMessage()));
        } else if (addressLookupResult2 instanceof AddressLookupResult.Completed) {
            this.getAddressLookupEventChannel().trySend-JP2dKIU((Object)new AddressLookupEvent.OptionSelected(((AddressLookupResult.Completed)addressLookupResult).getLookupAddress(), false));
        }
    }

    @Override
    public void setAddressLookupCallback(@NotNull AddressLookupCallback addressLookupCallback) {
        Intrinsics.checkNotNullParameter((Object)addressLookupCallback, (String)"addressLookupCallback");
        this.addressLookupCallback = addressLookupCallback;
    }

    private final AddressLookupState makeAddressLookupState(AddressLookupEvent event) {
        AddressLookupState addressLookupState;
        AddressLookupEvent addressLookupEvent = event;
        if (addressLookupEvent instanceof AddressLookupEvent.Initialize) {
            addressLookupState = this.handleInitializeEvent((AddressLookupEvent.Initialize)event);
        } else if (addressLookupEvent instanceof AddressLookupEvent.Query) {
            addressLookupState = this.handleQueryEvent((AddressLookupEvent.Query)event);
        } else if (Intrinsics.areEqual((Object)addressLookupEvent, (Object)AddressLookupEvent.ClearQuery.INSTANCE)) {
            addressLookupState = this.handleClearQueryEvent();
        } else if (Intrinsics.areEqual((Object)addressLookupEvent, (Object)AddressLookupEvent.Manual.INSTANCE)) {
            addressLookupState = this.handleManualEvent();
        } else if (addressLookupEvent instanceof AddressLookupEvent.SearchResult) {
            addressLookupState = this.handleSearchResultEvent((AddressLookupEvent.SearchResult)event);
        } else if (addressLookupEvent instanceof AddressLookupEvent.OptionSelected) {
            addressLookupState = this.handleOptionSelectedEvent((AddressLookupEvent.OptionSelected)event);
        } else if (addressLookupEvent instanceof AddressLookupEvent.InvalidUI) {
            addressLookupState = this.handleInvalidUIEvent();
        } else if (addressLookupEvent instanceof AddressLookupEvent.ErrorResult) {
            addressLookupState = this.handleErrorEvent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return addressLookupState;
    }

    private final AddressLookupState handleInitializeEvent(AddressLookupEvent.Initialize event) {
        this.addressLookupInputData.getSelectedAddress().set(event.getAddress());
        return event.getAddress().isEmpty() ? (AddressLookupState)AddressLookupState.Initial.INSTANCE : (AddressLookupState)new AddressLookupState.Form(event.getAddress());
    }

    private final AddressLookupState handleQueryEvent(AddressLookupEvent.Query event) {
        this.addressLookupInputData.setQuery(event.getQuery());
        return AddressLookupState.Loading.INSTANCE;
    }

    private final AddressLookupState handleClearQueryEvent() {
        return !this.addressLookupInputData.getSelectedAddress().isEmpty() ? (AddressLookupState)new AddressLookupState.Form(this.addressLookupInputData.getSelectedAddress()) : (AddressLookupState)AddressLookupState.Initial.INSTANCE;
    }

    private final AddressLookupState handleManualEvent() {
        return this.getCurrentAddressLookupState() instanceof AddressLookupState.Initial || this.getCurrentAddressLookupState() instanceof AddressLookupState.Error || this.getCurrentAddressLookupState() instanceof AddressLookupState.SearchResult ? (AddressLookupState)new AddressLookupState.Form(null) : this.getCurrentAddressLookupState();
    }

    /*
     * WARNING - void declaration
     */
    private final AddressLookupState handleSearchResultEvent(AddressLookupEvent.SearchResult event) {
        AddressLookupState addressLookupState;
        if (this.getCurrentAddressLookupState() instanceof AddressLookupState.Loading) {
            if (event.getAddressLookupOptions().isEmpty()) {
                addressLookupState = new AddressLookupState.Error(this.addressLookupInputData.getQuery());
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = event.getAddressLookupOptions();
                String string2 = this.addressLookupInputData.getQuery();
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LookupAddress lookupAddress = (LookupAddress)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new LookupOption((LookupAddress)it, false));
                }
                List list = (List)destination$iv$iv;
                String string3 = string2;
                addressLookupState = new AddressLookupState.SearchResult(string3, list);
            }
        } else {
            addressLookupState = this.getCurrentAddressLookupState();
        }
        return addressLookupState;
    }

    /*
     * WARNING - void declaration
     */
    private final AddressLookupState handleOptionSelectedEvent(AddressLookupEvent.OptionSelected event) {
        AddressLookupState addressLookupState;
        if (this.getCurrentAddressLookupState() instanceof AddressLookupState.SearchResult) {
            if (event.getLoading()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                AddressLookupState addressLookupState2 = this.getCurrentAddressLookupState();
                Intrinsics.checkNotNull((Object)addressLookupState2, (String)"null cannot be cast to non-null type com.adyen.checkout.ui.core.internal.ui.model.AddressLookupState.SearchResult");
                String string2 = ((AddressLookupState.SearchResult)addressLookupState2).getQuery();
                AddressLookupState addressLookupState3 = this.getCurrentAddressLookupState();
                Intrinsics.checkNotNull((Object)addressLookupState3, (String)"null cannot be cast to non-null type com.adyen.checkout.ui.core.internal.ui.model.AddressLookupState.SearchResult");
                Iterable iterable = ((AddressLookupState.SearchResult)addressLookupState3).getOptions();
                String string3 = string2;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LookupOption lookupOption = (LookupOption)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new LookupOption(it.getLookupAddress(), Intrinsics.areEqual((Object)it.getLookupAddress(), (Object)event.getLookupAddress())));
                }
                List list = (List)destination$iv$iv;
                String string4 = string3;
                addressLookupState = new AddressLookupState.SearchResult(string4, list);
            } else {
                addressLookupState = new AddressLookupState.Form(AddressDataKt.mapToAddressInputModel((AddressData)event.getLookupAddress().getAddress()));
            }
        } else {
            addressLookupState = this.getCurrentAddressLookupState();
        }
        return addressLookupState;
    }

    private final AddressLookupState handleInvalidUIEvent() {
        return this.getCurrentAddressLookupState() instanceof AddressLookupState.Form ? (AddressLookupState)AddressLookupState.InvalidUI.INSTANCE : this.getCurrentAddressLookupState();
    }

    /*
     * WARNING - void declaration
     */
    private final AddressLookupState handleErrorEvent() {
        AddressLookupState addressLookupState;
        if (this.getCurrentAddressLookupState() instanceof AddressLookupState.SearchResult) {
            List list;
            List list2;
            AddressLookupState.SearchResult searchResult;
            Object object = this.getCurrentAddressLookupState();
            AddressLookupState.SearchResult searchResult2 = object instanceof AddressLookupState.SearchResult ? (AddressLookupState.SearchResult)object : null;
            String string2 = searchResult2 != null ? searchResult2.getQuery() : null;
            if (string2 == null) {
                string2 = "";
            }
            AddressLookupState.SearchResult searchResult3 = searchResult = (object = this.getCurrentAddressLookupState()) instanceof AddressLookupState.SearchResult ? (AddressLookupState.SearchResult)object : null;
            if (searchResult != null && (object = searchResult.getOptions()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)object;
                String string3 = string2;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LookupOption lookupOption = (LookupOption)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LookupOption.copy$default((LookupOption)it, null, false, 1, null));
                }
                list2 = (List)destination$iv$iv;
                string2 = string3;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            List list3 = list;
            String string4 = string2;
            addressLookupState = new AddressLookupState.SearchResult(string4, list3);
        } else {
            addressLookupState = this.getCurrentAddressLookupState();
        }
        return addressLookupState;
    }

    @Override
    public void updateAddressInputData(@NotNull Function1<? super AddressInputModel, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        update.invoke((Object)this.addressLookupInputData.getSelectedAddress());
        this.requestStatesList(this.addressLookupInputData.getSelectedAddress().getCountry());
        DefaultAddressLookupDelegate.emitOutputData$default(this, null, null, 3, null);
    }

    private final AddressOutputData createOutputData(List<AddressListItem> countryOptions, List<AddressListItem> stateOptions) {
        return AddressValidationUtils.INSTANCE.validateAddressInput(this.addressLookupInputData.getSelectedAddress(), AddressFormUIState.LOOKUP, countryOptions, stateOptions, false);
    }

    private final void emitOutputData(List<AddressListItem> countryOptions, List<AddressListItem> stateOptions) {
        this._addressOutputDataFlow.tryEmit((Object)this.createOutputData(countryOptions, stateOptions));
    }

    static /* synthetic */ void emitOutputData$default(DefaultAddressLookupDelegate defaultAddressLookupDelegate, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = defaultAddressLookupDelegate.getAddressOutputData().getCountryOptions();
        }
        if ((n & 2) != 0) {
            list2 = defaultAddressLookupDelegate.getAddressOutputData().getStateOptions();
        }
        defaultAddressLookupDelegate.emitOutputData(list, list2);
    }

    @Override
    public void clear() {
        this.coroutineScope = null;
    }

    public static final /* synthetic */ AddressLookupState access$makeAddressLookupState(DefaultAddressLookupDelegate $this, AddressLookupEvent event) {
        return $this.makeAddressLookupState(event);
    }

    public static final /* synthetic */ Channel access$getAddressLookupErrorPopupChannel$p(DefaultAddressLookupDelegate $this) {
        return $this.addressLookupErrorPopupChannel;
    }

    public static final /* synthetic */ Locale access$getShopperLocale$p(DefaultAddressLookupDelegate $this) {
        return $this.shopperLocale;
    }

    public static final /* synthetic */ AddressLookupInputData access$getAddressLookupInputData$p(DefaultAddressLookupDelegate $this) {
        return $this.addressLookupInputData;
    }

    public static final /* synthetic */ void access$emitOutputData(DefaultAddressLookupDelegate $this, List countryOptions, List stateOptions) {
        $this.emitOutputData(countryOptions, stateOptions);
    }
}

